/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.ModWorldgen;
import androsa.gaiadimension.world.gen.structure.processor.MiniTowerType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class BlockDegradeProcessor
extends StructureProcessor {
    public static final BlockDegradeProcessor AMETHYST_DECAY = new BlockDegradeProcessor(MiniTowerType.AMETHYST, 0.55f);
    public static final BlockDegradeProcessor COPAL_DECAY = new BlockDegradeProcessor(MiniTowerType.COPAL, 0.55f);
    public static final BlockDegradeProcessor JADE_DECAY = new BlockDegradeProcessor(MiniTowerType.JADE, 0.55f);
    public static final BlockDegradeProcessor JET_DECAY = new BlockDegradeProcessor(MiniTowerType.JET, 0.55f);
    public static final Codec<BlockDegradeProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiniTowerType.CODEC.fieldOf("towertype").orElse((Object)MiniTowerType.AMETHYST).forGetter(obj -> obj.towertype), (App)Codec.FLOAT.fieldOf("integrity").orElse((Object)Float.valueOf(1.0f)).forGetter(obj -> Float.valueOf(obj.integrity))).apply((Applicative)instance, BlockDegradeProcessor::new));
    private final MiniTowerType towertype;
    private final float integrity;
    private static final Random random = new Random();

    public BlockDegradeProcessor(MiniTowerType type, float integrity) {
        this.towertype = type;
        this.integrity = integrity;
    }

    protected IStructureProcessorType func_215192_a() {
        return ModWorldgen.StructureTypes.BLOCK_DEGRADE;
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, BlockPos tpos, Template.BlockInfo oldInfo, Template.BlockInfo newInfo, PlacementSettings settings, @Nullable Template template) {
        BlockState state = newInfo.field_186243_b;
        if (state == this.towertype.getBrick()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, this.towertype.getBrickDecay(random), null);
        }
        if (state == this.towertype.getSlab()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, BlockDegradeProcessor.translateState(state, this.towertype.getSlabDecay(random).func_177230_c(), new Property[]{SlabBlock.field_196505_a, SlabBlock.field_204512_b}), null);
        }
        if (state == this.towertype.getStairs()) {
            return random.nextFloat() > this.integrity ? newInfo : new Template.BlockInfo(newInfo.field_186242_a, BlockDegradeProcessor.translateState(state, this.towertype.getStairsDecay(random).func_177230_c(), new Property[]{StairsBlock.field_176309_a, StairsBlock.field_176308_b, StairsBlock.field_176310_M, StairsBlock.field_204513_t}), null);
        }
        return newInfo;
    }

    protected static BlockState translateState(BlockState stateIn, Block blockOut, Property<?> ... properties) {
        BlockState stateOut = blockOut.func_176223_P();
        for (Property<?> property : properties) {
            stateOut = BlockDegradeProcessor.copyValue(stateIn, stateOut, property);
        }
        return stateOut;
    }

    private static <T extends Comparable<T>> BlockState copyValue(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
    }
}

