/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.processor;

import androsa.gaiadimension.registry.GaiaChestTables;
import androsa.gaiadimension.registry.ModBlocks;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public enum MiniTowerType implements IStringSerializable
{
    AMETHYST("AMETHYST", GaiaChestTables.CHESTS_MINITOWER_AMETHYST, ModBlocks.amethyst_bricks, (ImmutableList<Block>)ImmutableList.of((Object)ModBlocks.cracked_amethyst_bricks, (Object)ModBlocks.crusted_amethyst_bricks), ModBlocks.amethyst_brick_stairs, (ImmutableList<StairsBlock>)ImmutableList.of((Object)ModBlocks.cracked_amethyst_brick_stairs, (Object)ModBlocks.crusted_amethyst_brick_stairs), ModBlocks.amethyst_brick_slab, (ImmutableList<SlabBlock>)ImmutableList.of((Object)ModBlocks.cracked_amethyst_brick_slab, (Object)ModBlocks.crusted_amethyst_brick_slab)),
    COPAL("COPAL", GaiaChestTables.CHESTS_MINITOWER_COPAL, ModBlocks.copal_bricks, (ImmutableList<Block>)ImmutableList.of((Object)ModBlocks.cracked_copal_bricks, (Object)ModBlocks.crusted_copal_bricks), ModBlocks.copal_brick_stairs, (ImmutableList<StairsBlock>)ImmutableList.of((Object)ModBlocks.cracked_copal_brick_stairs, (Object)ModBlocks.crusted_copal_brick_stairs), ModBlocks.copal_brick_slab, (ImmutableList<SlabBlock>)ImmutableList.of((Object)ModBlocks.cracked_copal_brick_slab, (Object)ModBlocks.crusted_copal_brick_slab)),
    JADE("JADE", GaiaChestTables.CHESTS_MINITOWER_JADE, ModBlocks.jade_bricks, (ImmutableList<Block>)ImmutableList.of((Object)ModBlocks.cracked_jade_bricks, (Object)ModBlocks.crusted_jade_bricks), ModBlocks.jade_brick_stairs, (ImmutableList<StairsBlock>)ImmutableList.of((Object)ModBlocks.cracked_jade_brick_stairs, (Object)ModBlocks.crusted_jade_brick_stairs), ModBlocks.jade_brick_slab, (ImmutableList<SlabBlock>)ImmutableList.of((Object)ModBlocks.cracked_jade_brick_slab, (Object)ModBlocks.crusted_jade_brick_slab)),
    JET("JET", GaiaChestTables.CHESTS_MINITOWER_JET, ModBlocks.jet_bricks, (ImmutableList<Block>)ImmutableList.of((Object)ModBlocks.cracked_jet_bricks, (Object)ModBlocks.crusted_jet_bricks), ModBlocks.jet_brick_stairs, (ImmutableList<StairsBlock>)ImmutableList.of((Object)ModBlocks.cracked_jet_brick_stairs, (Object)ModBlocks.crusted_jet_brick_stairs), ModBlocks.jet_brick_slab, (ImmutableList<SlabBlock>)ImmutableList.of((Object)ModBlocks.cracked_jet_brick_slab, (Object)ModBlocks.crusted_jet_brick_slab));

    public static final Codec<MiniTowerType> CODEC;
    private final String name;
    private final ResourceLocation chestLoot;
    private final Block brickBlock;
    private final ImmutableList<Block> brickDegrades;
    private final StairsBlock stairsBlock;
    private final ImmutableList<StairsBlock> stairsDegrades;
    private final SlabBlock slabBlock;
    private final ImmutableList<SlabBlock> slabDegrades;
    private static final Map<String, MiniTowerType> typeid;

    private MiniTowerType(String name, ResourceLocation loot, Block brick, ImmutableList<Block> breakbricks, StairsBlock stairs, ImmutableList<StairsBlock> breakstairs, SlabBlock slab, ImmutableList<SlabBlock> breakslab) {
        this.name = name;
        this.chestLoot = loot;
        this.brickBlock = brick;
        this.brickDegrades = breakbricks;
        this.stairsBlock = stairs;
        this.stairsDegrades = breakstairs;
        this.slabBlock = slab;
        this.slabDegrades = breakslab;
    }

    public static MiniTowerType getType(String name) {
        return typeid.get(name);
    }

    public String func_176610_l() {
        return this.name;
    }

    public ResourceLocation getChestLoot() {
        return this.chestLoot;
    }

    public BlockState getBrick() {
        return this.brickBlock.func_176223_P();
    }

    public BlockState getBrickDecay(Random rand) {
        return ((Block)this.brickDegrades.get(rand.nextInt(this.brickDegrades.size()))).func_176223_P();
    }

    public BlockState getStairs() {
        return this.stairsBlock.func_176223_P();
    }

    public BlockState getStairsDecay(Random rand) {
        return ((StairsBlock)this.stairsDegrades.get(rand.nextInt(this.stairsDegrades.size()))).func_176223_P();
    }

    public BlockState getSlab() {
        return this.slabBlock.func_176223_P();
    }

    public BlockState getSlabDecay(Random rand) {
        return ((SlabBlock)this.slabDegrades.get(rand.nextInt(this.slabDegrades.size()))).func_176223_P();
    }

    static {
        CODEC = IStringSerializable.func_233023_a_(MiniTowerType::values, MiniTowerType::getType);
        typeid = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashmap -> {
            for (MiniTowerType type : MiniTowerType.values()) {
                hashmap.put(type.name, type);
            }
        });
    }
}

