/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.layer.Layer;

public class GaiaBiomeProvider
extends BiomeProvider {
    public static final Codec<GaiaBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElse((Object)new Random().nextLong()).forGetter(obj -> obj.seed), (App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(obj -> obj.registry)).apply((Applicative)instance, instance.stable(GaiaBiomeProvider::new)));
    private final long seed;
    private final Registry<Biome> registry;
    private final Layer genBiomes;
    private static final List<RegistryKey<Biome>> biomes = ImmutableList.of(ModBiomes.pink_agate_forest, ModBiomes.blue_agate_taiga, ModBiomes.green_agate_jungle, ModBiomes.purple_agate_swamp, ModBiomes.fossil_woodland, ModBiomes.mutant_agate_wildwood, ModBiomes.volcanic_lands, ModBiomes.static_wasteland, ModBiomes.goldstone_lands, ModBiomes.crystal_plains, ModBiomes.salt_dunes, ModBiomes.shining_grove, (Object[])new RegistryKey[]{ModBiomes.smoldering_bog, ModBiomes.mineral_reservoir, ModBiomes.mineral_river});

    public GaiaBiomeProvider(long seed, Registry<Biome> registry) {
        super(biomes.stream().map(key -> () -> (Biome)registry.func_243576_d(key)));
        this.seed = seed;
        this.registry = registry;
        this.genBiomes = GaiaLayerUtil.makeLayers(seed, registry);
    }

    public BiomeProvider func_230320_a_(long s) {
        return new GaiaBiomeProvider(s, this.registry);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return CODEC;
    }

    public Biome func_225526_b_(int x, int y, int z) {
        return this.genBiomes.func_242936_a(this.registry, x, z);
    }
}

