/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.registry.ModBiomes;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.ICastleTransformer;

public enum MineralRiverLayer implements ICastleTransformer
{
    INSTANCE;

    private List<Integer> agateBiomes = ImmutableList.of((Object)GaiaLayerUtil.getBiomeId(ModBiomes.pink_agate_forest), (Object)GaiaLayerUtil.getBiomeId(ModBiomes.blue_agate_taiga), (Object)GaiaLayerUtil.getBiomeId(ModBiomes.green_agate_jungle), (Object)GaiaLayerUtil.getBiomeId(ModBiomes.purple_agate_swamp));
    private List<Integer> dryBiomes = ImmutableList.of((Object)GaiaLayerUtil.getBiomeId(ModBiomes.smoldering_bog), (Object)GaiaLayerUtil.getBiomeId(ModBiomes.static_wasteland), (Object)GaiaLayerUtil.getBiomeId(ModBiomes.volcanic_lands));

    public int func_202748_a(INoiseRandom random, int north, int west, int south, int east, int center) {
        if (this.shouldRiver(center, west, south, east, north)) {
            return GaiaLayerUtil.getBiomeId(ModBiomes.mineral_river);
        }
        return -1;
    }

    boolean shouldRiver(int mid, int left, int down, int right, int up) {
        return this.shouldRiver(mid, left) || this.shouldRiver(mid, right) || this.shouldRiver(mid, down) || this.shouldRiver(mid, up);
    }

    boolean shouldRiver(int id1, int id2) {
        if (id1 == id2) {
            return false;
        }
        if (id1 == -id2) {
            return false;
        }
        if (this.dryBiomes.contains(id1) || this.dryBiomes.contains(id2)) {
            return false;
        }
        if (id1 == GaiaLayerUtil.getBiomeId(ModBiomes.pink_agate_forest) && id2 == GaiaLayerUtil.getBiomeId(ModBiomes.crystal_plains) || id1 == GaiaLayerUtil.getBiomeId(ModBiomes.crystal_plains) && id2 == GaiaLayerUtil.getBiomeId(ModBiomes.pink_agate_forest)) {
            return false;
        }
        if (id1 == GaiaLayerUtil.getBiomeId(ModBiomes.mineral_reservoir) && id2 == GaiaLayerUtil.getBiomeId(ModBiomes.mineral_reservoir)) {
            return false;
        }
        if (id1 == GaiaLayerUtil.getBiomeId(ModBiomes.salt_dunes) && id2 == GaiaLayerUtil.getBiomeId(ModBiomes.mineral_reservoir) || id1 == GaiaLayerUtil.getBiomeId(ModBiomes.mineral_reservoir) && id2 == GaiaLayerUtil.getBiomeId(ModBiomes.salt_dunes)) {
            return false;
        }
        return (id1 != GaiaLayerUtil.getBiomeId(ModBiomes.mutant_agate_wildwood) || !this.agateBiomes.contains(id2)) && (!this.agateBiomes.contains(id1) || id2 != GaiaLayerUtil.getBiomeId(ModBiomes.mutant_agate_wildwood));
    }
}

