/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.surface;

import androsa.gaiadimension.registry.ModBlocks;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class VolcanicSurfaceBuilder<T extends SurfaceBuilderConfig>
extends SurfaceBuilder<T> {
    public VolcanicSurfaceBuilder(Codec<T> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int sealevel, long seed, SurfaceBuilderConfig config) {
        this.genVolcanicTerrain(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, config.func_204108_a(), config.func_204109_b(), config.func_204110_c(), sealevel);
    }

    public final void genVolcanicTerrain(Random rand, IChunk chunk, Biome biome, int x, int z, int startHeight, double noiseVal, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        BlockState topBlock = top;
        BlockState middleBlock = middle;
        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
        int j = -1;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int posX = x & 0xF;
        int posZ = z & 0xF;
        for (int posY = startHeight; posY >= 0; --posY) {
            blockpos$mutableblockpos.func_181079_c(posX, posY, posZ);
            BlockState blockstate2 = chunk.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (blockstate2.func_196958_f()) {
                j = -1;
                continue;
            }
            if (blockstate2.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (posY > sealevel + 10) {
                chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, ModBlocks.volcanic_rock.func_176223_P(), false);
            }
            if (j == -1) {
                if (k <= 0) {
                    topBlock = Blocks.field_150350_a.func_176223_P();
                    middleBlock = defaultBlock;
                } else if (posY >= sealevel - 4 && posY <= sealevel + 1) {
                    topBlock = top;
                    middleBlock = middle;
                }
                if (posY < sealevel && (topBlock == null || topBlock.func_196958_f())) {
                    topBlock = biome.func_225486_c((BlockPos)blockpos$mutableblockpos.func_181079_c(x, posY, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    blockpos$mutableblockpos.func_181079_c(posX, posY, posZ);
                }
                j = k;
                if (posY >= sealevel - 1) {
                    chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, topBlock, false);
                    continue;
                }
                if (posY < sealevel - 7 - k) {
                    topBlock = Blocks.field_150350_a.func_176223_P();
                    middleBlock = defaultBlock;
                    chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, bottom, false);
                    continue;
                }
                if (posY > sealevel + 10) {
                    chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, ModBlocks.volcanic_rock.func_176223_P(), false);
                    continue;
                }
                chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, middleBlock, false);
                continue;
            }
            if (j <= 0) continue;
            chunk.func_177436_a((BlockPos)blockpos$mutableblockpos, middleBlock, false);
            if (--j != 0 || middleBlock.func_177230_c() != ModBlocks.salt || k <= 1) continue;
            j = rand.nextInt(4) + Math.max(0, posY - 63);
            middleBlock = ModBlocks.saltstone.func_176223_P();
        }
    }
}

