/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.ClientProxy;
import alpvax.mc.goprone.PacketHandler;
import alpvax.mc.goprone.config.ConfigOptions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="goprone")
public class GoProne {
    public static final String MODID = "goprone";
    private static final Logger LOGGER = LogManager.getLogger();
    static final Map<UUID, Boolean> entityProneStates = Maps.newConcurrentMap();

    public GoProne() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::init);
        PacketHandler.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigOptions.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigOptions::onModConfigEvent);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    public static void setProne(UUID playerID, boolean prone) {
        entityProneStates.put(playerID, prone);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.f_19853_.f_46443_) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.updateProneState(event.player));
            }
            if (entityProneStates.getOrDefault(event.player.m_142081_(), false).booleanValue() && ConfigOptions.test(event.player)) {
                event.player.m_20124_(Pose.SWIMMING);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntityLiving()).m_20096_() && player.m_20089_() == Pose.SWIMMING && !ConfigOptions.isJumpingAllowed()) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
        }
    }
}

