/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class GhostPlayerEntity
extends MonsterEntity {
    private static final DataParameter<Optional<UUID>> PLAYER_UUID = EntityDataManager.func_187226_a(GhostPlayerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Byte> PLAYER_MODEL = EntityDataManager.func_187226_a(GhostPlayerEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public GhostPlayerEntity(EntityType type, World world) {
        super(type, world);
    }

    public GhostPlayerEntity(World world, UUID playerUUID, ITextComponent name, NonNullList<ItemStack> equipment, byte model) {
        this(Main.GHOST, world);
        this.setPlayerUUID(playerUUID);
        this.func_200203_b(name);
        this.setModel(model);
        Arrays.fill(this.field_184655_bs, 0.0f);
        Arrays.fill(this.field_82174_bp, 0.0f);
        for (int i = 0; i < EquipmentSlotType.values().length; ++i) {
            this.func_184201_a(EquipmentSlotType.values()[i], (ItemStack)equipment.get(i));
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(PLAYER_UUID, Optional.empty());
        this.func_184212_Q().func_187214_a(PLAYER_MODEL, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute getGhostAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233819_b_, 35.0);
    }

    public boolean func_94059_bO() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        if (((Boolean)Main.SERVER_CONFIG.friendlyGhost.get()).booleanValue()) {
            this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 10, false, true, entityLiving -> entityLiving != null && !entityLiving.func_82150_aj() && (entityLiving instanceof MonsterEntity || entityLiving instanceof SlimeEntity) && !(entityLiving instanceof CreeperEntity) && !(entityLiving instanceof GhostPlayerEntity)));
        } else {
            this.field_70715_bh.func_75776_a(10, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        }
    }

    public boolean func_70662_br() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void setPlayerUUID(UUID uuid) {
        this.func_184212_Q().func_187227_b(PLAYER_UUID, Optional.of(uuid));
        if (uuid.toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            this.setOverpowered();
        }
    }

    private void setOverpowered() {
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(35.0);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.4);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(20.0);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name != null && name.getString().equals("henkelmax")) {
            this.setOverpowered();
        }
    }

    public UUID getPlayerUUID() {
        return ((Optional)this.func_184212_Q().func_187225_a(PLAYER_UUID)).orElse(GraveUtils.EMPTY_UUID);
    }

    public void setModel(byte model) {
        this.field_70180_af.func_187227_b(PLAYER_MODEL, (Object)model);
    }

    public byte getModel() {
        return (Byte)this.field_70180_af.func_187225_a(PLAYER_MODEL);
    }

    public boolean isWearing(PlayerModelPart part) {
        return (this.getModel() & part.func_179327_a()) == part.func_179327_a();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ((Optional)this.func_184212_Q().func_187225_a(PLAYER_UUID)).ifPresent(uuid -> compound.func_186854_a("PlayerUUID", uuid));
        compound.func_74774_a("Model", this.getModel());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player_uuid")) {
            String uuidStr = compound.func_74779_i("player_uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.setPlayerUUID(uuid);
            }
            catch (Exception exception) {}
        } else if (compound.func_74764_b("PlayerUUID")) {
            this.setPlayerUUID(compound.func_186857_a("PlayerUUID"));
        }
        this.setModel(compound.func_74771_c("Model"));
    }

    public boolean func_70652_k(Entity entity) {
        if (entity.func_200200_C_().getString().equals("henkelmax") || entity.func_110124_au().toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            return true;
        }
        return super.func_70652_k(entity);
    }
}

