/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.tileentity;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.corelib.death.Death;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GraveStoneTileEntity
extends TileEntity
implements INameable {
    protected Death death = new Death.Builder(GraveUtils.EMPTY_UUID, GraveUtils.EMPTY_UUID).build();
    protected ITextComponent customName;

    public GraveStoneTileEntity() {
        super(Main.GRAVESTONE_TILEENTITY);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("Death", (INBT)this.death.toNBT());
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Death")) {
            this.death = Death.fromNBT(compound.func_74775_l("Death"));
        } else {
            UUID playerUUID = GraveUtils.EMPTY_UUID;
            try {
                playerUUID = UUID.fromString(compound.func_74779_i("PlayerUUID"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Death.Builder builder = new Death.Builder(playerUUID, UUID.randomUUID());
            NonNullList items = NonNullList.func_191196_a();
            ListNBT list = compound.func_150295_c("ItemStacks", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add((Object)ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i)));
            }
            builder.additionalItems((NonNullList<ItemStack>)items);
            builder.playerName(compound.func_74779_i("PlayerName"));
            builder.timestamp(compound.func_74763_f("DeathTime"));
            this.death = builder.build();
        }
        if (compound.func_74764_b("CustomName")) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(null, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a("Death", (INBT)this.death.toNBT(false));
        compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        return super.func_189515_b(compound);
    }

    public Death getDeath() {
        return this.death;
    }

    public void setDeath(Death death) {
        this.death = death;
        this.func_70296_d();
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
        this.func_70296_d();
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    protected ITextComponent getDefaultName() {
        String name = this.death.getPlayerName();
        if (name == null || name.isEmpty()) {
            return new TranslationTextComponent(Main.GRAVESTONE.func_149739_a());
        }
        return new TranslationTextComponent("message.gravestone.grave_of", new Object[]{name});
    }

    @Nullable
    public ITextComponent getGraveName() {
        if (!this.death.getPlayerName().isEmpty()) {
            return new StringTextComponent(this.death.getPlayerName());
        }
        if (this.customName != null) {
            return this.customName;
        }
        return null;
    }
}

