/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.happytrails;

import com.mactso.happytrails.config.MyConfig;
import com.mactso.happytrails.config.TrailBlockManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class HappyTrailsCommands {
    String subcommand = "";
    String value = "";

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"happytrails").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"debugLevel").then(Commands.func_197056_a((String)"debugLevel", (ArgumentType)IntegerArgumentType.integer((int)0, (int)2)).executes(ctx -> HappyTrailsCommands.setDebugLevel(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"debugLevel")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"particlesOn").then(Commands.func_197057_a((String)"true").executes(ctx -> HappyTrailsCommands.setParticlesOn(true)))).then(Commands.func_197057_a((String)"false").executes(ctx -> HappyTrailsCommands.setParticlesOn(false))))).then(Commands.func_197057_a((String)"setHappyTrailSpeed").then(Commands.func_197056_a((String)"setHappyTrailSpeed", (ArgumentType)IntegerArgumentType.integer((int)-11, (int)11)).executes(ctx -> HappyTrailsCommands.setSpeedForBlock(((CommandSource)ctx.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"setHappyTrailSpeed")))))).then(Commands.func_197057_a((String)"info").executes(ctx -> {
            ServerPlayerEntity p = ((CommandSource)ctx.getSource()).func_197035_h();
            BlockPos playerBlockPos = p.func_233580_cy_();
            World worldName = p.field_70170_p;
            String dimensionName = p.field_70170_p.func_230315_m_().toString();
            String chatMessage = "Dimension: " + dimensionName + "\n Current Values";
            MyConfig.sendBoldChat((PlayerEntity)p, chatMessage, Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN));
            Block b = p.field_70170_p.func_180495_p(playerBlockPos).func_177230_c();
            if (b == Blocks.field_150350_a) {
                b = p.field_70170_p.func_180495_p(playerBlockPos.func_177977_b()).func_177230_c();
            }
            TrailBlockManager.TrailBlockItem t = TrailBlockManager.getTrailBlockInfo(b.getRegistryName().toString());
            int speed = 0;
            if (t != null) {
                speed = t.getTrailBlockSpeed();
            }
            chatMessage = "\n  Speed Level...........: " + speed + "\n  Standing On...........: " + b.getRegistryName().toString() + "\n  Player Position.......: " + playerBlockPos.toString() + "\n  Debug Level...........: " + MyConfig.aDebugLevel;
            MyConfig.sendChat((PlayerEntity)p, chatMessage, Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
            return 1;
        })));
    }

    public static int setDebugLevel(int newDebugLevel) {
        MyConfig.aDebugLevel = newDebugLevel;
        MyConfig.pushDebugValue();
        return 1;
    }

    public static int setParticlesOn(boolean newParticlesOn) {
        MyConfig.aParticlesOn = newParticlesOn;
        MyConfig.pushNewParticlesOn();
        return 1;
    }

    public static int setSpeedForBlock(ServerPlayerEntity p, int newSpeedValue) {
        BlockPos playerBlockPos = p.func_233580_cy_();
        Block block = p.field_70170_p.func_180495_p(playerBlockPos).func_177230_c();
        if (block == Blocks.field_150350_a) {
            block = p.field_70170_p.func_180495_p(playerBlockPos.func_177977_b()).func_177230_c();
        }
        String key = block.getRegistryName().toString();
        if (newSpeedValue == 0) {
            TrailBlockManager.trailBlockHashtable.remove(key);
        } else {
            TrailBlockManager.trailBlockHashtable.put(key, new TrailBlockManager.TrailBlockItem(newSpeedValue));
        }
        MyConfig.pushValues();
        return 1;
    }
}

