/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.happytrails.config;

import com.mactso.happytrails.config.TrailBlockManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="happytrails", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int aDebugLevel;
    public static boolean aParticlesOn;
    public static String[] defaultTrailBlocks;
    public static String defaultTrailBlocks6464;
    public static final Boolean BOLD;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
            TrailBlockManager.trailBlockInit();
        }
    }

    public static void pushDebugValue() {
        if (aDebugLevel > 0) {
            System.out.println("dbgL:" + aDebugLevel);
        }
        MyConfig.COMMON.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushNewParticlesOn() {
        MyConfig.COMMON.particlesOn.set((Object)aParticlesOn);
    }

    public static void pushValues() {
        MyConfig.COMMON.defaultTrailBlocksActual.set((Object)TrailBlockManager.getTrailHashAsString());
    }

    public static void sendChat(PlayerEntity p, String chatMessage, Color textColor) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240718_a_(textColor);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    public static void sendBoldChat(PlayerEntity p, String chatMessage, Color textColor) {
        StringTextComponent component = new StringTextComponent(chatMessage);
        component.func_150256_b().func_240713_a_(Boolean.valueOf(true));
        component.func_150256_b().func_240718_a_(textColor);
        p.func_145747_a((ITextComponent)component, p.func_110124_au());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        defaultTrailBlocks6464 = (String)MyConfig.COMMON.defaultTrailBlocksActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Happy Trails Debug: " + aDebugLevel);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        BOLD = true;
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue particlesOn;
        public final ForgeConfigSpec.ConfigValue<String> defaultTrailBlocksActual;
        public final String defaultTrailBlocks6464 = "minecraft:grass_path,2;minecraft:sand,-1;minecraft:stone_brick_slab,3;minecraft:bricks,11;";

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Happy Trail Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("happytrails.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.particlesOn = builder.comment("Particles On: [true] / false").translation("happytrails.config.particlesOn").define("particlesOn", () -> true);
            builder.pop();
            builder.push("Trail Values 6464");
            this.defaultTrailBlocksActual = builder.comment("Trail Block String 6464").translation("happytrails.configdefaultTrailBlocksActual").define("defaultTrailBlocksActual", (Object)"minecraft:grass_path,2;minecraft:sand,-1;minecraft:stone_brick_slab,3;minecraft:bricks,11;");
            builder.pop();
        }
    }
}

