/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.happytrails.config;

import com.mactso.happytrails.config.MyConfig;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class TrailBlockManager {
    public static Hashtable<String, TrailBlockItem> trailBlockHashtable = new Hashtable();
    private static String defaultTrailBlockString;
    private static String defaultTrailBlockKey;

    public static TrailBlockItem getTrailBlockInfo(String key) {
        String iKey = key;
        if (trailBlockHashtable.isEmpty()) {
            TrailBlockManager.trailBlockInit();
        }
        TrailBlockItem t = trailBlockHashtable.get(iKey);
        return t;
    }

    public static String getTrailHashAsString() {
        String returnString = "";
        for (String key : trailBlockHashtable.keySet()) {
            int speed = TrailBlockManager.trailBlockHashtable.get((Object)key).trailBlockSpeed;
            String tempString = key + "," + speed + ";";
            returnString = returnString + tempString;
        }
        return returnString;
    }

    public static void trailBlockInit() {
        ArrayList<String> dTL6464 = new ArrayList<String>();
        int i = 0;
        String trailBlockLine6464 = "";
        StringTokenizer st6464 = new StringTokenizer(MyConfig.defaultTrailBlocks6464, ";");
        while (st6464.hasMoreElements()) {
            trailBlockLine6464 = st6464.nextToken().trim();
            if (trailBlockLine6464.isEmpty()) continue;
            dTL6464.add(trailBlockLine6464);
            ++i;
        }
        MyConfig.defaultTrailBlocks = dTL6464.toArray(new String[i]);
        trailBlockHashtable.clear();
        for (i = 0; i < MyConfig.defaultTrailBlocks.length; ++i) {
            try {
                String modAndBlock;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultTrailBlocks[i], ",");
                String key = modAndBlock = st.nextToken();
                String speed = st.nextToken();
                int tHappyTrailSpeed = Integer.parseInt(speed.trim());
                if (tHappyTrailSpeed < -11 || tHappyTrailSpeed > 11) {
                    tHappyTrailSpeed = 2;
                }
                trailBlockHashtable.put(key, new TrailBlockItem(tHappyTrailSpeed));
                if (modAndBlock.contentEquals("hbm:default") || ForgeRegistries.ITEMS.containsKey(new ResourceLocation(modAndBlock))) continue;
                System.out.println("Happy Trails: Block: " + modAndBlock + " not in Forge Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Happy Trails:  Bad Block Config : " + MyConfig.defaultTrailBlocks[i]);
            }
        }
    }

    static {
        defaultTrailBlockKey = defaultTrailBlockString = "hbm:default";
    }

    public static class TrailBlockItem {
        int trailBlockSpeed;

        public TrailBlockItem(int trailBlockSpeed) {
            this.trailBlockSpeed = trailBlockSpeed;
        }

        public int getTrailBlockSpeed() {
            return this.trailBlockSpeed;
        }
    }
}

