/*
 * Decompiled with CFR 0.152.
 */
package dev.nero.horsestatsmod;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.nero.horsestatsmod.config.TheModConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.HorseInventoryScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="horsestatsmod")
public class HorseStatsMod {
    public static final String MODID = "horsestatsmod";
    private static final Logger LOGGER = LogManager.getLogger();
    private final double MIN_HEALTH = 15.0;
    private final double MAX_HEALTH = 30.0;
    private final double MIN_JUMP_HEIGHT = 1.25;
    private final double MAX_JUMP_HEIGHT = 5.0;
    private final double MIN_SPEED = 4.8;
    private final double MAX_SPEED = 14.5;
    private final double MIN_SLOTS = 3.0;
    private final double MAX_SLOTS = 15.0;
    private double health;
    private double jumpHeight;
    private double speed;
    private int slots;
    private ITextComponent overlayMessage;
    private int overlayMessageTime;

    public HorseStatsMod() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteractEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onDrawForegroundEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderTickEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, TheModConfig.CLIENT_SPEC);
    }

    private void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.overlayMessageTime > 0) {
            --this.overlayMessageTime;
            Minecraft.func_71410_x().field_71456_v.field_73845_h = this.overlayMessageTime;
            if (!Minecraft.func_71410_x().field_71456_v.field_73838_g.getString().equals(this.overlayMessage.getString())) {
                Minecraft.func_71410_x().field_71456_v.field_73838_g = this.overlayMessage;
            }
        }
    }

    private void onEntityInteractEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof AbstractHorseEntity) {
            this.getHorseStats((AbstractHorseEntity)event.getTarget());
            this.setOverlayMessage((ITextComponent)(TheModConfig.displayMinMax() ? new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + TextFormatting.RED + 15.0 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 30.0 + TextFormatting.RESET + " " + I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + TextFormatting.RED + 1.25 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 5.0 + TextFormatting.RESET + " " + I18n.func_135052_a((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + TextFormatting.RED + 4.8 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 14.5 + TextFormatting.RESET + " " + (this.slots == -1 ? "" : I18n.func_135052_a((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + TextFormatting.RED + 3.0 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.slots, 3.0, 15.0) + this.slots + TextFormatting.RESET + "/" + TextFormatting.GREEN + 15.0)) : new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + TextFormatting.RESET + " " + I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + TextFormatting.RESET + " " + I18n.func_135052_a((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + TextFormatting.RESET + " " + (this.slots == -1 ? "" : I18n.func_135052_a((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.slots, 3.0, 15.0) + this.slots + TextFormatting.RESET))));
        }
    }

    private void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof HorseInventoryScreen) {
            AbstractHorseEntity horse = ((HorseInventoryScreen)event.getGuiContainer()).field_147034_x;
            this.getHorseStats(horse);
            int mouseX = (int)Minecraft.func_71410_x().field_71417_B.func_198024_e() - 2 * event.getGuiContainer().getGuiLeft();
            int mouseY = (int)Minecraft.func_71410_x().field_71417_B.func_198026_f() - 2 * event.getGuiContainer().getGuiTop();
            if (TheModConfig.displayStats()) {
                this.displayStatsAndHoveringTexts(horse, mouseX, mouseY);
            } else {
                this.displayStatsInHoveringText(event.getGuiContainer(), mouseX, mouseY);
            }
        }
    }

    private void setOverlayMessage(ITextComponent message) {
        this.overlayMessage = message;
        this.overlayMessageTime = 120;
        Minecraft.func_71410_x().field_71456_v.func_175188_a(message, false);
    }

    private void getHorseStats(AbstractHorseEntity horse) {
        this.health = horse.func_110148_a(Attributes.field_233818_a_).func_111126_e();
        this.jumpHeight = horse.func_110148_a(Attributes.field_233830_m_).func_111126_e();
        this.speed = horse.func_110148_a(Attributes.field_233821_d_).func_111126_e();
        this.slots = horse instanceof LlamaEntity ? ((LlamaEntity)horse).func_190696_dl() * 3 : -1;
        this.jumpHeight = -0.1817584952 * Math.pow(this.jumpHeight, 3.0) + 3.689713992 * Math.pow(this.jumpHeight, 2.0) + 2.128599134 * this.jumpHeight - 0.343930367;
        this.speed *= 43.0;
    }

    private void displayStatsInHoveringText(ContainerScreen guiContainer, int mouseX, int mouseY) {
        int RX = 3;
        int RY = 3;
        int RW = guiContainer.getXSize() - 6;
        int RH = 14;
        if (this.posInRect(mouseX, mouseY, 3, 3, RW, 14)) {
            ArrayList<ITextComponent> textLines = new ArrayList<ITextComponent>();
            textLines.add((ITextComponent)(TheModConfig.displayMinMax() ? new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + TextFormatting.RED + 15.0 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 30.0) : new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + TextFormatting.RESET)));
            textLines.add((ITextComponent)(TheModConfig.displayMinMax() ? new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + TextFormatting.RED + 1.25 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 5.0) : new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + TextFormatting.RESET)));
            textLines.add((ITextComponent)(TheModConfig.displayMinMax() ? new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + TextFormatting.RED + 4.8 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + TextFormatting.RESET + "/" + TextFormatting.GREEN + 14.5) : new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + TextFormatting.RESET)));
            if (this.slots != -1) {
                textLines.add((ITextComponent)(TheModConfig.displayMinMax() ? new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + TextFormatting.RED + 3.0 + TextFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 3.0, 15.0) + this.slots + TextFormatting.RESET + "/" + TextFormatting.GREEN + 15.0) : new StringTextComponent(I18n.func_135052_a((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 3.0, 15.0) + this.slots + TextFormatting.RESET)));
            }
            this.drawHoveringText(mouseX, mouseY, textLines);
        }
    }

    private void displayStatsAndHoveringTexts(AbstractHorseEntity horse, int mouseX, int mouseY) {
        int ry = 6;
        int rw = 29;
        int rh = 11;
        int rx = 60;
        if (horse.func_145748_c_().getString().length() <= 8) {
            this.renderText(I18n.func_135052_a((String)"horsestatsmod.stats", (Object[])new Object[0]) + ":", rx, ry, 0x444444);
        }
        this.renderText(String.format("%.2f", this.health), rx += 30, ry, TheModConfig.coloredStats() ? this.getColorHex(this.health, 15.0, 30.0) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.func_135052_a((String)"horsestatsmod.health", (Object[])new Object[0]) + ":", "15.0", "30.0", I18n.func_135052_a((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 20.0");
        }
        this.renderText(String.format("%.2f", this.jumpHeight), rx += 30, ry, TheModConfig.coloredStats() ? this.getColorHex(this.jumpHeight, 1.25, 5.0) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw - 6, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"horsestatsmod.blocks", (Object[])new Object[0]) + "):", "1.25", "5.0", I18n.func_135052_a((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 1.25");
        }
        this.renderText(String.format("%.2f", this.speed), rx += 24, ry, TheModConfig.coloredStats() ? this.getColorHex(this.speed, 4.8, 14.5) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.func_135052_a((String)"horsestatsmod.speed", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"horsestatsmod.metersperseconds", (Object[])new Object[0]) + "):", "4.8", "14.5", I18n.func_135052_a((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 4.317 (" + I18n.func_135052_a((String)"horsestatsmod.walk", (Object[])new Object[0]) + ")", I18n.func_135052_a((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 5.612 (" + I18n.func_135052_a((String)"horsestatsmod.sprint", (Object[])new Object[0]) + ")", I18n.func_135052_a((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 7.143 (" + I18n.func_135052_a((String)"horsestatsmod.sprint", (Object[])new Object[0]) + "+" + I18n.func_135052_a((String)"horsestatsmod.jump", (Object[])new Object[0]) + ")");
        }
    }

    private void drawHoveringText(int x, int y, String title, String min, String max, String ... notes) {
        ArrayList<ITextComponent> textLines = new ArrayList<ITextComponent>();
        textLines.add((ITextComponent)new StringTextComponent(title));
        textLines.add((ITextComponent)new StringTextComponent(TextFormatting.RED + I18n.func_135052_a((String)"horsestatsmod.min", (Object[])new Object[0]) + ": " + min));
        textLines.add((ITextComponent)new StringTextComponent(TextFormatting.GREEN + I18n.func_135052_a((String)"horsestatsmod.max", (Object[])new Object[0]) + ": " + max));
        for (String note : notes) {
            textLines.add((ITextComponent)new StringTextComponent(note));
        }
        this.drawHoveringText(x, y, textLines);
    }

    private void drawHoveringText(int x, int y, List<ITextComponent> textLines) {
        GuiUtils.drawHoveringText((MatrixStack)new MatrixStack(), textLines, (int)(x / 2), (int)(y / 2), (int)Minecraft.func_71410_x().func_228018_at_().func_198105_m(), (int)Minecraft.func_71410_x().func_228018_at_().func_198083_n(), (int)150, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
    }

    private int getColorHex(double val, double min, double max) {
        double p = this.getPercentage(val, min, max);
        if (p <= 25.0) {
            return 13705984;
        }
        if (p > 25.0 && p <= 50.0) {
            return 13731840;
        }
        if (p > 50.0 && p <= 75.0) {
            return 16442132;
        }
        return 7847684;
    }

    private TextFormatting getColorTextFormat(double val, double min, double max) {
        double p = this.getPercentage(val, min, max);
        if (p <= 25.0) {
            return TextFormatting.RED;
        }
        if (p > 25.0 && p <= 50.0) {
            return TextFormatting.GOLD;
        }
        if (p > 50.0 && p <= 75.0) {
            return TextFormatting.YELLOW;
        }
        return TextFormatting.GREEN;
    }

    private double getPercentage(double val, double min, double max) {
        return 100.0 * (val - min) / (max - min);
    }

    private void renderText(String text, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(new MatrixStack(), text, (float)x, (float)y, color);
    }

    private boolean posInRect(int px, int py, int rx, int ry, int rw, int rh) {
        return px >= (rx *= 2) && px <= rx + (rw *= 2) && py >= (ry *= 2) && py <= ry + (rh *= 2);
    }
}

