/*
 * Decompiled with CFR 0.152.
 */
package dev.nero.horsestatsmod;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.nero.horsestatsmod.config.TheModConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="horsestatsmod")
public class HorseStatsMod {
    public static final String MODID = "horsestatsmod";
    private static final Logger LOGGER = LogManager.getLogger();
    private final double MIN_HEALTH = 15.0;
    private final double MAX_HEALTH = 30.0;
    private final double MIN_JUMP_HEIGHT = 1.25;
    private final double MAX_JUMP_HEIGHT = 5.0;
    private final double MIN_SPEED = 4.8;
    private final double MAX_SPEED = 14.5;
    private final double MIN_SLOTS = 3.0;
    private final double MAX_SLOTS = 15.0;
    private double health;
    private double jumpHeight;
    private double speed;
    private int slots;
    private Component overlayMessage;
    private int overlayMessageTime;

    public HorseStatsMod() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, isServer) -> true));
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteractEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onDrawForegroundEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderTickEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)TheModConfig.CLIENT_SPEC);
    }

    private void onRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.overlayMessageTime > 0) {
            --this.overlayMessageTime;
            Minecraft.m_91087_().f_91065_.f_92991_ = this.overlayMessageTime;
            if (!Minecraft.m_91087_().f_91065_.f_92990_.getString().equals(this.overlayMessage.getString())) {
                Minecraft.m_91087_().f_91065_.f_92990_ = this.overlayMessage;
            }
        }
    }

    private void onEntityInteractEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof AbstractHorse) {
            this.getHorseStats((AbstractHorse)event.getTarget());
            this.setOverlayMessage((Component)(TheModConfig.displayMinMax() ? new TextComponent(I18n.m_118938_((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "15.0" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "30.0" + ChatFormatting.RESET + " " + I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "1.25" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "5.0" + ChatFormatting.RESET + " " + I18n.m_118938_((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "4.8" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "14.5" + ChatFormatting.RESET + " " + (String)(this.slots == -1 ? "" : I18n.m_118938_((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "3.0" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.slots, 3.0, 15.0) + this.slots + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "15.0")) : new TextComponent(I18n.m_118938_((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + ChatFormatting.RESET + " " + I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + ChatFormatting.RESET + " " + I18n.m_118938_((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + ChatFormatting.RESET + " " + (String)(this.slots == -1 ? "" : I18n.m_118938_((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.slots, 3.0, 15.0) + this.slots + ChatFormatting.RESET))));
        }
    }

    private void onDrawForegroundEvent(GuiContainerEvent.DrawForeground event) {
        if (event.getGuiContainer() instanceof HorseInventoryScreen) {
            AbstractHorse horse = ((HorseInventoryScreen)event.getGuiContainer()).f_98812_;
            this.getHorseStats(horse);
            int mouseX = (int)Minecraft.m_91087_().f_91067_.m_91589_() - 2 * event.getGuiContainer().getGuiLeft();
            int mouseY = (int)Minecraft.m_91087_().f_91067_.m_91594_() - 2 * event.getGuiContainer().getGuiTop();
            if (TheModConfig.displayStats()) {
                this.displayStatsAndHoveringTexts(horse, mouseX, mouseY);
            } else {
                this.displayStatsInHoveringText((HorseInventoryScreen)event.getGuiContainer(), mouseX, mouseY);
            }
        }
    }

    private void setOverlayMessage(Component message) {
        this.overlayMessage = message;
        this.overlayMessageTime = 120;
        Minecraft.m_91087_().f_91065_.m_93063_(message, false);
    }

    private void getHorseStats(AbstractHorse horse) {
        this.health = horse.m_21051_(Attributes.f_22276_).m_22135_();
        this.jumpHeight = horse.m_21051_(Attributes.f_22288_).m_22135_();
        this.speed = horse.m_21051_(Attributes.f_22279_).m_22135_();
        this.slots = horse instanceof Llama ? ((Llama)horse).m_7488_() * 3 : -1;
        this.jumpHeight = -0.1817584952 * Math.pow(this.jumpHeight, 3.0) + 3.689713992 * Math.pow(this.jumpHeight, 2.0) + 2.128599134 * this.jumpHeight - 0.343930367;
        this.speed *= 43.0;
    }

    private void displayStatsInHoveringText(HorseInventoryScreen guiContainer, int mouseX, int mouseY) {
        int RX = 3;
        int RY = 3;
        int RW = guiContainer.getXSize() - 6;
        int RH = 14;
        if (this.posInRect(mouseX, mouseY, 3, 3, RW, 14)) {
            ArrayList<Component> textLines = new ArrayList<Component>();
            textLines.add((Component)(TheModConfig.displayMinMax() ? new TextComponent(I18n.m_118938_((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "15.0" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "30.0") : new TextComponent(I18n.m_118938_((String)"horsestatsmod.health", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.health, 15.0, 30.0) + String.format("%,.2f", this.health) + ChatFormatting.RESET)));
            textLines.add((Component)(TheModConfig.displayMinMax() ? new TextComponent(I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "1.25" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "5.0") : new TextComponent(I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.jumpHeight, 1.25, 5.0) + String.format("%,.2f", this.jumpHeight) + ChatFormatting.RESET)));
            textLines.add((Component)(TheModConfig.displayMinMax() ? new TextComponent(I18n.m_118938_((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "4.8" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "14.5") : new TextComponent(I18n.m_118938_((String)"horsestatsmod.speed", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 4.8, 14.5) + String.format("%,.2f", this.speed) + ChatFormatting.RESET)));
            if (this.slots != -1) {
                textLines.add((Component)(TheModConfig.displayMinMax() ? new TextComponent(I18n.m_118938_((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + ChatFormatting.RED + "3.0" + ChatFormatting.RESET + "/" + this.getColorTextFormat(this.speed, 3.0, 15.0) + this.slots + ChatFormatting.RESET + "/" + ChatFormatting.GREEN + "15.0") : new TextComponent(I18n.m_118938_((String)"horsestatsmod.slots", (Object[])new Object[0]) + ": " + this.getColorTextFormat(this.speed, 3.0, 15.0) + this.slots + ChatFormatting.RESET)));
            }
            this.drawHoveringText(mouseX, mouseY, textLines);
        }
    }

    private void displayStatsAndHoveringTexts(AbstractHorse horse, int mouseX, int mouseY) {
        int ry = 6;
        int rw = 29;
        int rh = 11;
        int rx = 60;
        if (horse.m_5446_().getString().length() <= 8) {
            this.renderText(I18n.m_118938_((String)"horsestatsmod.stats", (Object[])new Object[0]) + ":", rx, ry, 0x444444);
        }
        this.renderText(String.format("%.2f", this.health), rx += 30, ry, TheModConfig.coloredStats() ? this.getColorHex(this.health, 15.0, 30.0) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.m_118938_((String)"horsestatsmod.health", (Object[])new Object[0]) + ":", "15.0", "30.0", I18n.m_118938_((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 20.0");
        }
        this.renderText(String.format("%.2f", this.jumpHeight), rx += 30, ry, TheModConfig.coloredStats() ? this.getColorHex(this.jumpHeight, 1.25, 5.0) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw - 6, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + " (" + I18n.m_118938_((String)"horsestatsmod.blocks", (Object[])new Object[0]) + "):", "1.25", "5.0", I18n.m_118938_((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 1.25");
        }
        this.renderText(String.format("%.2f", this.speed), rx += 24, ry, TheModConfig.coloredStats() ? this.getColorHex(this.speed, 4.8, 14.5) : 0x444444);
        if (this.posInRect(mouseX, mouseY, rx - 2, ry - 2, rw, rh)) {
            this.drawHoveringText(mouseX, mouseY, I18n.m_118938_((String)"horsestatsmod.speed", (Object[])new Object[0]) + " (" + I18n.m_118938_((String)"horsestatsmod.metersperseconds", (Object[])new Object[0]) + "):", "4.8", "14.5", I18n.m_118938_((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 4.317 (" + I18n.m_118938_((String)"horsestatsmod.walk", (Object[])new Object[0]) + ")", I18n.m_118938_((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 5.612 (" + I18n.m_118938_((String)"horsestatsmod.sprint", (Object[])new Object[0]) + ")", I18n.m_118938_((String)"horsestatsmod.player", (Object[])new Object[0]) + ": 7.143 (" + I18n.m_118938_((String)"horsestatsmod.sprint", (Object[])new Object[0]) + "+" + I18n.m_118938_((String)"horsestatsmod.jump", (Object[])new Object[0]) + ")");
        }
    }

    private void drawHoveringText(int x, int y, String title, String min, String max, String ... notes) {
        ArrayList<Component> textLines = new ArrayList<Component>();
        textLines.add((Component)new TextComponent(title));
        textLines.add((Component)new TextComponent(ChatFormatting.RED + I18n.m_118938_((String)"horsestatsmod.min", (Object[])new Object[0]) + ": " + min));
        textLines.add((Component)new TextComponent(ChatFormatting.GREEN + I18n.m_118938_((String)"horsestatsmod.max", (Object[])new Object[0]) + ": " + max));
        for (String note : notes) {
            textLines.add((Component)new TextComponent(note));
        }
        this.drawHoveringText(x, y, textLines);
    }

    private void drawHoveringText(int x, int y, List<Component> textLines) {
        GuiUtils.drawHoveringText((PoseStack)new PoseStack(), textLines, (int)(x / 2), (int)(y / 2), (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_(), (int)150, (Font)Minecraft.m_91087_().f_91062_);
    }

    private int getColorHex(double val, double min, double max) {
        double p = this.getPercentage(val, min, max);
        if (p <= 25.0) {
            return 13705984;
        }
        if (p > 25.0 && p <= 50.0) {
            return 13731840;
        }
        if (p > 50.0 && p <= 75.0) {
            return 16442132;
        }
        return 7847684;
    }

    private ChatFormatting getColorTextFormat(double val, double min, double max) {
        double p = this.getPercentage(val, min, max);
        if (p <= 25.0) {
            return ChatFormatting.RED;
        }
        if (p > 25.0 && p <= 50.0) {
            return ChatFormatting.GOLD;
        }
        if (p > 50.0 && p <= 75.0) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.GREEN;
    }

    private double getPercentage(double val, double min, double max) {
        return 100.0 * (val - min) / (max - min);
    }

    private void renderText(String text, int x, int y, int color) {
        Minecraft.m_91087_().f_91062_.m_92883_(new PoseStack(), text, (float)x, (float)y, color);
    }

    private boolean posInRect(int px, int py, int rx, int ry, int rw, int rh) {
        return px >= (rx *= 2) && px <= rx + (rw *= 2) && py >= (ry *= 2) && py <= ry + (rh *= 2);
    }
}

