/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.hotornot;

import com.buuz135.hotornot.DataGenerators;
import com.buuz135.hotornot.HotOrNotConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hotornot")
public class HotOrNot {
    public static final String MOD_ID = "hotornot";
    public static final String NAME = "HotOrNot";
    public static final String COMMON_CONFIG_NAME = "hotornot.toml";
    public static final Logger LOGGER = LogManager.getLogger();
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    public static final Set<Item> blacklist = new HashSet<Item>();
    public static final Set<Item> hotWhitelist = new HashSet<Item>();
    public static final Set<Item> coldWhitelist = new HashSet<Item>();
    public static final Set<Item> gaseousWhitelist = new HashSet<Item>();
    public static final Set<Item> mittsItemList = new HashSet<Item>();
    public static final String TOOLTIP_TOO_HOT = "tooltip.hotornot.toohot";
    public static final String TOOLTIP_TOO_COLD = "tooltip.hotornot.toocold";
    public static final String TOOLTIP_TOO_LIGHT = "tooltip.hotornot.toolight";
    public static final String TOOLTIP_MITTS = "tooltip.hotornot.mitts";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"hotornot");
    public static final RegistryObject<Item> MITTS = ITEMS.register("mitts", () -> new Item(new Item.Properties().func_200917_a(1).func_200918_c(((Integer)HotOrNotConfig.COMMON.MITTS_DURABILITY.get()).intValue()).func_200916_a(ItemGroup.field_78026_f)));

    public HotOrNot() {
        LOGGER.debug("Loading up HotOrNot");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, HotOrNotConfig.COMMON_SPEC, COMMON_CONFIG_NAME);
        this.modEventBus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ITEMS.register(this.modEventBus);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new DataGenerators.Recipes(generator));
        }
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new DataGenerators.Languages(generator, MOD_ID, "en_us"));
            generator.func_200390_a((IDataProvider)new DataGenerators.Languages(generator, MOD_ID, "de_de"));
            generator.func_200390_a((IDataProvider)new DataGenerators.ItemModels(generator, MOD_ID, existingFileHelper));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.START) {
            for (PlayerEntity player : event.world.func_217369_A()) {
                if (!(player instanceof ServerPlayerEntity) || player.func_70027_ad() || player.func_184812_l_() || player.func_70644_a(Effects.field_76426_n)) continue;
                LazyOptional handler = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                handler.ifPresent(h -> {
                    for (int i = 0; i < h.getSlots(); ++i) {
                        ItemStack stack = h.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        LazyOptional fluidHandlerItem = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                        if (fluidHandlerItem.isPresent()) {
                            if (blacklist.contains(stack.func_77973_b())) {
                                return;
                            }
                            fluidHandlerItem.ifPresent(fh -> {
                                FluidStack fluidStack = fh.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                                if (fluidStack != null) {
                                    for (FluidEffect effect : FluidEffect.values()) {
                                        if (!effect.isValid.test(fluidStack)) continue;
                                        this.applyEffectAndDamageMitts(player, effect, event, stack);
                                    }
                                }
                            });
                            continue;
                        }
                        if (coldWhitelist.contains(stack.func_77973_b())) {
                            this.applyEffectAndDamageMitts(player, FluidEffect.COLD, event, stack);
                        }
                        if (gaseousWhitelist.contains(stack.func_77973_b()) && ((Boolean)HotOrNotConfig.COMMON.GASEOUS.get()).booleanValue()) {
                            this.applyEffectAndDamageMitts(player, FluidEffect.GAS, event, stack);
                        }
                        if (!hotWhitelist.contains(stack.func_77973_b())) continue;
                        this.applyEffectAndDamageMitts(player, FluidEffect.HOT, event, stack);
                    }
                });
            }
        }
    }

    public void applyEffectAndDamageMitts(PlayerEntity player, FluidEffect effect, TickEvent.WorldTickEvent event, ItemStack stack) {
        ItemStack offHand = player.func_184592_cb();
        if (offHand.func_77973_b().equals(MITTS.get()) || mittsItemList.contains(stack.func_77973_b())) {
            offHand.func_222118_a(1, (LivingEntity)player, consumer -> {});
        } else if (event.world.func_82737_E() % 20L == 0L) {
            effect.interactPlayer.accept(player);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (((Boolean)HotOrNotConfig.COMMON.TOOLTIP.get()).booleanValue() && !stack.func_190926_b()) {
            if (stack.func_77973_b() == MITTS.get() || mittsItemList.contains(stack.func_77973_b())) {
                event.getToolTip().add(new TranslationTextComponent(TOOLTIP_MITTS).func_240699_a_(TextFormatting.GREEN));
            }
            if (blacklist.contains(stack.func_77973_b())) {
                return;
            }
            if (stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                LazyOptional iFluidHandler = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                iFluidHandler.ifPresent(h -> {
                    FluidStack fluidStack = h.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                    if (fluidStack != null) {
                        for (FluidEffect effect : FluidEffect.values()) {
                            if (!effect.isValid.test(fluidStack)) continue;
                            event.getToolTip().add(effect.tooltip);
                        }
                    }
                });
            } else {
                if (coldWhitelist.contains(stack.func_77973_b())) {
                    event.getToolTip().add(FluidEffect.COLD.tooltip);
                }
                if (gaseousWhitelist.contains(stack.func_77973_b()) && ((Boolean)HotOrNotConfig.COMMON.GASEOUS.get()).booleanValue()) {
                    event.getToolTip().add(FluidEffect.GAS.tooltip);
                }
                if (hotWhitelist.contains(stack.func_77973_b())) {
                    event.getToolTip().add(FluidEffect.HOT.tooltip);
                }
            }
        }
    }

    public static enum FluidEffect {
        HOT(fluidStack -> fluidStack.getFluid().getAttributes().getTemperature(fluidStack) >= (Integer)HotOrNotConfig.COMMON.HOT_TEMPERATURE.get(), entityPlayerMP -> entityPlayerMP.func_70015_d(1), (ITextComponent)new TranslationTextComponent("tooltip.hotornot.toohot").func_240699_a_(TextFormatting.RED)),
        COLD(fluidStack -> fluidStack.getFluid().getAttributes().getTemperature(fluidStack) <= (Integer)HotOrNotConfig.COMMON.COLD_TEMPERATURE.get(), entityPlayerMP -> {
            entityPlayerMP.func_195064_c(new EffectInstance(Effects.field_76421_d, 21, 1));
            entityPlayerMP.func_195064_c(new EffectInstance(Effects.field_76437_t, 21, 1));
        }, (ITextComponent)new TranslationTextComponent("tooltip.hotornot.toocold").func_240699_a_(TextFormatting.AQUA)),
        GAS(fluidStack -> fluidStack.getFluid().getAttributes().isGaseous(fluidStack) && (Boolean)HotOrNotConfig.COMMON.GASEOUS.get() == true, entityPlayerMP -> entityPlayerMP.func_195064_c(new EffectInstance(Effects.field_188424_y, 21, 1)), (ITextComponent)new TranslationTextComponent("tooltip.hotornot.toolight").func_240699_a_(TextFormatting.YELLOW));

        private final Predicate<FluidStack> isValid;
        private final Consumer<PlayerEntity> interactPlayer;
        private final ITextComponent tooltip;

        private FluidEffect(Predicate<FluidStack> isValid, Consumer<PlayerEntity> interactPlayer, ITextComponent iTextComponent) {
            this.isValid = isValid;
            this.interactPlayer = interactPlayer;
            this.tooltip = iTextComponent;
        }
    }
}

