/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.hotornot;

import com.buuz135.hotornot.HotOrNot;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="hotornot", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HotOrNotConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        HotOrNot.LOGGER.info("Loaded {} config file {}", (Object)"hotornot", (Object)event.getConfig().getFileName());
        HotOrNotConfig.loopArrayList((ArrayList)HotOrNotConfig.COMMON.MITTS_ITEMS.get(), HotOrNot.mittsItemList);
        HotOrNotConfig.loopArrayList((ArrayList)HotOrNotConfig.COMMON.BLACKLISTED_ITEMS.get(), HotOrNot.blacklist);
        HotOrNotConfig.loopArrayList((ArrayList)HotOrNotConfig.COMMON.COLD_WHITELISTED_ITEMS.get(), HotOrNot.coldWhitelist);
        HotOrNotConfig.loopArrayList((ArrayList)HotOrNotConfig.COMMON.GASEOUS_WHITELISTED_ITEMS.get(), HotOrNot.gaseousWhitelist);
        HotOrNotConfig.loopArrayList((ArrayList)HotOrNotConfig.COMMON.HOT_WHITELISTED_ITEMS.get(), HotOrNot.hotWhitelist);
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading event) {
        HotOrNot.LOGGER.debug("hotornot", (Object)"Config just got changed on the file system!");
    }

    public static void loopArrayList(ArrayList<String> list, Set<Item> set) {
        for (String string : list) {
            set.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(string)));
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue MITTS_DURABILITY;
        public final ForgeConfigSpec.IntValue HOT_TEMPERATURE;
        public final ForgeConfigSpec.IntValue COLD_TEMPERATURE;
        public final ForgeConfigSpec.BooleanValue GASEOUS;
        public final ForgeConfigSpec.BooleanValue TOOLTIP;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> MITTS_ITEMS;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> BLACKLISTED_ITEMS;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> COLD_WHITELISTED_ITEMS;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> GASEOUS_WHITELISTED_ITEMS;
        public final ForgeConfigSpec.ConfigValue<ArrayList<String>> HOT_WHITELISTED_ITEMS;
        public final ArrayList<String> defaultMittsItems = new ArrayList();
        public final ArrayList<String> defaultBlacklist = new ArrayList();
        public final ArrayList<String> defaultColdWhitelist = new ArrayList();
        public final ArrayList<String> defaultGaseousWhitelist = new ArrayList();
        public final ArrayList<String> defaultHotWhitelist = new ArrayList();

        private void addToStringArrayList(ArrayList<String> list, Item item) {
            list.add(item.getRegistryName().toString());
        }

        public Common(ForgeConfigSpec.Builder builder) {
            this.addToStringArrayList(this.defaultBlacklist, Items.field_151133_ar);
            builder.comment("HotOrNot Config").push("general");
            this.MITTS_DURABILITY = builder.comment("This sets the maximum durability for the mitts.").defineInRange("mitts_durability", 12000, 1, Integer.MAX_VALUE);
            this.HOT_TEMPERATURE = builder.comment("This sets the temperature when a hot fluid should start burning the player (in kelvin).").defineInRange("hot_temperature", 1300, 1, Integer.MAX_VALUE);
            this.COLD_TEMPERATURE = builder.comment("This sets the temperature when a cold fluid should add effects to the player (in kelvin).").defineInRange("cold_temperature", 273, 1, Integer.MAX_VALUE);
            this.GASEOUS = builder.comment("This sets whether gaseos effect for a fluid should be enabled.").define("gaseous", false);
            this.TOOLTIP = builder.comment("This sets whether an item that contains a fluid will have a tooltip that they are gaseous, too hot or too cold.").define("tooltips", true);
            this.MITTS_ITEMS = builder.comment("This sets an item as a mitts item. It prevents all effects.").define("mitts_items", this.defaultMittsItems);
            this.BLACKLISTED_ITEMS = builder.comment("This sets an item on a fluid blacklist. It won't be affected.").define("blacklisted_items", this.defaultBlacklist);
            this.COLD_WHITELISTED_ITEMS = builder.comment("This sets an items on a cold fluid whitelist. It will have the cold fluid effect.").define("cold_whitelisted_items", this.defaultColdWhitelist);
            this.GASEOUS_WHITELISTED_ITEMS = builder.comment("This sets an item on a gaseous fluid whitelist. It will have the gaseous fluid effect.").define("gaseous_whitelisted_items", this.defaultGaseousWhitelist);
            this.HOT_WHITELISTED_ITEMS = builder.comment("This sets an item on a hot fluid whitelist. It will have the hot fluid effect.").define("hot_whitelisted_items", this.defaultHotWhitelist);
            builder.pop();
        }
    }
}

