/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static boolean alwaysShowLabels;
    public static boolean alwaysShowFocusedLabel;
    public static boolean showAllLabelsOnSneak;
    public static boolean animateLabels;

    public static void refreshClient() {
        alwaysShowLabels = (Boolean)ConfigData.CLIENT.alwaysShowLabels.get();
        alwaysShowFocusedLabel = (Boolean)ConfigData.CLIENT.alwaysShowFocusedLabel.get();
        showAllLabelsOnSneak = (Boolean)ConfigData.CLIENT.showAllLabelsOnSneak.get();
        animateLabels = (Boolean)ConfigData.CLIENT.animateLabels.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue alwaysShowLabels;
        public final ForgeConfigSpec.BooleanValue alwaysShowFocusedLabel;
        public final ForgeConfigSpec.BooleanValue showAllLabelsOnSneak;
        public final ForgeConfigSpec.BooleanValue animateLabels;
        public final ForgeConfigSpec.BooleanValue enableXaeroMinimapIntegration;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("display");
            this.alwaysShowLabels = builder.comment("If set to TRUE, the labels on the compass will always be visible, if FALSE (default), only the closest to the center of the compass will show the name.").translation("text.hudcompass.config.always_show_labels").define("alwaysShowLabels", false);
            this.alwaysShowFocusedLabel = builder.comment("If set to FALSE, the closest waypoint to the center of the compass will not show the label, and sneak will be required to display it.").translation("text.hudcompass.config.always_show_focused_labels").define("alwaysShowFocusedLabel", true);
            this.showAllLabelsOnSneak = builder.comment("If set to FALSE, sneaking will only show the closest waypoint to the center of the compass.").translation("text.hudcompass.config.show_all_labels_on_sneak").define("showAllLabelsOnSneak", true);
            this.animateLabels = builder.comment("If set to FALSE, support for sewing recipes will not be enabled regardless of the mod's presence.").translation("text.hudcompass.config.disable_anvil_update").define("animateLabels", true);
            this.enableXaeroMinimapIntegration = builder.comment("If set to FALSE, Xaero Minimap waypoints won't be displayed in the compass.").translation("text.hudcompass.config.enable_xaero_minimap").define("enableXaeroMinimapIntegration", true);
            builder.pop();
        }
    }

    public static class ServerConfig {
        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            builder.pop();
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue enableVanillaMapIntegration;
        public final ForgeConfigSpec.BooleanValue enableSpawnPointWaypoint;
        public final ForgeConfigSpec.BooleanValue disableServerHello;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.enableVanillaMapIntegration = builder.comment("If set to FALSE, vanilla map waypoints won't be displayed in the compass.").translation("text.hudcompass.config.enable_vanilla_map").define("enableVanillaMapIntegration", true);
            this.enableSpawnPointWaypoint = builder.comment("If set to FALSE, the spawn point location will not be shown.").translation("text.hudcompass.config.disable_anvil_update").define("enableXaeroMinimapIntegration", true);
            this.disableServerHello = builder.comment("If set to TRUE, the server will not advertise itself to the clients, making them work in client-only mode.").translation("text.hudcompass.config.disable_anvil_update").define("disableServerHello", false);
            builder.pop();
        }
    }
}

