/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.icons;

import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.icons.IconDataSerializer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class IconDataRegistry {
    public static IForgeRegistry<IconDataSerializer<?>> REGISTRY = RegistryManager.ACTIVE.getRegistry(IconDataSerializer.class);

    @Nonnull
    public static CompoundNBT serializeIcon(@Nonnull IIconData<?> iconData) {
        IconDataSerializer<?> serializer = iconData.getSerializer();
        ResourceLocation serializerId = serializer.getRegistryName();
        if (serializerId == null) {
            throw new IllegalStateException(String.format("Serializer name is null %s", ((Object)serializer).getClass().getName()));
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Type", serializer.getRegistryName().toString());
        tag = serializer.write(iconData, tag);
        return tag;
    }

    @Nonnull
    public static IIconData<?> deserializeIcon(CompoundNBT tag) {
        ResourceLocation serializerId = new ResourceLocation(tag.func_74779_i("Type"));
        IconDataSerializer serializer = (IconDataSerializer)REGISTRY.getValue(serializerId);
        if (serializer == null) {
            throw new IllegalStateException(String.format("Serializer not registered %s", serializerId));
        }
        return serializer.read(tag);
    }

    public static void serializeIcon(IIconData<?> iconData, PacketBuffer buffer) {
        IconDataSerializer<?> serializer = iconData.getSerializer();
        buffer.writeRegistryIdUnsafe(REGISTRY, serializer);
        serializer.write(iconData, buffer);
    }

    @Nonnull
    public static IIconData<?> deserializeIcon(PacketBuffer buffer) {
        IconDataSerializer serializer = (IconDataSerializer)buffer.readRegistryIdUnsafe(REGISTRY);
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        return serializer.read(buffer);
    }
}

