/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.xaerominimap;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.icons.IconDataSerializer;
import dev.gigaherz.hudcompass.icons.client.IIconRenderer;
import dev.gigaherz.hudcompass.icons.client.IconRendererRegistry;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.minimap.XaeroMinimap;

public class XaeroMinimapIntegration {
    public static void init() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            XMWaypoints.init();
        }
    }

    public static class XMWaypoints {
        public static final XMWaypoints INSTANCE = new XMWaypoints();
        private static final ResourceLocation ADDON_ID = HudCompass.location("xaero_minimap");
        private static final DeferredRegister<PointInfoType<?>> PIT = HudCompass.makeDeferredPOI();
        private static final DeferredRegister<IconDataSerializer<?>> IDS = HudCompass.makeDeferredIDS();
        public static final RegistryObject<PointInfoType<XMWaypoint>> TYPE = PIT.register("xmwaypoints", () -> new PointInfoType<XMWaypoint>(XMWaypoint::new));
        public static final RegistryObject<XMIconData.Serializer> ICON_DATA = IDS.register("xmwaypoints", XMIconData.Serializer::new);
        private int counter = 0;

        public static void init() {
            IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
            modEventBus.addListener(INSTANCE::clientSetup);
            PIT.register(modEventBus);
            IDS.register(modEventBus);
            MinecraftForge.EVENT_BUS.addListener(INSTANCE::clientTick);
        }

        private void clientSetup(FMLClientSetupEvent event) {
            IconRendererRegistry.registerRenderer((IconDataSerializer)ICON_DATA.get(), new XMWaypointRenderer());
        }

        private void clientTick(TickEvent.ClientTickEvent event) {
            if (++this.counter > 20) {
                this.counter = 0;
                this.updateWaypoints();
            }
        }

        public void updateWaypoints() {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                XMWaypoint way;
                WaypointSet wps;
                WaypointsManager waypointsManager;
                XaeroMinimapSession session;
                XMWaypointAddon addon = pois.getOrCreateAddonData(ADDON_ID, () -> new XMWaypointAddon());
                HashSet<Waypoint> _toAdd = new HashSet<Waypoint>();
                Set _toRemove = addon.waypoints.keySet();
                if (((Boolean)ConfigData.CLIENT.enableXaeroMinimapIntegration.get()).booleanValue() && (session = XaeroMinimapSession.getCurrentSession()) != null && (waypointsManager = session.getWaypointsManager()) != null && (wps = waypointsManager.getWaypoints()) != null) {
                    Set wpsList = wps.getList().stream().filter(w -> !w.isDisabled()).collect(Collectors.toSet());
                    _toAdd = new HashSet();
                    for (Waypoint wp : wpsList) {
                        if (addon.waypoints.containsKey(wp)) continue;
                        _toAdd.add(wp);
                    }
                    _toRemove = new HashSet();
                    for (Waypoint wp : addon.waypoints.keySet()) {
                        if (wpsList.contains(wp)) continue;
                        _toRemove.add(wp);
                    }
                }
                HashSet<Waypoint> toAdd = _toAdd;
                Set toRemove = _toRemove;
                for (Waypoint wp : toAdd) {
                    way = new XMWaypoint(wp);
                    addon.waypoints.put(wp, way);
                    pois.get(player.field_70170_p).addPoint(way);
                }
                for (Waypoint wp : toRemove) {
                    way = (XMWaypoint)addon.waypoints.get(wp);
                    addon.waypoints.remove(wp);
                    pois.get(player.field_70170_p).removePoint(way);
                }
            });
        }

        private static class XMWaypointRenderer
        implements IIconRenderer<XMIconData> {
            private final MinimapRendererHelper renderHelper = new MinimapRendererHelper();

            private XMWaypointRenderer() {
            }

            @Override
            public void renderIcon(XMIconData data, PlayerEntity player, TextureManager textureManager, MatrixStack matrixStack, int x, int y) {
                IRenderTypeBuffer.Impl impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, (double)2.8f, 0.0);
                matrixStack.func_227862_a_(0.7777778f, 0.7777778f, 0.7777778f);
                XaeroMinimap.instance.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(matrixStack, this.renderHelper, data.parent, XaeroMinimap.instance.getSettings(), x, y, impl, impl.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS));
                matrixStack.func_227865_b_();
                impl.func_228461_a_();
            }
        }

        private static class XMWaypointAddon {
            private final Map<Waypoint, XMWaypoint> waypoints = Maps.newHashMap();

            private XMWaypointAddon() {
            }
        }

        private static class XMWaypoint
        extends PointInfo<XMWaypoint> {
            private Waypoint parent;

            public XMWaypoint() {
                super((PointInfoType)TYPE.get(), true);
            }

            public XMWaypoint(Waypoint way) {
                super((PointInfoType)TYPE.get(), true, (ITextComponent)new TranslationTextComponent(way.getName()), new XMIconData(way));
                this.parent = way;
            }

            @Override
            public Vector3d getPosition() {
                return new Vector3d((double)this.parent.getX() + 0.5, (double)this.parent.getY() + 0.5, (double)this.parent.getZ() + 0.5);
            }

            @Override
            public ITextComponent getLabel() {
                return new TranslationTextComponent(this.parent.getName());
            }

            @Override
            protected void serializeAdditional(CompoundNBT tag) {
                throw new IllegalStateException("Serialization not supported.");
            }

            @Override
            protected void deserializeAdditional(CompoundNBT tag) {
                throw new IllegalStateException("Serialization not supported.");
            }

            @Override
            protected void serializeAdditional(PacketBuffer tag) {
                throw new IllegalStateException("Serialization not supported.");
            }

            @Override
            protected void deserializeAdditional(PacketBuffer tag) {
                throw new IllegalStateException("Serialization not supported.");
            }
        }

        private static class XMIconData
        implements IIconData<XMIconData> {
            public final Waypoint parent;

            public XMIconData(Waypoint way) {
                this.parent = way;
            }

            @Override
            public IconDataSerializer<XMIconData> getSerializer() {
                return (IconDataSerializer)ICON_DATA.get();
            }

            public static class Serializer
            extends IconDataSerializer<XMIconData> {
                @Override
                public CompoundNBT write(XMIconData data, CompoundNBT tag) {
                    throw new IllegalStateException("Serialization not supported.");
                }

                @Override
                public XMIconData read(CompoundNBT tag) {
                    throw new IllegalStateException("Serialization not supported.");
                }

                @Override
                public void write(XMIconData data, PacketBuffer buffer) {
                    throw new IllegalStateException("Serialization not supported.");
                }

                @Override
                public XMIconData read(PacketBuffer buffer) {
                    throw new IllegalStateException("Serialization not supported.");
                }
            }
        }
    }
}

