/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeRegistryEntryCodec<T extends IForgeRegistryEntry<T>>
implements Codec<T> {
    private static final Map<IForgeRegistry<?>, Codec<?>> cache = Maps.newConcurrentMap();
    private final ForgeRegistry<T> forgeRegistry;
    private final IForgeRegistry<T> registry;

    public static <T extends IForgeRegistryEntry<T>> Codec<T> getOrCreate(IForgeRegistry<T> registry) {
        return cache.computeIfAbsent(registry, ForgeRegistryEntryCodec::new);
    }

    public static <T extends IForgeRegistryEntry<T>> Supplier<Codec<T>> getOrCreate(Supplier<IForgeRegistry<T>> registry) {
        return Lazy.of(() -> ForgeRegistryEntryCodec.getOrCreate((IForgeRegistry)registry.get()));
    }

    private ForgeRegistryEntryCodec(IForgeRegistry<T> registry) {
        this.registry = registry;
        this.forgeRegistry = registry instanceof ForgeRegistry ? (ForgeRegistry)registry : null;
    }

    public <TOps> DataResult<Pair<T, TOps>> decode(DynamicOps<TOps> ops, TOps data) {
        if (ops.compressMaps() && this.forgeRegistry != null) {
            return ops.getNumberValue(data).flatMap(registryId -> {
                IForgeRegistryEntry t = this.forgeRegistry.getValue(registryId.intValue());
                if (t == null) {
                    return DataResult.error((String)("Unknown registry id: " + registryId));
                }
                return DataResult.success((Object)t);
            }).map(encodedValue -> Pair.of((Object)encodedValue, (Object)ops.empty()));
        }
        return ResourceLocation.field_240908_a_.decode(ops, data).flatMap(encodedRegistryPair -> {
            IForgeRegistryEntry t = this.registry.getValue((ResourceLocation)encodedRegistryPair.getFirst());
            if (t == null) {
                return DataResult.error((String)("Unknown registry key: " + encodedRegistryPair.getFirst()));
            }
            return DataResult.success((Object)Pair.of((Object)t, (Object)encodedRegistryPair.getSecond()));
        });
    }

    public <TOps> DataResult<TOps> encode(T entry, DynamicOps<TOps> ops, TOps data) {
        ResourceLocation resourcelocation = this.registry.getKey(entry);
        if (resourcelocation == null) {
            return DataResult.error((String)("Unknown registry element " + entry));
        }
        if (ops.compressMaps() && this.forgeRegistry != null) {
            return ops.mergeToPrimitive(data, ops.createInt(this.forgeRegistry.getID(entry)));
        }
        return ops.mergeToPrimitive(data, ops.createString(resourcelocation.toString()));
    }
}

