/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.util;

import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;

public final class TickScheduler {
    private final PriorityBlockingQueue<ScheduledTask> tasks = new PriorityBlockingQueue();
    private final AtomicInteger currentTick = new AtomicInteger();

    public TickScheduler(boolean server) {
        if (server) {
            MinecraftForge.EVENT_BUS.addListener(this::serverTick);
        } else {
            MinecraftForge.EVENT_BUS.addListener(this::clientTick);
        }
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        this.update();
    }

    private void clientTick(TickEvent.ClientTickEvent event) {
        this.update();
    }

    private void update() {
        ScheduledTask next;
        int current = this.currentTick.incrementAndGet();
        Iterator<ScheduledTask> it = this.tasks.iterator();
        while (it.hasNext() && (next = it.next()).targetTick <= current) {
            next.run();
            it.remove();
        }
    }

    public <T> ScheduledTask schedule(int interval, boolean repeating, Consumer<T> callback, T parameter) {
        ScheduledTask task = new ScheduledTask(this.currentTick.get() + interval, interval, repeating, callback, parameter);
        this.tasks.add(task);
        return task;
    }

    public final class ScheduledTask
    implements Comparable<ScheduledTask> {
        private boolean removed = false;
        private int targetTick;
        private int interval;
        private boolean repeating;
        private final Consumer callback;
        private final Object parameter;

        private ScheduledTask(int targetTick, int interval, boolean repeating, Consumer callback, Object parameter) {
            this.targetTick = targetTick;
            this.interval = interval;
            this.repeating = repeating;
            this.callback = callback;
            this.parameter = parameter;
        }

        public boolean remove() {
            this.removed = true;
            return TickScheduler.this.tasks.remove(this);
        }

        public void setInterval(int interval) {
            if (this.removed) {
                throw new IllegalStateException("This task has been removed");
            }
            TickScheduler.this.tasks.remove(this);
            this.interval = interval;
            this.targetTick = TickScheduler.this.currentTick.get() + interval;
            TickScheduler.this.tasks.add(this);
        }

        public void reset() {
            if (this.removed) {
                throw new IllegalStateException("This task has been removed");
            }
            this.setInterval(this.interval);
        }

        private void run() {
            this.callback.accept(this.parameter);
        }

        @Override
        public int compareTo(ScheduledTask o) {
            int cmp = o.targetTick - this.targetTick;
            if (cmp > 0) {
                return 1;
            }
            if (cmp < 0) {
                return -1;
            }
            return 0;
        }
    }
}

