/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.registries.ObjectHolder;

public class BasicWaypoint
extends PointInfo<BasicWaypoint> {
    @ObjectHolder(value="hudcompass:basic")
    public static PointInfoType<BasicWaypoint> TYPE = null;
    private String label;
    private Vector3d position;

    public BasicWaypoint() {
        super(TYPE, false);
    }

    public BasicWaypoint(BlockPos exactPosition, @Nullable String label, IIconData<?> iconData) {
        this(BasicWaypoint.toVec3d(exactPosition), label, iconData);
    }

    public BasicWaypoint(Vector3d exactPosition, @Nullable String label, IIconData<?> iconData) {
        this(TYPE, exactPosition, label, iconData);
    }

    public BasicWaypoint(PointInfoType<? extends BasicWaypoint> type, Vector3d exactPosition, @Nullable String label, IIconData<?> iconData) {
        super(type, false, (ITextComponent)(label == null ? null : new StringTextComponent(label)), iconData);
        this.position = exactPosition;
        this.label = label == null ? "" : label;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    public void setPosition(Vector3d position) {
        if (MathHelper.func_219806_b((double)position.func_72436_e(position), (double)0.0)) {
            this.position = position;
            this.markDirty();
        }
    }

    public String getLabelText() {
        return this.label;
    }

    public void setLabelText(String label) {
        this.label = Objects.requireNonNull(label);
        super.setLabel((ITextComponent)(label.length() > 0 ? new StringTextComponent(label) : null));
    }

    @Override
    protected void serializeAdditional(CompoundNBT tag) {
        tag.func_74780_a("X", this.position.field_72450_a);
        tag.func_74780_a("Y", this.position.field_72448_b);
        tag.func_74780_a("Z", this.position.field_72449_c);
        tag.func_74778_a("Text", this.label);
    }

    @Override
    protected void deserializeAdditional(CompoundNBT tag) {
        this.position = new Vector3d(tag.func_74769_h("X"), tag.func_74769_h("Y"), tag.func_74769_h("Z"));
        this.label = tag.func_74779_i("Text");
    }

    @Override
    protected void serializeAdditional(PacketBuffer buffer) {
        buffer.writeDouble(this.position.field_72450_a);
        buffer.writeDouble(this.position.field_72448_b);
        buffer.writeDouble(this.position.field_72449_c);
        buffer.func_211400_a(this.label, 1024);
    }

    @Override
    protected void deserializeAdditional(PacketBuffer buffer) {
        this.position = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        this.label = buffer.func_150789_c(1024);
    }
}

