/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass;

import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.client.ClientHandler;
import dev.gigaherz.hudcompass.client.HudOverlay;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.icons.IconDataSerializer;
import dev.gigaherz.hudcompass.integrations.server.SpawnPointPoints;
import dev.gigaherz.hudcompass.integrations.server.VanillaMapPoints;
import dev.gigaherz.hudcompass.integrations.xaerominimap.XaeroMinimapIntegration;
import dev.gigaherz.hudcompass.network.AddWaypoint;
import dev.gigaherz.hudcompass.network.ClientHello;
import dev.gigaherz.hudcompass.network.RemoveWaypoint;
import dev.gigaherz.hudcompass.network.ServerHello;
import dev.gigaherz.hudcompass.network.SyncWaypointData;
import dev.gigaherz.hudcompass.network.UpdateWaypointsFromGui;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hudcompass")
public class HudCompass {
    public static final String MODID = "hudcompass";
    public static HudCompass instance;
    public static final Logger LOGGER;
    public static final String CHANNEL = "main";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;

    public HudCompass() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::newRegistry);
        modEventBus.addGenericListener(IconDataSerializer.class, this::iconDataSerializers);
        modEventBus.addGenericListener(PointInfoType.class, this::pointInfoTypes);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.addListener(this::playerTickEvent);
        MinecraftForge.EVENT_BUS.addListener(this::playerLoggedIn);
        SpawnPointPoints.init();
        VanillaMapPoints.init();
        if (ModList.get().isLoaded("xaerominimap")) {
            XaeroMinimapIntegration.init();
        }
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ConfigData.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigData.COMMON_SPEC);
    }

    public void modConfig(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigData.CLIENT_SPEC) {
            ConfigData.refreshClient();
        }
    }

    public static DeferredRegister<PointInfoType<?>> makeDeferredPOI() {
        return DeferredRegister.create(PointInfoType.class, (String)MODID);
    }

    public static DeferredRegister<IconDataSerializer<?>> makeDeferredIDS() {
        return DeferredRegister.create(IconDataSerializer.class, (String)MODID);
    }

    public void newRegistry(RegistryEvent.NewRegistry event) {
        new RegistryBuilder().setName(HudCompass.location("icon_data_serializers")).setType(IconDataSerializer.class).disableSaving().create();
        new RegistryBuilder().setName(HudCompass.location("point_info_serializers")).setType(PointInfoType.class).disableSaving().create();
    }

    public void iconDataSerializers(RegistryEvent.Register<IconDataSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IconDataSerializer[]{(IconDataSerializer)BasicIconData.Serializer.POI_SERIALIZER.setRegistryName("poi"), (IconDataSerializer)BasicIconData.Serializer.MAP_SERIALIZER.setRegistryName("map_marker")});
    }

    public void pointInfoTypes(RegistryEvent.Register<PointInfoType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new PointInfoType[]{(PointInfoType)new PointInfoType<BasicWaypoint>(BasicWaypoint::new).setRegistryName("basic")});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        PointsOfInterest.init();
        int messageNumber = 0;
        channel.messageBuilder(AddWaypoint.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(AddWaypoint::encode).decoder(AddWaypoint::new).consumer(AddWaypoint::handle).add();
        channel.messageBuilder(RemoveWaypoint.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(RemoveWaypoint::encode).decoder(RemoveWaypoint::new).consumer(RemoveWaypoint::handle).add();
        channel.messageBuilder(ServerHello.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(ServerHello::encode).decoder(ServerHello::new).consumer(ServerHello::handle).add();
        channel.messageBuilder(ClientHello.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(ClientHello::encode).decoder(ClientHello::new).consumer(ClientHello::handle).add();
        channel.messageBuilder(SyncWaypointData.class, messageNumber++, NetworkDirection.PLAY_TO_CLIENT).encoder(SyncWaypointData::encode).decoder(SyncWaypointData::new).consumer(SyncWaypointData::handle).add();
        channel.messageBuilder(UpdateWaypointsFromGui.class, messageNumber++, NetworkDirection.PLAY_TO_SERVER).encoder(UpdateWaypointsFromGui::encode).decoder(UpdateWaypointsFromGui::new).consumer(UpdateWaypointsFromGui::handle).add();
        LOGGER.debug("Final message number: " + messageNumber);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ClientHandler.init();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ClientHandler.initKeybinds();
            HudOverlay.init();
        });
    }

    public void playerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.player;
        PointsOfInterest.onTick((PlayerEntity)player);
    }

    public void playerLoggedIn(EntityJoinWorldEvent event) {
        if (((Boolean)ConfigData.COMMON.disableServerHello.get()).booleanValue()) {
            return;
        }
        Entity player = event.getEntity();
        if (player instanceof ServerPlayerEntity) {
            channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new ServerHello());
        }
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        LOGGER = LogManager.getLogger((String)MODID);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, CHANNEL)).clientAcceptedVersions(v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v)).serverAcceptedVersions(v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v)).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

