/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.client.ClientWaypointManagerScreen;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.network.ClientHello;
import dev.gigaherz.hudcompass.network.RemoveWaypoint;
import dev.gigaherz.hudcompass.network.SyncWaypointData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientHandler {
    public static KeyBinding ADD_WAYPOINT;
    public static KeyBinding REMOVE_WAYPOINT;
    public static KeyBinding EDIT_WAYPOINTS;

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(ClientHandler::clientTickEvent);
    }

    public static void initKeybinds() {
        ADD_WAYPOINT = new KeyBinding("key.hudcompass.add_waypoint", InputMappings.field_197958_a.func_197937_c(), "key.hudcompass.category");
        ClientRegistry.registerKeyBinding((KeyBinding)ADD_WAYPOINT);
        REMOVE_WAYPOINT = new KeyBinding("key.hudcompass.remove_waypoint", InputMappings.field_197958_a.func_197937_c(), "key.hudcompass.category");
        ClientRegistry.registerKeyBinding((KeyBinding)REMOVE_WAYPOINT);
        EDIT_WAYPOINTS = new KeyBinding("key.hudcompass.edit_waypoints", InputMappings.field_197958_a.func_197937_c(), "key.hudcompass.category");
        ClientRegistry.registerKeyBinding((KeyBinding)EDIT_WAYPOINTS);
        MinecraftForge.EVENT_BUS.addListener(ClientHandler::handleKeys);
    }

    public static void handleKeys(TickEvent.ClientTickEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        if (ADD_WAYPOINT.func_151468_f()) {
            mc.field_71439_g.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                Vector3d position = mc.field_71439_g.func_213303_ch();
                String label = String.format("{%1.2f, %1.2f, %1.2f}", position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                pois.get(mc.field_71439_g.field_70170_p).addPointRequest(new BasicWaypoint(position, label, BasicIconData.mapMarker(7)));
            });
            while (ADD_WAYPOINT.func_151468_f()) {
            }
        }
        if (REMOVE_WAYPOINT.func_151468_f()) {
            mc.field_71439_g.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointInfo<?> targetted = pois.getTargetted();
                if (targetted != null && !targetted.isDynamic()) {
                    if (pois.otherSideHasMod) {
                        HudCompass.channel.sendToServer((Object)new RemoveWaypoint(targetted));
                    } else {
                        pois.get(mc.field_71439_g.field_70170_p).removePointRequest(targetted);
                    }
                }
            });
            while (ADD_WAYPOINT.func_151468_f()) {
            }
        }
        if (EDIT_WAYPOINTS.func_151468_f()) {
            mc.field_71439_g.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> mc.func_147108_a((Screen)new ClientWaypointManagerScreen((PointsOfInterest)pois)));
            while (ADD_WAYPOINT.func_151468_f()) {
            }
        }
    }

    public static void clientTickEvent(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            PointsOfInterest.onTick((PlayerEntity)player);
        }
    }

    public static void handleWaypointSync(SyncWaypointData packet) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PointsOfInterest.handleSync((PlayerEntity)player, packet);
    }

    public static void handleServerHello() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            PointsOfInterest.remoteHello((PlayerEntity)player);
        }
        HudCompass.channel.sendToServer((Object)new ClientHello());
    }
}

