/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.io.Files;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hudcompass", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientWaypointDatabase {
    private static final Logger LOGGER = LogManager.getLogger();

    private static Path getPath(Minecraft mc) {
        String address;
        if (mc.func_71387_A()) {
            return mc.func_71401_C().func_71238_n().toPath().resolve("client_waypoints").resolve("waypoints.dat").toAbsolutePath();
        }
        NetworkManager networkManager = mc.field_71439_g.field_71174_a.func_147298_b();
        SocketAddress addr = networkManager.func_74430_c();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress ip = (InetSocketAddress)addr;
            address = ip.getHostString() + "_" + ip.getPort();
        } else {
            address = addr.toString();
        }
        ResourceLocation dim = mc.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_();
        String dimension = dim.func_110624_b() + "_" + dim.func_110623_a();
        return FMLPaths.GAMEDIR.get().resolve("server_waypoints").resolve(address).resolve(dimension).resolve("waypoints.dat").toAbsolutePath();
    }

    private static void populateFromDisk(Minecraft mc) {
        mc.field_71439_g.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
            File backup;
            if (pois.otherSideHasMod) {
                return;
            }
            LOGGER.debug("Joined new dimension, loading...");
            Path filePath = ClientWaypointDatabase.getPath(mc);
            File file = filePath.toFile();
            if (!file.exists() && (backup = new File(file.getAbsolutePath() + ".bak")).exists()) {
                file = backup;
                LOGGER.debug("File did not exist, but a backup was found...");
            }
            if (file.exists()) {
                try {
                    CompoundNBT tag = CompressedStreamTools.func_74797_a((File)file);
                    pois.clear();
                    ListNBT list0 = tag.func_150295_c("Worlds", 10);
                    pois.deserializeNBT(list0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                LOGGER.debug("Done!");
            } else {
                LOGGER.debug("File did not exist.");
            }
        });
    }

    private static void saveToDisk(Minecraft mc) {
        mc.field_71439_g.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
            if (pois.otherSideHasMod) {
                return;
            }
            if (pois.changeNumber > pois.savedNumber) {
                LOGGER.debug("Changes detected, saving.");
                try {
                    Path filePath = ClientWaypointDatabase.getPath(mc);
                    File file = filePath.toFile();
                    if (file.exists()) {
                        LOGGER.debug("File already exists, keeping as backup.");
                        File backup = new File(file.getAbsolutePath() + ".bak");
                        Files.copy((File)file, (File)backup);
                    } else {
                        file.getParentFile().mkdirs();
                    }
                    CompoundNBT tag0 = new CompoundNBT();
                    ListNBT list0 = pois.serializeNBT();
                    tag0.func_218657_a("Worlds", (INBT)list0);
                    CompressedStreamTools.func_74795_b((CompoundNBT)tag0, (File)file);
                    pois.savedNumber = pois.changeNumber;
                    LOGGER.debug("Done!");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null) {
            ClientWaypointDatabase.saveToDisk(mc);
        }
    }

    @SubscribeEvent
    public static void entityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() instanceof ClientPlayerEntity) {
            ClientWaypointDatabase.populateFromDisk(Minecraft.func_71410_x());
        }
    }
}

