/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.gui.ScrollPanel;

public class ClientWaypointManagerScreen
extends Screen {
    private static final ITextComponent TITLE = new TranslationTextComponent("text.hudcompass.waypoint_editor.title");
    private static final Pattern COORD_VALIDATOR = Pattern.compile("^-?[0-9]*\\.?[0-9]*$");
    private static final Pattern COORD_FORMAT = Pattern.compile("^-?[0-9]+\\.?[0-9]+$");
    private static final Predicate<String> COORD_FORMAT_MATCHER = COORD_FORMAT.asPredicate();
    private static final int MARGIN_LEFT = 8;
    private static final int MARGIN_TOP = 32;
    private static final int MARGIN_RIGHT = 8;
    private static final int MARGIN_BOTTOM = 34;
    private final List<WaypointListItem> toAdd = new ArrayList<WaypointListItem>();
    private final List<WaypointListItem> toUpdate = new ArrayList<WaypointListItem>();
    private final List<WaypointListItem> toRemove = new ArrayList<WaypointListItem>();
    private final PointsOfInterest pois;
    private ItemsScrollPanel scrollPanel;
    private Button saveButton;

    protected ClientWaypointManagerScreen(PointsOfInterest pois) {
        super(TITLE);
        this.pois = pois;
        pois.addListener(this::onSyncReceived);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.pois.removeListener(this::onSyncReceived);
    }

    private void setDirty() {
        this.saveButton.field_230693_o_ = true;
    }

    private void onSyncReceived() {
        this.scrollPanel.clear();
        this.loadWaypoints();
        this.scrollPanel.scrollTop();
    }

    private void loadWaypoints() {
        this.pois.getAllWorlds().stream().sorted(Comparator.comparing(w -> w.getWorldKey().func_240901_a_())).forEach(world -> {
            WorldListItem worldItem = this.addWorld(world.getWorldKey(), world.getDimensionTypeKey());
            for (PointInfo<?> point : world.getPoints()) {
                if (point.isDynamic() || !(point instanceof BasicWaypoint)) continue;
                BasicWaypoint wp = (BasicWaypoint)point;
                this.addPoint(worldItem, wp);
            }
            this.addNewWaypointItem(worldItem);
        });
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.scrollPanel = new ItemsScrollPanel(this.field_230706_i_, this.field_230708_k_ - 8 - 8, this.field_230709_l_ - 32 - 34, 32, 8);
        this.func_230481_d_((IGuiEventListener)this.scrollPanel);
        this.saveButton = new Button(8, this.field_230709_l_ - 28, 120, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.save"), button -> {
            this.scrollPanel.saveAll();
            this.pois.updateFromGui((ImmutableList)this.toAdd.stream().map(i -> Pair.of((Object)((WaypointListItem)i).worldItem.worldKey.func_240901_a_(), (Object)((WaypointListItem)i).pointInfo)).collect(ImmutableList.toImmutableList()), (ImmutableList)this.toUpdate.stream().map(i -> Pair.of((Object)((WaypointListItem)i).worldItem.worldKey.func_240901_a_(), (Object)((WaypointListItem)i).pointInfo)).collect(ImmutableList.toImmutableList()), (ImmutableList<UUID>)((ImmutableList)this.toRemove.stream().map(i -> ((WaypointListItem)i).pointInfo.getInternalId()).collect(ImmutableList.toImmutableList())));
            this.func_231175_as__();
        });
        this.func_230480_a_((Widget)this.saveButton);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 128, this.field_230709_l_ - 28, 120, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.cancel"), button -> this.func_231175_as__()));
        this.loadWaypoints();
        this.scrollPanel.scrollTop();
        this.saveButton.field_230693_o_ = false;
    }

    private void createNewPoint(WorldListItem worldItem) {
        BasicWaypoint wp = new BasicWaypoint(this.getPlayerPositionScaled(worldItem), "", BasicIconData.mapMarker(7));
        WaypointListItem item = new WaypointListItem(this.field_230706_i_, wp, worldItem);
        int index = worldItem.waypoints.size() - 1;
        WorldListItem after = index >= 0 ? (ListItem)((Object)worldItem.waypoints.get(index)) : worldItem;
        this.scrollPanel.insertAfter(item, after);
        worldItem.addWaypoint(item);
        this.toAdd.add(item);
        this.scrollPanel.scrollToItem(item);
        this.setDirty();
    }

    private Vector3d getPlayerPositionScaled(WorldListItem world) {
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        Vector3d pos = player.func_213303_ch();
        if (player.field_70170_p.func_234923_W_() != world.worldKey) {
            if (world.dimensionTypeKey != null) {
                DynamicRegistries dyn = player.field_71174_a.func_239165_n_();
                DimensionType type = (DimensionType)dyn.func_230520_a_().func_243576_d(world.dimensionTypeKey);
                double scale = DimensionType.func_242715_a((DimensionType)player.field_70170_p.func_230315_m_(), (DimensionType)type);
                pos = new Vector3d(pos.field_72450_a * scale, pos.field_72448_b, pos.field_72449_c * scale);
            } else if (player.field_70170_p.func_234923_W_() == World.field_234919_h_ && world.worldKey != World.field_234919_h_) {
                pos = new Vector3d(pos.field_72450_a * 8.0, pos.field_72448_b, pos.field_72449_c * 8.0);
            } else if (player.field_70170_p.func_234923_W_() != World.field_234919_h_ && world.worldKey == World.field_234919_h_) {
                pos = new Vector3d(pos.field_72450_a / 8.0, pos.field_72448_b, pos.field_72449_c / 8.0);
            }
        }
        return pos;
    }

    private WorldListItem addWorld(RegistryKey<World> worldKey, RegistryKey<DimensionType> dimensionTypeKey) {
        WorldListItem item = new WorldListItem(this.field_230706_i_, worldKey, dimensionTypeKey);
        this.scrollPanel.addItem(item);
        return item;
    }

    private void addNewWaypointItem(WorldListItem item) {
        NewWaypointListItem newWaypoint = new NewWaypointListItem(this.field_230706_i_, item);
        item.setNewWaypoint(newWaypoint);
        this.scrollPanel.addItem(newWaypoint);
    }

    private void addPoint(WorldListItem worldItem, BasicWaypoint wp) {
        WaypointListItem item = new WaypointListItem(this.field_230706_i_, wp, worldItem);
        worldItem.addWaypoint(item);
        this.scrollPanel.addItem(item);
    }

    private void deletePoint(WaypointListItem item) {
        if (!this.toAdd.remove((Object)item)) {
            this.toRemove.add(item);
        }
        this.scrollPanel.removeItem(item);
        item.worldItem.removeWaypoint(item);
        this.setDirty();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.scrollPanel.setPartialTicks(partialTicks);
        this.scrollPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ClientWaypointManagerScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)7, (int)-1);
        int nameWidth = Math.max(this.scrollPanel.getContentWidth() - 212, 50);
        int x = this.scrollPanel.getLeft() + 6;
        int y = this.scrollPanel.getTop() - 10;
        ClientWaypointManagerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_label"), (int)x, (int)y, (int)-1);
        ClientWaypointManagerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_x"), (int)(x += nameWidth + 3), (int)y, (int)-1);
        ClientWaypointManagerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_y"), (int)(x += 61), (int)y, (int)-1);
        ClientWaypointManagerScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_z"), (int)(x += 41), (int)y, (int)-1);
    }

    private class WaypointListItem
    extends CompositeListItem {
        private final BasicWaypoint pointInfo;
        private final WorldListItem worldItem;
        private TextFieldWidget label;
        private TextFieldWidget xCoord;
        private TextFieldWidget yCoord;
        private TextFieldWidget zCoord;
        private Button changeSymbol;
        private Button delete;
        private String labelText;
        private String xText;
        private String yText;
        private String zText;

        public WaypointListItem(Minecraft minecraft, BasicWaypoint pointInfo, WorldListItem worldItem) {
            super(minecraft, 22);
            this.pointInfo = pointInfo;
            this.worldItem = worldItem;
        }

        @Override
        public void init() {
            super.init();
            Vector3d pos = this.pointInfo.getPosition();
            int nameWidth = Math.max(this.getWidth() - 212, 50);
            int x = 2;
            this.label = new TextFieldWidget(this.minecraft.field_71466_p, x + 1, 2, nameWidth, 16, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_label"));
            this.addWidget((IRenderable)this.label);
            this.xCoord = new TextFieldWidget(this.minecraft.field_71466_p, (x += nameWidth + 3) + 1, 2, 60, 16, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_x"));
            this.addWidget((IRenderable)this.xCoord);
            this.yCoord = new TextFieldWidget(this.minecraft.field_71466_p, (x += 61) + 1, 2, 40, 16, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_y"));
            this.addWidget((IRenderable)this.yCoord);
            this.zCoord = new TextFieldWidget(this.minecraft.field_71466_p, (x += 41) + 1, 2, 60, 16, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.header_z"));
            this.addWidget((IRenderable)this.zCoord);
            this.changeSymbol = new Button(x += 63, 0, 20, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.change_symbol"), button -> {});
            this.addWidget((IRenderable)this.changeSymbol);
            this.delete = new Button(x += 21, 0, 20, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.delete"), button -> ClientWaypointManagerScreen.this.deletePoint(this));
            this.addWidget((IRenderable)this.delete);
            this.changeSymbol.field_230693_o_ = false;
            this.label.func_146203_f(1024);
            this.label.func_146180_a(this.pointInfo.getLabelText());
            this.xCoord.func_146180_a(String.format(Locale.ROOT, "%1.2f", pos.field_72450_a));
            this.yCoord.func_146180_a(String.format(Locale.ROOT, "%1.2f", pos.field_72448_b));
            this.zCoord.func_146180_a(String.format(Locale.ROOT, "%1.2f", pos.field_72449_c));
            this.xCoord.func_200675_a(COORD_VALIDATOR.asPredicate());
            this.yCoord.func_200675_a(COORD_VALIDATOR.asPredicate());
            this.zCoord.func_200675_a(COORD_VALIDATOR.asPredicate());
            this.label.func_212954_a(str -> {
                this.labelText = str != null ? str : "";
                this.setDirty();
            });
            this.xCoord.func_212954_a(str -> {
                this.xText = str != null ? str : "";
                this.setDirty();
            });
            this.yCoord.func_212954_a(str -> {
                this.yText = str != null ? str : "";
                this.setDirty();
            });
            this.zCoord.func_212954_a(str -> {
                this.zText = str != null ? str : "";
                this.setDirty();
            });
        }

        @Override
        public void save() {
            if (this.isDirty()) {
                this.labelText = this.label.func_146179_b();
                this.xText = this.xCoord.func_146179_b();
                this.yText = this.yCoord.func_146179_b();
                this.zText = this.zCoord.func_146179_b();
                if (COORD_FORMAT_MATCHER.test(this.xText) && COORD_FORMAT_MATCHER.test(this.yText) && COORD_FORMAT_MATCHER.test(this.zText)) {
                    this.pointInfo.setLabelText(this.labelText == null ? "" : this.labelText);
                    this.pointInfo.setPosition(new Vector3d(Double.parseDouble(this.xText), Double.parseDouble(this.yText), Double.parseDouble(this.zText)));
                }
                if (!ClientWaypointManagerScreen.this.toAdd.contains((Object)this)) {
                    ClientWaypointManagerScreen.this.toUpdate.add(this);
                }
            }
        }
    }

    private class WorldListItem
    extends CompositeListItem {
        private final TranslationTextComponent title;
        private final RegistryKey<World> worldKey;
        private final List<WaypointListItem> waypoints;
        private final RegistryKey<DimensionType> dimensionTypeKey;
        private boolean folded;
        private NewWaypointListItem newWaypoint;

        public void setNewWaypoint(NewWaypointListItem newWaypoint) {
            this.newWaypoint = newWaypoint;
        }

        public WorldListItem(Minecraft minecraft, RegistryKey<World> key, RegistryKey<DimensionType> dimensionTypeKey) {
            super(minecraft, 22);
            this.waypoints = Lists.newArrayList();
            this.title = new TranslationTextComponent("text.hudcompass.waypoint_editor.world", new Object[]{key.func_240901_a_()});
            this.worldKey = key;
            this.dimensionTypeKey = dimensionTypeKey;
        }

        @Override
        public void init() {
            super.init();
            this.addWidget((IRenderable)new Button(1, 1, 20, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.fold"), button -> {
                boolean bl = this.folded = !this.folded;
                if (this.folded) {
                    button.func_238482_a_((ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.unfold"));
                } else {
                    button.func_238482_a_((ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.fold"));
                }
                this.waypoints.forEach(w -> w.setVisible(!this.folded));
                this.newWaypoint.setVisible(!this.folded);
                ClientWaypointManagerScreen.this.scrollPanel.recalculateHeight();
            }));
        }

        @Override
        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            WorldListItem.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.minecraft.field_71466_p, (ITextComponent)this.title, (int)24, (int)10, (int)-1);
        }

        public void addWaypoint(WaypointListItem item) {
            this.waypoints.add(item);
        }

        public void removeWaypoint(WaypointListItem item) {
            this.waypoints.remove((Object)item);
        }
    }

    private class ItemsScrollPanel
    extends ScrollPanel {
        private final List<ListItem> items;
        private final Minecraft minecraft;
        private int contentHeight;
        private float partialTicks;
        private boolean dirty;

        public ItemsScrollPanel(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.items = Lists.newArrayList();
            this.minecraft = client;
        }

        public void addItem(ListItem item) {
            this.addItem(this.items.size(), item);
        }

        public void insertAfter(WaypointListItem item, ListItem after) {
            int index = this.items.indexOf((Object)after);
            this.addItem(index >= 0 ? index + 1 : this.items.size(), item);
        }

        public void addItem(int index, ListItem item) {
            this.items.add(index, item);
            item.setParent(this);
            this.recalculateHeight();
            item.setWidth(this.getContentWidth());
            item.init();
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        public void setPartialTicks(float partialTicks) {
            this.partialTicks = partialTicks;
        }

        protected void drawPanel(MatrixStack mStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            mStack.func_227860_a_();
            mStack.func_227861_a_((double)this.left, (double)relativeY, 0.0);
            for (ListItem item : this.items) {
                if (!item.isVisible()) continue;
                mStack.func_227860_a_();
                mStack.func_227861_a_(0.0, (double)item.getTop(), 0.0);
                item.func_230430_a_(mStack, mouseX, mouseY, this.partialTicks);
                mStack.func_227865_b_();
            }
            mStack.func_227865_b_();
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.items;
        }

        public void recalculateHeight() {
            int totalHeight = 0;
            for (ListItem item : this.items) {
                if (!item.isVisible()) continue;
                item.setTop(totalHeight);
                totalHeight += item.getHeight();
            }
            this.contentHeight = totalHeight;
        }

        public int getLeft() {
            return this.left;
        }

        public int getTop() {
            return this.top;
        }

        public int getContentTop() {
            int baseY = this.top + 4 - (int)this.scrollDistance;
            return baseY;
        }

        public void saveAll() {
            this.items.forEach(item -> item.save());
        }

        public int getContentWidth() {
            return this.right - this.left - 6;
        }

        public void removeItem(ListItem item) {
            item.setParent(null);
            this.items.remove((Object)item);
            this.recalculateHeight();
        }

        public void scrollToItem(ListItem item) {
            int scrollOffset = item.getTop() - this.height / 2 - item.getHeight();
            this.scrollDistance = MathHelper.func_76125_a((int)scrollOffset, (int)0, (int)Math.max(0, this.getContentHeight() - (this.height - 4)));
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            this.scrollDistance = MathHelper.func_76131_a((float)this.scrollDistance, (float)0.0f, (float)Math.max(0, this.getContentHeight() - (this.height - 4)));
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        }

        public void scrollTop() {
            this.scrollDistance = 0.0f;
        }

        public void clear() {
            this.items.forEach(item -> item.setParent(null));
            this.items.clear();
        }

        protected void setDirty() {
            this.dirty = true;
            ClientWaypointManagerScreen.this.setDirty();
        }
    }

    private static abstract class ListItem
    extends FocusableGui
    implements IRenderable {
        protected final Minecraft minecraft;
        private ItemsScrollPanel parent;
        private int height;
        private int width;
        private int top;
        private boolean visible = true;
        private boolean dirty;

        public ListItem(Minecraft minecraft, int height) {
            this.minecraft = minecraft;
            this.height = height;
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
            if (this.parent != null) {
                this.parent.recalculateHeight();
            }
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Nullable
        protected ItemsScrollPanel getParent() {
            return this.parent;
        }

        public void setParent(ItemsScrollPanel parent) {
            this.parent = parent;
        }

        public void init() {
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        }

        public void save() {
        }

        protected boolean isDirty() {
            return this.dirty;
        }

        protected void setDirty() {
            this.dirty = true;
            if (this.parent != null) {
                this.parent.setDirty();
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            if (this.visible != visible) {
                this.visible = visible;
            }
        }
    }

    private class NewWaypointListItem
    extends CompositeListItem {
        WorldListItem owner;

        public NewWaypointListItem(Minecraft minecraft, WorldListItem owner) {
            super(minecraft, 24);
            this.owner = owner;
        }

        @Override
        public void init() {
            super.init();
            this.addWidget((IRenderable)new Button(this.getWidth() - 121, 1, 120, 20, (ITextComponent)new TranslationTextComponent("text.hudcompass.waypoint_editor.new_waypoint"), button -> ClientWaypointManagerScreen.this.createNewPoint(this.owner)));
        }
    }

    private static class CompositeListItem
    extends ListItem {
        private final List<IRenderable> renderables = Lists.newArrayList();
        private final List<IGuiEventListener> listeners = Lists.newArrayList();

        public CompositeListItem(Minecraft minecraft, int height) {
            super(minecraft, height);
        }

        @Override
        public void init() {
            super.init();
            this.renderables.clear();
            this.listeners.clear();
        }

        public CompositeListItem addWidget(IRenderable widget) {
            if (widget instanceof IGuiEventListener) {
                this.addListener((IGuiEventListener)widget);
            }
            this.renderables.add(widget);
            return this;
        }

        public CompositeListItem addListener(IGuiEventListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return this.listeners;
        }

        private int getActualX(int mouseX) {
            int x = mouseX;
            if (this.getParent() != null) {
                x -= this.getParent().getLeft();
            }
            return x;
        }

        private double getActualX(double mouseX) {
            double x = mouseX;
            if (this.getParent() != null) {
                x -= (double)this.getParent().getLeft();
            }
            return x;
        }

        private int getActualY(int mouseY) {
            int y = mouseY - this.getTop();
            if (this.getParent() != null) {
                y -= this.getParent().getContentTop();
            }
            return y;
        }

        private double getActualY(double mouseY) {
            double y = mouseY - (double)this.getTop();
            if (this.getParent() != null) {
                y -= (double)this.getParent().getContentTop();
            }
            return y;
        }

        @Override
        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (!this.isVisible()) {
                return;
            }
            int actualMouseX = this.getActualX(mouseX);
            int actualMouseY = this.getActualY(mouseY);
            if (actualMouseX >= 0 && actualMouseX < this.getWidth() && actualMouseY >= 0 && actualMouseY <= this.getHeight()) {
                CompositeListItem.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0x1FFFFFFF);
            }
            for (IRenderable i : this.renderables) {
                i.func_230430_a_(matrixStack, actualMouseX, actualMouseY, partialTicks);
            }
        }

        public Optional<IGuiEventListener> func_212930_a(double mouseX, double mouseY) {
            if (!this.isVisible()) {
                return Optional.empty();
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                if (!iGuiEventListener.func_231047_b_(actualMouseX, actualMouseY)) continue;
                return Optional.of(iGuiEventListener);
            }
            return Optional.empty();
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                if (!iGuiEventListener.func_231044_a_(actualMouseX, actualMouseY, button)) continue;
                this.func_231035_a_(iGuiEventListener);
                if (button == 0) {
                    this.func_231037_b__(true);
                }
                return true;
            }
            return false;
        }

        public boolean func_231048_c_(double mouseX, double mouseY, int button) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            this.func_231037_b__(false);
            return this.func_212930_a(mouseX, mouseY).filter(listener -> listener.func_231048_c_(actualMouseX, actualMouseY, button)).isPresent();
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            return this.func_241217_q_() != null && this.func_231041_ay__() && button == 0 && this.func_241217_q_().func_231045_a_(actualMouseX, actualMouseY, button, dragX, dragY);
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
            if (!this.isVisible()) {
                return false;
            }
            double actualMouseX = this.getActualX(mouseX);
            double actualMouseY = this.getActualY(mouseY);
            return this.func_212930_a(mouseX, mouseY).filter(listener -> listener.func_231043_a_(actualMouseX, actualMouseY, delta)).isPresent();
        }

        public boolean func_231049_c__(boolean focus) {
            Supplier<IGuiEventListener> supplier;
            BooleanSupplier booleansupplier;
            boolean flag;
            if (!this.isVisible()) {
                return false;
            }
            IGuiEventListener iguieventlistener = this.func_241217_q_();
            boolean bl = flag = iguieventlistener != null;
            if (flag && iguieventlistener.func_231049_c__(focus)) {
                return true;
            }
            List<? extends IGuiEventListener> list = this.func_231039_at__();
            int j = list.indexOf(iguieventlistener);
            int i = flag && j >= 0 ? j + (focus ? 1 : 0) : (focus ? 0 : list.size());
            ListIterator<? extends IGuiEventListener> listiterator = list.listIterator(i);
            BooleanSupplier booleanSupplier = focus ? listiterator::hasNext : (booleansupplier = listiterator::hasPrevious);
            Supplier<IGuiEventListener> supplier2 = focus ? listiterator::next : (supplier = listiterator::previous);
            while (booleansupplier.getAsBoolean()) {
                IGuiEventListener iguieventlistener1 = supplier.get();
                if (!iguieventlistener1.func_231049_c__(focus)) continue;
                this.func_231035_a_(iguieventlistener1);
                return true;
            }
            this.func_231035_a_(null);
            return false;
        }
    }
}

