/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import dev.gigaherz.hudcompass.waypoints.client.PointRenderer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HudOverlay
extends AbstractGui {
    public static final ResourceLocation LOCATION_MAP_ICONS = new ResourceLocation("minecraft", "textures/map/map_icons.png");
    public static final ResourceLocation LOCATION_POI_ICONS = new ResourceLocation("hudcompass", "textures/poi_icons.png");
    private final Minecraft mc;
    private final FontRenderer font;
    private final TextureManager textureManager;
    Set<RenderGameOverlayEvent.ElementType> NOT_BEFORE = Sets.newHashSet((Object[])new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.VIGNETTE, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.PORTAL, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.BOSSINFO});
    boolean drawnThisFrame = false;
    boolean needsPop = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new HudOverlay());
    }

    private HudOverlay() {
        this.mc = Minecraft.func_71410_x();
        this.font = this.mc.field_71466_p;
        this.textureManager = this.mc.field_71446_o;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void preOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.drawnThisFrame = false;
            this.needsPop = false;
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH && !this.mc.field_71474_y.field_74319_N && !event.isCanceled()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)28.0f, (float)0.0f);
            this.needsPop = true;
        }
        if (this.mc.field_71474_y.field_74319_N || this.drawnThisFrame) {
            return;
        }
        if (this.NOT_BEFORE.contains(event.getType())) {
            return;
        }
        this.renderCompass(event.getMatrixStack());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void postOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.BOSSHEALTH && this.needsPop) {
            RenderSystem.popMatrix();
        }
        if (this.mc.field_71474_y.field_74319_N || this.drawnThisFrame) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.renderCompass(event.getMatrixStack());
        }
    }

    private void renderCompass(MatrixStack matrixStack) {
        float partialTicks = 0.0f;
        float elapsed = 0.0f;
        if (!this.mc.func_147113_T()) {
            partialTicks = this.mc.func_184121_ak();
            elapsed = this.mc.func_193989_ak();
        }
        int xPos = this.mc.func_228018_at_().func_198107_o() / 2;
        float yaw = MathHelper.func_219799_g((float)partialTicks, (float)this.mc.field_71439_g.field_70758_at, (float)this.mc.field_71439_g.field_70759_as) % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        HudOverlay.fillRect(matrixStack, xPos - 90, 10.0f, xPos + 90, 18.0f, 0x3F000000);
        this.drawCardinalDirection(matrixStack, yaw, 0.0f, xPos, "S");
        this.drawCardinalDirection(matrixStack, yaw, 90.0f, xPos, "W");
        this.drawCardinalDirection(matrixStack, yaw, 180.0f, xPos, "N");
        this.drawCardinalDirection(matrixStack, yaw, 270.0f, xPos, "E");
        HudOverlay.fillRect(matrixStack, (float)xPos - 1.5f, 10.0f, (float)xPos - 0.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(matrixStack, (float)xPos + 0.5f, 10.0f, (float)xPos + 1.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(matrixStack, (float)(xPos - 45) - 0.5f, 10.0f, (float)(xPos - 45) + 0.5f, 18.0f, 0x3FFFFFFF);
        HudOverlay.fillRect(matrixStack, (float)(xPos + 45) - 0.5f, 10.0f, (float)(xPos + 45) + 0.5f, 18.0f, 0x3FFFFFFF);
        ClientPlayerEntity player = this.mc.field_71439_g;
        double playerPosX = MathHelper.func_219803_d((double)partialTicks, (double)this.mc.field_71439_g.field_70169_q, (double)this.mc.field_71439_g.func_226277_ct_());
        double playerPosY = MathHelper.func_219803_d((double)partialTicks, (double)this.mc.field_71439_g.field_70167_r, (double)this.mc.field_71439_g.func_226278_cu_());
        double playerPosZ = MathHelper.func_219803_d((double)partialTicks, (double)this.mc.field_71439_g.field_70166_s, (double)this.mc.field_71439_g.func_226281_cx_());
        float yaw0 = yaw;
        float elapsed0 = elapsed;
        player.getCapability(PointsOfInterest.INSTANCE).ifPresent(arg_0 -> this.lambda$renderCompass$1((PlayerEntity)player, yaw0, playerPosX, playerPosY, playerPosZ, matrixStack, xPos, elapsed0, arg_0));
        this.drawnThisFrame = true;
    }

    private Vector2f angleFromPoint(Vector3d position, double playerPosX, double playerPosY, double playerPosZ) {
        double xd = position.field_72450_a - playerPosX;
        double yd = position.field_72448_b - playerPosY;
        double zd = position.field_72449_c - playerPosZ;
        return new Vector2f((float)Math.toDegrees(-Math.atan2(xd, zd)), (float)yd);
    }

    private void drawCardinalDirection(MatrixStack matrixStack, float yaw, float angle, int xPos, String text) {
        float nDist = this.angleDistance(yaw, angle);
        if (Math.abs(nDist) <= 90.0f) {
            float nPos = (float)xPos + nDist;
            HudOverlay.fillRect(matrixStack, nPos - 0.5f, 10.0f, nPos + 0.5f, 18.0f, Integer.MAX_VALUE);
            if (this.mc.field_71474_y.field_216844_T) {
                this.drawCenteredShadowString(matrixStack, this.font, text, nPos, 1.0f, 0xFFFFFF);
            } else {
                HudOverlay.drawCenteredBoxedString(matrixStack, this.font, text, nPos, 1.0f, 0xFFFFFF);
            }
        }
    }

    public void drawCenteredShadowString(MatrixStack matrixStack, FontRenderer font, String text, float x, float y, int color) {
        float width = font.func_78256_a(text);
        font.func_238405_a_(matrixStack, text, x - width / 2.0f, y, color);
    }

    public static void drawCenteredBoxedString(MatrixStack matrixStack, FontRenderer font, String text, float x, float y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        float width = font.func_78256_a(text);
        Objects.requireNonNull(font);
        float height = 9.0f;
        float width1 = width + 4.0f;
        float height1 = height + 3.0f;
        float x0 = x - width1 / 2.0f;
        HudOverlay.fillRect(matrixStack, x0, y, x0 + width1, y + height1, (int)MathHelper.func_151237_a((double)(mc.field_71474_y.field_216845_l * (double)(color >> 24 & 0xFF)), (double)0.0, (double)255.0) << 24);
        font.func_238405_a_(matrixStack, text, x - width / 2.0f, y + 2.0f, color);
        RenderSystem.enableBlend();
    }

    public static void drawCenteredBoxedString(MatrixStack matrixStack, FontRenderer font, ITextComponent text, float x, float y, int color) {
        IReorderingProcessor reodering = text.func_241878_f();
        Minecraft mc = Minecraft.func_71410_x();
        float width = font.func_243245_a(reodering);
        Objects.requireNonNull(font);
        float height = 9.0f;
        float width1 = width + 4.0f;
        float height1 = height + 3.0f;
        float x0 = x - width1 / 2.0f;
        HudOverlay.fillRect(matrixStack, x0, y, x0 + width1, y + height1, (int)MathHelper.func_151237_a((double)(mc.field_71474_y.field_216845_l * (double)(color >> 24 & 0xFF)), (double)0.0, (double)255.0) << 24);
        font.func_238407_a_(matrixStack, reodering, x - width / 2.0f, y + 2.0f, color);
        RenderSystem.enableBlend();
    }

    private void drawPoi(PlayerEntity player, MatrixStack matrixStack, float yaw, float angle, float yDelta, int xPos, PointInfo<?> point, boolean isTargetted, float elapsed) {
        float nDist = this.angleDistance(yaw, angle);
        if (Math.abs(nDist) <= 90.0f) {
            boolean showLabel;
            float nPos = (float)xPos + nDist;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)nPos, 0.0, 0.0);
            PointRenderer.renderIcon(point, player, this.textureManager, matrixStack, 0, 14);
            boolean bl = showLabel = ConfigData.alwaysShowLabels || ConfigData.alwaysShowFocusedLabel && isTargetted || ConfigData.showAllLabelsOnSneak && Screen.func_231173_s_();
            if (ConfigData.animateLabels) {
                if (showLabel && point.fade < 255.0f) {
                    point.fade = Math.min(point.fade + 35.0f * elapsed, 255.0f);
                } else if (!showLabel && point.fade > 0.0f) {
                    point.fade = Math.max(point.fade - 35.0f * elapsed, 0.0f);
                }
            } else {
                float f = point.fade = showLabel ? 255.0f : 0.0f;
            }
            if (point.fade > 3.0f) {
                PointRenderer.renderLabel(point, this.font, matrixStack, 0, 20, (int)point.fade);
            }
            if (point.displayVerticalDistance(player)) {
                if (yDelta >= 2.0f) {
                    this.drawAboveArrow(matrixStack, nPos, yDelta);
                }
                if (yDelta <= -2.0f) {
                    this.drawBelowArrow(matrixStack, nPos, yDelta);
                }
            }
            matrixStack.func_227865_b_();
        }
    }

    private void drawAboveArrow(MatrixStack matrixStack, float nPos, float yDelta) {
        int x = yDelta > 10.0f ? 8 : 0;
        boolean y = false;
        this.textureManager.func_110577_a(LOCATION_POI_ICONS);
        HudOverlay.blitRect(matrixStack, -4.5f, 4.0f, x, (float)y, 8.0f, 8.0f, 128, 128);
    }

    private void drawBelowArrow(MatrixStack matrixStack, float nPos, float yDelta) {
        int x = yDelta < -10.0f ? 24 : 16;
        boolean y = false;
        this.textureManager.func_110577_a(LOCATION_POI_ICONS);
        HudOverlay.blitRect(matrixStack, -4.5f, 16.0f, x, (float)y, 8.0f, 8.0f, 128, 128);
    }

    private static void fillRect(MatrixStack matrixStack, float x0, float y0, float x1, float y1, int color) {
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        RenderSystem.disableTexture();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, x0, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, x1, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, x1, y0, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(matrix, x0, y0, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        tess.func_78381_a();
        RenderSystem.enableTexture();
    }

    private static void blitRect(MatrixStack matrixStack, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight) {
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        float tx0 = xt / (float)tWidth;
        float ty0 = yt / (float)tHeight;
        float tx1 = tx0 + width / (float)tWidth;
        float ty1 = ty0 + height / (float)tHeight;
        float x1 = x0 + width;
        float y1 = y0 + height;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder builder = tess.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        builder.func_227888_a_(matrix, x0, y1, 0.0f).func_225583_a_(tx0, ty1).func_181675_d();
        builder.func_227888_a_(matrix, x1, y1, 0.0f).func_225583_a_(tx1, ty1).func_181675_d();
        builder.func_227888_a_(matrix, x1, y0, 0.0f).func_225583_a_(tx1, ty0).func_181675_d();
        builder.func_227888_a_(matrix, x0, y0, 0.0f).func_225583_a_(tx0, ty0).func_181675_d();
        tess.func_78381_a();
    }

    private float angleDistance(float yaw, float other) {
        float dist = other - yaw;
        if (dist > 0.0f) {
            return dist > 180.0f ? dist - 360.0f : dist;
        }
        return dist < -180.0f ? dist + 360.0f : dist;
    }

    private /* synthetic */ void lambda$renderCompass$1(PlayerEntity player, float yaw0, double playerPosX, double playerPosY, double playerPosZ, MatrixStack matrixStack, int xPos, float elapsed0, PointsOfInterest pts) {
        ArrayList sortedPoints = Lists.newArrayList(pts.get(player.field_70170_p).getPoints());
        sortedPoints.sort((a, b) -> {
            Vector3d positionA = a.getPosition();
            Vector3d positionB = b.getPosition();
            float angleA = Math.abs(this.angleDistance(yaw0, this.angleFromPoint((Vector3d)positionA, (double)playerPosX, (double)playerPosY, (double)playerPosZ).field_189982_i));
            float angleB = Math.abs(this.angleDistance(yaw0, this.angleFromPoint((Vector3d)positionB, (double)playerPosX, (double)playerPosY, (double)playerPosZ).field_189982_i));
            return (int)Math.signum(angleB - angleA);
        });
        for (PointInfo point : sortedPoints) {
            Vector3d position = point.getPosition();
            Vector2f angleYd = this.angleFromPoint(position, playerPosX, playerPosY, playerPosZ);
            this.drawPoi(player, matrixStack, yaw0, angleYd.field_189982_i, angleYd.field_189983_j, xPos, point, point == pts.getTargetted(), elapsed0);
        }
    }
}

