/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.integrations.server;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;

public class VanillaMapPoints {
    public static final VanillaMapPoints INSTANCE = new VanillaMapPoints();
    private static final ResourceLocation ADDON_ID = HudCompass.location("vanilla_map");
    private static final DeferredRegister<PointInfoType<?>> PIT = HudCompass.makeDeferredPOI();
    public static final RegistryObject<PointInfoType<MapDecorationWaypoint>> DECORATION_TYPE = PIT.register("map_decoration", () -> new PointInfoType<MapDecorationWaypoint>(MapDecorationWaypoint::new));
    public static final RegistryObject<PointInfoType<MapBannerWaypoint>> BANNER_TYPE = PIT.register("map_banner", () -> new PointInfoType<MapBannerWaypoint>(MapBannerWaypoint::new));
    private int counter = 0;

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(INSTANCE::clientSetup);
        PIT.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        if (++this.counter > 20) {
            this.counter = 0;
            PlayerEntity player = event.player;
            if (player.field_70170_p.field_72995_K) {
                return;
            }
            player.getCapability(PointsOfInterest.INSTANCE).ifPresent(pois -> {
                PointsOfInterest.WorldPoints worldPoints = pois.get(player.field_70170_p);
                VanillaMapData addon = pois.getOrCreateAddonData(ADDON_ID, () -> new VanillaMapData());
                Set<MapData> seenMaps = this.getMapData(player, worldPoints, addon);
                HashSet<MapData> toRemove = new HashSet<MapData>(addon.mapDecorations.keySet());
                toRemove.removeAll(seenMaps);
                for (MapData remove : toRemove) {
                    Map<MapDecoration, PointInfo<?>> map = addon.mapDecorations.get(remove);
                    for (PointInfo<?> pt : map.values()) {
                        worldPoints.removePoint(pt);
                    }
                    addon.mapDecorations.remove(remove);
                }
            });
        }
    }

    @Nonnull
    private Set<MapData> getMapData(PlayerEntity player, PointsOfInterest.WorldPoints worldPoints, VanillaMapData addon) {
        if (!((Boolean)ConfigData.COMMON.enableVanillaMapIntegration.get()).booleanValue()) {
            return Collections.emptySet();
        }
        HashSet seenMaps = Sets.newHashSet();
        for (int slot = 0; slot < player.field_71071_by.func_70302_i_(); ++slot) {
            ItemStack stack = player.field_71071_by.func_70301_a(slot);
            MapData mapData = FilledMapItem.func_195950_a((ItemStack)stack, (World)player.field_70170_p);
            if (mapData == null || seenMaps.contains(mapData) || mapData.field_76200_c != worldPoints.getWorldKey()) continue;
            seenMaps.add(mapData);
            Map decorationPointInfoMap = addon.mapDecorations.computeIfAbsent(mapData, k -> Maps.newHashMap());
            for (MapBanner mapBanner : mapData.field_204270_k.values()) {
                MapDecoration decoration = (MapDecoration)mapData.field_76203_h.get(mapBanner.func_204299_f());
                if (decorationPointInfoMap.containsKey(decoration)) continue;
                MapBannerWaypoint wp = new MapBannerWaypoint(mapBanner, decoration);
                decorationPointInfoMap.put(decoration, wp);
                worldPoints.addPoint(wp);
            }
            for (Map.Entry entry : mapData.field_76203_h.entrySet()) {
                String decorationId = (String)entry.getKey();
                MapDecoration decoration = (MapDecoration)entry.getValue();
                if (decoration.func_191179_b() == MapDecoration.Type.PLAYER || decoration.func_191179_b() == MapDecoration.Type.PLAYER_OFF_LIMITS || decoration.func_191179_b() == MapDecoration.Type.PLAYER_OFF_MAP || decorationPointInfoMap.containsKey(decoration)) continue;
                MapDecorationWaypoint wp = new MapDecorationWaypoint(mapData, decoration);
                decorationPointInfoMap.put(decoration, wp);
                worldPoints.addPoint(wp);
            }
            HashSet toRemove = new HashSet(decorationPointInfoMap.keySet());
            toRemove.removeAll(mapData.field_76203_h.values());
            for (MapDecoration remove : toRemove) {
                worldPoints.removePoint((PointInfo)decorationPointInfoMap.get(remove));
                decorationPointInfoMap.remove(remove);
            }
        }
        return seenMaps;
    }

    private class VanillaMapData {
        public Map<MapData, Map<MapDecoration, PointInfo<?>>> mapDecorations = Maps.newHashMap();

        private VanillaMapData() {
        }
    }

    public static class MapBannerWaypoint
    extends PointInfo<MapBannerWaypoint> {
        private final MapBanner banner;
        private Vector3d position;

        public MapBannerWaypoint(MapBanner banner, MapDecoration decoration) {
            super((PointInfoType)BANNER_TYPE.get(), true, banner.func_204302_d(), BasicIconData.mapMarker(decoration.func_176110_a()));
            this.dynamic();
            this.banner = banner;
            this.position = Vector3d.func_237489_a_((Vector3i)banner.func_204304_a());
        }

        public MapBannerWaypoint() {
            super((PointInfoType)BANNER_TYPE.get(), true);
            this.banner = null;
        }

        @Nullable
        public MapBanner getBanner() {
            return this.banner;
        }

        @Override
        public Vector3d getPosition() {
            return this.position;
        }

        @Override
        protected void serializeAdditional(CompoundNBT tag) {
            tag.func_74780_a("X", this.position.field_72450_a);
            tag.func_74780_a("Y", this.position.field_72448_b);
            tag.func_74780_a("Z", this.position.field_72449_c);
        }

        @Override
        protected void deserializeAdditional(CompoundNBT tag) {
            this.position = new Vector3d(tag.func_74769_h("X"), tag.func_74769_h("Y"), tag.func_74769_h("Z"));
        }

        @Override
        protected void serializeAdditional(PacketBuffer buffer) {
            buffer.writeDouble(this.position.field_72450_a);
            buffer.writeDouble(this.position.field_72448_b);
            buffer.writeDouble(this.position.field_72449_c);
        }

        @Override
        protected void deserializeAdditional(PacketBuffer buffer) {
            this.position = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    public static class MapDecorationWaypoint
    extends PointInfo<MapDecorationWaypoint> {
        private final MapDecoration decoration;
        private Vector3d position;

        public MapDecorationWaypoint(MapData mapData, MapDecoration decoration) {
            super((PointInfoType)DECORATION_TYPE.get(), true, null, BasicIconData.mapMarker(decoration.func_176110_a()));
            this.dynamic();
            this.noVerticalDistance();
            float decoX = ((float)decoration.func_176112_b() - 0.5f) * 0.5f;
            float decoZ = ((float)decoration.func_176113_c() - 0.5f) * 0.5f;
            int scale = 1 << mapData.field_76197_d;
            float worldX = (float)mapData.field_76201_a + decoX * (float)scale;
            float worldZ = (float)mapData.field_76199_b + decoZ * (float)scale;
            this.decoration = decoration;
            this.position = new Vector3d((double)worldX, 0.0, (double)worldZ);
        }

        public MapDecorationWaypoint() {
            super((PointInfoType)DECORATION_TYPE.get(), true);
            this.decoration = null;
        }

        @Nullable
        public MapDecoration getDecoration() {
            return this.decoration;
        }

        @Override
        public Vector3d getPosition() {
            return this.position;
        }

        @Override
        protected void serializeAdditional(CompoundNBT tag) {
            tag.func_74780_a("X", this.position.field_72450_a);
            tag.func_74780_a("Y", this.position.field_72448_b);
            tag.func_74780_a("Z", this.position.field_72449_c);
        }

        @Override
        protected void deserializeAdditional(CompoundNBT tag) {
            this.position = new Vector3d(tag.func_74769_h("X"), tag.func_74769_h("Y"), tag.func_74769_h("Z"));
        }

        @Override
        protected void serializeAdditional(PacketBuffer buffer) {
            buffer.writeDouble(this.position.field_72450_a);
            buffer.writeDouble(this.position.field_72448_b);
            buffer.writeDouble(this.position.field_72449_c);
        }

        @Override
        protected void deserializeAdditional(PacketBuffer buffer) {
            this.position = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }
}

