/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.network;

import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddWaypoint {
    public final String label;
    public final double x;
    public final double y;
    public final double z;
    public final boolean isMarker;
    public final int iconIndex;

    public AddWaypoint(String label, double x, double y, double z, boolean isMarker, int iconIndex) {
        this.label = label;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isMarker = isMarker;
        this.iconIndex = iconIndex;
    }

    public AddWaypoint(BasicWaypoint point) {
        this.label = point.getLabelText();
        this.x = point.getPosition().field_72450_a;
        this.y = point.getPosition().field_72448_b;
        this.z = point.getPosition().field_72449_c;
        BasicIconData data = (BasicIconData)point.getIconData();
        this.isMarker = data.getSerializer() == BasicIconData.Serializer.MAP_SERIALIZER;
        this.iconIndex = data.iconIndex;
    }

    public AddWaypoint(PacketBuffer buffer) {
        this.label = buffer.func_150789_c(256);
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.z = buffer.readDouble();
        this.isMarker = buffer.readBoolean();
        this.iconIndex = buffer.func_150792_a();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.label);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.writeDouble(this.z);
        buffer.writeBoolean(this.isMarker);
        buffer.func_150787_b(this.iconIndex);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> PointsOfInterest.handleAddWaypoint(context.getSender(), this));
        return true;
    }
}

