/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.client.ClientHandler;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoRegistry;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncWaypointData {
    public final boolean replaceAll;
    public final ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAddedOrUpdated;
    public final ImmutableList<UUID> pointsRemoved;

    public SyncWaypointData(boolean replaceAll, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> addedOrUpdated, ImmutableList<UUID> removed) {
        this.replaceAll = replaceAll;
        this.pointsAddedOrUpdated = addedOrUpdated;
        this.pointsRemoved = removed;
    }

    public SyncWaypointData(PacketBuffer buffer) {
        ImmutableList.Builder toAdd = ImmutableList.builder();
        ImmutableList.Builder toRemove = ImmutableList.builder();
        this.replaceAll = buffer.readBoolean();
        int numberToAdd = buffer.func_150792_a();
        for (int i = 0; i < numberToAdd; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            PointInfo<?> pt = PointInfoRegistry.deserializePoint(buffer);
            toAdd.add((Object)Pair.of((Object)id, pt));
        }
        int numberToRemove = buffer.func_150792_a();
        for (int i = 0; i < numberToRemove; ++i) {
            toRemove.add((Object)buffer.func_179253_g());
        }
        this.pointsAddedOrUpdated = toAdd.build();
        this.pointsRemoved = toRemove.build();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.replaceAll);
        buffer.func_150787_b(this.pointsAddedOrUpdated.size());
        this.pointsAddedOrUpdated.forEach(pt -> {
            buffer.func_192572_a((ResourceLocation)pt.getFirst());
            PointInfoRegistry.serializePoint((PointInfo)pt.getSecond(), buffer);
        });
        buffer.func_150787_b(this.pointsRemoved.size());
        this.pointsRemoved.forEach(arg_0 -> ((PacketBuffer)buffer).func_179252_a(arg_0));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientHandler.handleWaypointSync(this));
        return true;
    }
}

