/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.network;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoRegistry;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateWaypointsFromGui {
    public final ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded;
    public final ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated;
    public final ImmutableList<UUID> pointsRemoved;

    public UpdateWaypointsFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> added, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> updated, ImmutableList<UUID> removed) {
        this.pointsAdded = added;
        this.pointsUpdated = updated;
        this.pointsRemoved = removed;
    }

    public UpdateWaypointsFromGui(PacketBuffer buffer) {
        ImmutableList.Builder toAdd = ImmutableList.builder();
        ImmutableList.Builder toUpdate = ImmutableList.builder();
        ImmutableList.Builder toRemove = ImmutableList.builder();
        int numberToAdd = buffer.func_150792_a();
        for (int i = 0; i < numberToAdd; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            PointInfo<?> pt = PointInfoRegistry.deserializePointWithoutId(buffer);
            toAdd.add((Object)Pair.of((Object)id, pt));
        }
        int numberToUpdate = buffer.func_150792_a();
        for (int i = 0; i < numberToUpdate; ++i) {
            ResourceLocation id = buffer.func_192575_l();
            PointInfo<?> pt = PointInfoRegistry.deserializePoint(buffer);
            toUpdate.add((Object)Pair.of((Object)id, pt));
        }
        int numberToRemove = buffer.func_150792_a();
        for (int i = 0; i < numberToRemove; ++i) {
            toRemove.add((Object)buffer.func_179253_g());
        }
        this.pointsAdded = toAdd.build();
        this.pointsUpdated = toUpdate.build();
        this.pointsRemoved = toRemove.build();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.pointsAdded.size());
        this.pointsAdded.forEach(pt -> {
            buffer.func_192572_a((ResourceLocation)pt.getFirst());
            PointInfoRegistry.serializePointWithoutId((PointInfo)pt.getSecond(), buffer);
        });
        buffer.func_150787_b(this.pointsUpdated.size());
        this.pointsUpdated.forEach(pt -> {
            buffer.func_192572_a((ResourceLocation)pt.getFirst());
            PointInfoRegistry.serializePoint((PointInfo)pt.getSecond(), buffer);
        });
        buffer.func_150787_b(this.pointsRemoved.size());
        this.pointsRemoved.forEach(arg_0 -> ((PacketBuffer)buffer).func_179252_a(arg_0));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> PointsOfInterest.handleUpdateFromGui(context.getSender(), this));
        return true;
    }
}

