/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.icons.IIconData;
import dev.gigaherz.hudcompass.icons.IconDataRegistry;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import dev.gigaherz.hudcompass.waypoints.PointsOfInterest;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;

public abstract class PointInfo<T extends PointInfo<T>> {
    private final PointInfoType<? extends T> type;
    private PointsOfInterest.WorldPoints owner;
    private UUID internalId;
    private ITextComponent label;
    private IIconData<?> iconData;
    private boolean displayVerticalDistance = true;
    private boolean isServerProvided = true;
    private boolean isDynamic;
    public float fade;

    public static Vector3d toVec3d(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public PointInfo(PointInfoType<? extends T> type, boolean isDynamic) {
        this.isDynamic = isDynamic;
        this.type = type;
        this.internalId = UUID.randomUUID();
    }

    public PointInfo(PointInfoType<? extends T> type, boolean isDynamic, @Nullable ITextComponent label, IIconData<?> iconData) {
        this(type, isDynamic);
        this.label = label;
        this.iconData = iconData;
    }

    public PointInfoType<? extends T> getType() {
        return this.type;
    }

    public final PointsOfInterest.WorldPoints getOwner() {
        return this.owner;
    }

    public UUID getInternalId() {
        return this.internalId;
    }

    public void setInternalId(UUID uuid) {
        this.internalId = uuid;
    }

    public abstract Vector3d getPosition();

    @Nullable
    public ITextComponent getLabel() {
        return this.label;
    }

    public void setLabel(@Nullable ITextComponent text) {
        this.label = text;
    }

    public IIconData<?> getIconData() {
        return this.iconData;
    }

    public T dynamic() {
        this.isDynamic = true;
        return (T)this;
    }

    public final T noVerticalDistance() {
        this.displayVerticalDistance = false;
        return (T)this;
    }

    public boolean displayVerticalDistance(PlayerEntity player) {
        return this.displayVerticalDistance;
    }

    public void makeClientPoint() {
        this.isServerProvided = false;
    }

    public boolean isServerManaged() {
        return this.isServerProvided;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void tick(PlayerEntity player) {
    }

    void setOwner(PointsOfInterest.WorldPoints owner) {
        this.owner = owner;
    }

    public void markDirty() {
        if (this.owner != null) {
            this.owner.markDirty(this);
        }
    }

    public final CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("ID", this.internalId.toString());
        if (this.label != null) {
            tag.func_74778_a("Label", ITextComponent.Serializer.func_150696_a((ITextComponent)this.label));
        }
        tag.func_218657_a("Icon", (INBT)IconDataRegistry.serializeIcon(this.iconData));
        tag.func_74757_a("DisplayVerticalDistance", this.displayVerticalDistance);
        this.serializeAdditional(tag);
        return tag;
    }

    public final void read(CompoundNBT tag) {
        this.internalId = UUID.fromString(tag.func_74779_i("ID"));
        this.label = tag.func_150297_b("Label", 8) ? ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("Label")) : null;
        this.iconData = IconDataRegistry.deserializeIcon(tag.func_74775_l("Icon"));
        this.displayVerticalDistance = tag.func_74767_n("DisplayVerticalDistance");
        this.deserializeAdditional(tag);
    }

    public final void writeToPacket(PacketBuffer buffer) {
        buffer.func_179252_a(this.internalId);
        this.writeToPacketWithoutId(buffer);
    }

    public final void writeToPacketWithoutId(PacketBuffer buffer) {
        boolean hasLabel = this.label != null;
        buffer.writeBoolean(hasLabel);
        if (hasLabel) {
            buffer.func_179256_a(this.label);
        }
        IconDataRegistry.serializeIcon(this.iconData, buffer);
        buffer.writeBoolean(this.displayVerticalDistance);
        buffer.writeBoolean(this.isDynamic);
        this.serializeAdditional(buffer);
    }

    public final void readFromPacket(PacketBuffer buffer) {
        this.internalId = buffer.func_179253_g();
        this.readFromPacketWithoutId(buffer);
    }

    public final void readFromPacketWithoutId(PacketBuffer buffer) {
        boolean hasLabel = buffer.readBoolean();
        this.label = hasLabel ? buffer.func_179258_d() : null;
        this.iconData = IconDataRegistry.deserializeIcon(buffer);
        this.displayVerticalDistance = buffer.readBoolean();
        this.isDynamic = buffer.readBoolean();
        this.deserializeAdditional(buffer);
    }

    protected abstract void serializeAdditional(CompoundNBT var1);

    protected abstract void deserializeAdditional(CompoundNBT var1);

    protected abstract void serializeAdditional(PacketBuffer var1);

    protected abstract void deserializeAdditional(PacketBuffer var1);
}

