/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoType;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class PointInfoRegistry {
    public static IForgeRegistry<PointInfoType<?>> REGISTRY = RegistryManager.ACTIVE.getRegistry(PointInfoType.class);

    @Nonnull
    public static CompoundNBT serializePoint(@Nonnull PointInfo<?> iconData) {
        PointInfoType<?> type = iconData.getType();
        ResourceLocation typeId = type.getRegistryName();
        if (typeId == null) {
            throw new IllegalStateException(String.format("Serializer name is null %s", ((Object)type).getClass().getName()));
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Type", type.getRegistryName().toString());
        tag = iconData.write(tag);
        return tag;
    }

    @Nonnull
    public static PointInfo<?> deserializePoint(CompoundNBT tag) {
        ResourceLocation typeId = new ResourceLocation(tag.func_74779_i("Type"));
        PointInfoType type = (PointInfoType)REGISTRY.getValue(typeId);
        if (type == null) {
            throw new IllegalStateException(String.format("Serializer not registered %s", typeId));
        }
        Object info = type.create();
        ((PointInfo)info).read(tag);
        return info;
    }

    public static void serializePoint(PointInfo<?> iconData, PacketBuffer buffer) {
        PointInfoType<?> type = iconData.getType();
        buffer.writeRegistryIdUnsafe(REGISTRY, type);
        iconData.writeToPacket(buffer);
    }

    public static void serializePointWithoutId(PointInfo<?> iconData, PacketBuffer buffer) {
        PointInfoType<?> type = iconData.getType();
        buffer.writeRegistryIdUnsafe(REGISTRY, type);
        iconData.writeToPacketWithoutId(buffer);
    }

    @Nonnull
    public static PointInfo<?> deserializePoint(PacketBuffer buffer) {
        PointInfoType serializer = (PointInfoType)buffer.readRegistryIdUnsafe(REGISTRY);
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PointInfo)info).readFromPacket(buffer);
        return info;
    }

    @Nonnull
    public static PointInfo<?> deserializePointWithoutId(PacketBuffer buffer) {
        PointInfoType serializer = (PointInfoType)buffer.readRegistryIdUnsafe(REGISTRY);
        if (serializer == null) {
            throw new IllegalStateException("Server returned unknown serializer");
        }
        Object info = serializer.create();
        ((PointInfo)info).readFromPacketWithoutId(buffer);
        return info;
    }
}

