/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.hudcompass.waypoints;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.hudcompass.ConfigData;
import dev.gigaherz.hudcompass.HudCompass;
import dev.gigaherz.hudcompass.icons.BasicIconData;
import dev.gigaherz.hudcompass.network.AddWaypoint;
import dev.gigaherz.hudcompass.network.RemoveWaypoint;
import dev.gigaherz.hudcompass.network.SyncWaypointData;
import dev.gigaherz.hudcompass.network.UpdateWaypointsFromGui;
import dev.gigaherz.hudcompass.waypoints.BasicWaypoint;
import dev.gigaherz.hudcompass.waypoints.PointInfo;
import dev.gigaherz.hudcompass.waypoints.PointInfoRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PointsOfInterest
implements INBTSerializable<ListNBT> {
    @Nonnull
    @CapabilityInject(value=PointsOfInterest.class)
    public static Capability<PointsOfInterest> INSTANCE = null;
    private PointInfo<?> targetted;
    public int changeNumber;
    public int savedNumber;
    private final Map<ResourceLocation, Object> addonData = Maps.newHashMap();
    private List<Runnable> listeners = Lists.newArrayList();
    private static final ResourceLocation PROVIDER_KEY = HudCompass.location("poi_provider");
    private final Set<PointInfo<?>> changed = Sets.newHashSet();
    private final Set<PointInfo<?>> removed = Sets.newHashSet();
    private final Map<RegistryKey<World>, WorldPoints> perWorld = Maps.newHashMap();
    private PlayerEntity player;
    public boolean otherSideHasMod = false;

    public <T> T getOrCreateAddonData(ResourceLocation addonId, Supplier<T> factory) {
        return (T)this.addonData.computeIfAbsent(addonId, key -> factory.get());
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(PointsOfInterest.class, (Capability.IStorage)new Capability.IStorage<PointsOfInterest>(){

            @Nullable
            public INBT writeNBT(Capability capability, PointsOfInterest instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability capability, PointsOfInterest instance, Direction side, INBT nbt) {
                if (!(nbt instanceof ListNBT)) {
                    HudCompass.LOGGER.error("Deserializing PointsOfInterest capability: stored nbt is not a List tag!");
                    return;
                }
                instance.deserializeNBT((ListNBT)nbt);
            }
        }, PointsOfInterest::new);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, PointsOfInterest::attachEvent);
        MinecraftForge.EVENT_BUS.addListener(PointsOfInterest::playerClone);
    }

    private static void attachEvent(AttachCapabilitiesEvent<Entity> event) {
        final Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(PROVIDER_KEY, (ICapabilityProvider)new ICapabilitySerializable<ListNBT>(){
                private final PointsOfInterest poi = new PointsOfInterest();
                private final LazyOptional<PointsOfInterest> poiSupplier = LazyOptional.of(() -> this.poi);
                {
                    this.poi.setPlayer((PlayerEntity)entity);
                }

                public ListNBT serializeNBT() {
                    return this.poi.serializeNBT();
                }

                public void deserializeNBT(ListNBT nbt) {
                    this.poi.deserializeNBT(nbt);
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    if (cap == INSTANCE) {
                        return this.poiSupplier.cast();
                    }
                    return LazyOptional.empty();
                }
            });
        }
    }

    private static void playerClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        oldPlayer.revive();
        PlayerEntity newPlayer = event.getPlayer();
        newPlayer.getCapability(INSTANCE).ifPresent(newPois -> oldPlayer.getCapability(INSTANCE).ifPresent(oldPois -> newPois.transferFrom((PointsOfInterest)oldPois)));
    }

    private void transferFrom(PointsOfInterest oldPois) {
        for (WorldPoints w : oldPois.getAllWorlds()) {
            this.get((RegistryKey<World>)w.worldKey).transferFrom(w);
        }
    }

    public static void onTick(PlayerEntity player) {
        player.getCapability(INSTANCE).ifPresent(PointsOfInterest::tick);
    }

    public Collection<WorldPoints> getAllWorlds() {
        return Collections.unmodifiableCollection(this.perWorld.values());
    }

    public ListNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (Map.Entry<RegistryKey<World>, WorldPoints> entry : this.perWorld.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("World", entry.getKey().func_240901_a_().toString());
            tag.func_218657_a("POIs", (INBT)entry.getValue().serializeNBT());
            list.add((Object)tag);
        }
        return list;
    }

    public void deserializeNBT(ListNBT nbt) {
        this.perWorld.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundNBT tag = nbt.func_150305_b(i);
            RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("World")));
            WorldPoints p = this.get((RegistryKey<World>)key);
            p.deserializeNBT(tag.func_150295_c("POIs", 10));
        }
        this.changeNumber = 0;
        this.savedNumber = 0;
    }

    public void clear() {
        this.perWorld.values().forEach(WorldPoints::clear);
        this.perWorld.clear();
    }

    public void setTargetted(PointInfo<?> targetted) {
        this.targetted = targetted;
    }

    public PointInfo<?> getTargetted() {
        return this.targetted;
    }

    public void setPlayer(PlayerEntity player) {
        this.player = player;
    }

    public void tick() {
        this.perWorld.values().forEach(rec$ -> ((WorldPoints)rec$).tick());
    }

    private void sendInitialSync() {
        this.sendSync();
    }

    private void sendSync() {
        if (((Boolean)ConfigData.COMMON.disableServerHello.get()).booleanValue()) {
            return;
        }
        if (this.otherSideHasMod) {
            ImmutableList points = (ImmutableList)this.perWorld.entrySet().stream().flatMap(kv -> ((WorldPoints)kv.getValue()).points.values().stream().map(v -> Pair.of((Object)((RegistryKey)kv.getKey()).func_240901_a_(), (Object)v))).collect(ImmutableList.toImmutableList());
            HudCompass.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new SyncWaypointData(true, points, (ImmutableList<UUID>)ImmutableList.of()));
        }
    }

    private void sendUpdateFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toAdd, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toUpdate, ImmutableList<UUID> toRemove) {
        HudCompass.channel.sendToServer((Object)new UpdateWaypointsFromGui(toAdd, toUpdate, toRemove));
    }

    public static void handleAddWaypoint(ServerPlayerEntity sender, AddWaypoint addWaypoint) {
        sender.getCapability(INSTANCE).ifPresent(points -> {
            BasicWaypoint waypoint = new BasicWaypoint(new Vector3d(addWaypoint.x, addWaypoint.y, addWaypoint.z), addWaypoint.label, addWaypoint.isMarker ? BasicIconData.mapMarker(addWaypoint.iconIndex) : BasicIconData.poi(addWaypoint.iconIndex));
            points.get(sender.field_70170_p).addPoint(waypoint);
        });
    }

    public void updateFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toAdd, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> toUpdate, ImmutableList<UUID> toRemove) {
        if (this.player.field_70170_p.field_72995_K && this.otherSideHasMod) {
            this.sendUpdateFromGui(toAdd, toUpdate, toRemove);
        } else {
            this.applyUpdatesFromGui(toAdd, toUpdate, toRemove);
        }
    }

    public WorldPoints get(World world) {
        return this.get((RegistryKey<World>)world.func_234923_W_(), PointsOfInterest.getDimensionTypeKey(world));
    }

    public WorldPoints get(RegistryKey<World> worldKey) {
        MinecraftServer server = this.player.field_70170_p.func_73046_m();
        if (server == null) {
            return this.get(worldKey, null);
        }
        ServerWorld world = server.func_71218_a(worldKey);
        if (world == null) {
            return this.get(worldKey, null);
        }
        return this.get((World)world);
    }

    private static RegistryKey<DimensionType> getDimensionTypeKey(World world) {
        DimensionType dimType = world.func_230315_m_();
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)world.func_241828_r().func_230520_a_().func_177774_c((Object)dimType));
    }

    public WorldPoints get(RegistryKey<World> worldKey, @Nullable RegistryKey<DimensionType> dimensionTypeKey) {
        return this.perWorld.computeIfAbsent(Objects.requireNonNull(worldKey), worldKey1 -> new WorldPoints((RegistryKey<World>)worldKey1, dimensionTypeKey));
    }

    public static void handleRemoveWaypoint(ServerPlayerEntity sender, RemoveWaypoint removeWaypoint) {
        sender.getCapability(INSTANCE).ifPresent(points -> points.find(removeWaypoint.id).ifPresent(pt -> {
            if (!pt.isDynamic()) {
                pt.getOwner().removePoint(removeWaypoint.id);
            }
        }));
    }

    private Optional<PointInfo<?>> find(UUID id) {
        return this.perWorld.values().stream().flatMap(world -> world.find(id).map(Stream::of).orElseGet(Stream::empty)).findAny();
    }

    private void remove(UUID pt) {
        this.getAllWorlds().forEach(w -> w.removePoint(pt));
    }

    public static void handleSync(PlayerEntity player, SyncWaypointData packet) {
        player.getCapability(INSTANCE).ifPresent(points -> {
            if (packet.replaceAll) {
                points.perWorld.values().forEach(pt -> ((WorldPoints)pt).points.values().removeIf(PointInfo::isServerManaged));
            } else {
                points.perWorld.values().forEach(pt -> ((WorldPoints)pt).points.keySet().removeAll((Collection<?>)packet.pointsRemoved));
            }
            for (Pair pt2 : packet.pointsAddedOrUpdated) {
                points.get((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)pt2.getFirst()))).addPoint((PointInfo)pt2.getSecond());
            }
            points.listeners.forEach(Runnable::run);
        });
    }

    public static void handleUpdateFromGui(ServerPlayerEntity sender, UpdateWaypointsFromGui packet) {
        sender.getCapability(INSTANCE).ifPresent(points -> {
            ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded = packet.pointsAdded;
            ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated = packet.pointsUpdated;
            ImmutableList<UUID> pointsRemoved = packet.pointsRemoved;
            points.applyUpdatesFromGui(pointsAdded, pointsUpdated, pointsRemoved);
        });
    }

    private void applyUpdatesFromGui(ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsAdded, ImmutableList<Pair<ResourceLocation, PointInfo<?>>> pointsUpdated, ImmutableList<UUID> pointsRemoved) {
        for (UUID pt : pointsRemoved) {
            this.remove(pt);
        }
        for (UUID pt : pointsAdded) {
            this.get((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)pt.getFirst()))).addPoint((PointInfo)pt.getSecond());
        }
        for (UUID pt : pointsUpdated) {
            this.get((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)((ResourceLocation)pt.getFirst()))).addPoint((PointInfo)pt.getSecond());
        }
    }

    public static void remoteHello(@Nullable PlayerEntity player) {
        if (player == null) {
            return;
        }
        player.getCapability(INSTANCE).ifPresent(points -> {
            points.otherSideHasMod = true;
            if (!player.field_70170_p.field_72995_K) {
                points.sendInitialSync();
            }
        });
    }

    public void addListener(Runnable onSyncReceived) {
        this.listeners.add(onSyncReceived);
    }

    public void removeListener(Runnable onSyncReceived) {
        this.listeners.remove(onSyncReceived);
    }

    public class WorldPoints {
        private final RegistryKey<World> worldKey;
        @Nullable
        private final RegistryKey<DimensionType> dimensionTypeKey;
        private Map<UUID, PointInfo<?>> points = Maps.newHashMap();

        public WorldPoints(@Nullable RegistryKey<World> worldKey, RegistryKey<DimensionType> dimensionTypeKey) {
            this.worldKey = worldKey;
            this.dimensionTypeKey = dimensionTypeKey;
        }

        public Collection<PointInfo<?>> getPoints() {
            return this.points.values();
        }

        private void tick() {
            for (PointInfo<?> point : this.points.values()) {
                point.tick(PointsOfInterest.this.player);
            }
            if (((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K && ((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.func_234923_W_() == this.worldKey) {
                PointInfo<?> closest = null;
                double closestAngle = Double.POSITIVE_INFINITY;
                for (PointInfo<?> point : this.points.values()) {
                    double m2;
                    Vector3d direction = point.getPosition().func_178788_d(PointsOfInterest.this.player.func_213303_ch());
                    Vector3d look = PointsOfInterest.this.player.func_70040_Z();
                    direction = direction.func_72432_b();
                    look = look.func_72432_b();
                    double dot = direction.field_72450_a * look.field_72450_a + direction.field_72449_c * look.field_72449_c;
                    double m1 = Math.sqrt(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c);
                    double angle = Math.abs(Math.acos(dot / (m1 * (m2 = Math.sqrt(look.field_72450_a * look.field_72450_a + look.field_72449_c * look.field_72449_c)))));
                    if (!(angle < closestAngle)) continue;
                    closest = point;
                    closestAngle = angle;
                }
                if (closest != null && closestAngle < Math.toRadians(15.0)) {
                    PointsOfInterest.this.setTargetted(closest);
                } else {
                    PointsOfInterest.this.setTargetted(null);
                }
            }
            if (!(((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K || PointsOfInterest.this.changed.size() <= 0 && PointsOfInterest.this.removed.size() <= 0)) {
                PointsOfInterest.this.sendSync();
                PointsOfInterest.this.changed.clear();
                PointsOfInterest.this.removed.clear();
            }
        }

        public void addPointRequest(PointInfo<?> point) {
            if (PointsOfInterest.this.otherSideHasMod && ((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K && point instanceof BasicWaypoint) {
                HudCompass.channel.sendToServer((Object)new AddWaypoint((BasicWaypoint)point));
            } else {
                this.addPoint(point);
            }
        }

        public void addPoint(PointInfo<?> point) {
            point.setOwner(this);
            PointInfo<?> oldPoint = this.points.put(point.getInternalId(), point);
            if (oldPoint != null) {
                oldPoint.setOwner(null);
            }
            if (!((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K && PointsOfInterest.this.otherSideHasMod) {
                PointsOfInterest.this.changed.add(point);
            }
            if (!point.isDynamic()) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public void removePointRequest(PointInfo<?> point) {
            UUID id = point.getInternalId();
            if (PointsOfInterest.this.otherSideHasMod && ((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K) {
                HudCompass.channel.sendToServer((Object)new RemoveWaypoint(id));
            } else {
                this.removePoint(id);
            }
        }

        public void removePoint(PointInfo<?> point) {
            this.removePoint(point.getInternalId());
        }

        public void removePoint(UUID id) {
            PointInfo<?> point = this.points.get(id);
            if (point != null) {
                point.setOwner(null);
                this.points.remove(point.getInternalId());
                if (!((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K && PointsOfInterest.this.otherSideHasMod) {
                    PointsOfInterest.this.removed.add(point);
                }
                if (!point.isDynamic()) {
                    ++PointsOfInterest.this.changeNumber;
                }
            }
        }

        public void clear() {
            boolean nonDynamic = this.points.values().stream().anyMatch(point -> !point.isDynamic());
            PointsOfInterest.this.removed.addAll(this.points.values());
            this.points.clear();
            if (nonDynamic) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public void markDirty(PointInfo<?> point) {
            if (!((PointsOfInterest)PointsOfInterest.this).player.field_70170_p.field_72995_K && PointsOfInterest.this.otherSideHasMod) {
                PointsOfInterest.this.changed.add(point);
            }
            if (!point.isDynamic()) {
                ++PointsOfInterest.this.changeNumber;
            }
        }

        public ListNBT serializeNBT() {
            ListNBT tag = new ListNBT();
            for (PointInfo<?> point : this.points.values()) {
                if (point.isDynamic()) continue;
                tag.add((Object)PointInfoRegistry.serializePoint(point));
            }
            return tag;
        }

        public void deserializeNBT(ListNBT nbt) {
            this.points.clear();
            for (int i = 0; i < nbt.size(); ++i) {
                CompoundNBT pointTag = nbt.func_150305_b(i);
                PointInfo<?> point = PointInfoRegistry.deserializePoint(pointTag);
                this.points.put(point.getInternalId(), point);
            }
        }

        public RegistryKey<World> getWorldKey() {
            return this.worldKey;
        }

        @Nullable
        public RegistryKey<DimensionType> getDimensionTypeKey() {
            return this.dimensionTypeKey;
        }

        public Optional<PointInfo<?>> find(UUID id) {
            return Optional.ofNullable(this.points.get(id));
        }

        public void transferFrom(WorldPoints w) {
            for (PointInfo<?> p : w.getPoints()) {
                this.addPoint(p);
            }
        }
    }
}

