/*
 * Decompiled with CFR 0.152.
 */
package iizvullokIcemountains.mod.util;

import iizvullokIcemountains.mod.util.MapData;
import iizvullokIcemountains.mod.util.OpenSimplexNoise;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;

public class Heightmap {
    public static ArrayList<MapData> mapData = new ArrayList();
    public static final int WIDTH = 1024;
    public static final int HEIGHT = 1024;
    public static final int COMPUTATION_EDGE = 128;
    public static final int COMPUTATION_WIDTH = 1280;
    public static final int COMPUTATION_HEIGHT = 1280;
    public static final int IMAGE_EDGE = 32;
    public static final int IMAGE_WIDTH = 1088;
    public static final int IMAGE_HEIGHT = 1088;
    public static final double FEATURE_SIZE = 128.0;
    public double[][] heightmap = new double[1280][1280];
    public double[][] eroded = new double[1280][1280];
    public double[][] slope = new double[1280][1280];
    BufferedImage img;

    public static double[][][] loadChunkData(int chunkX, int chunkZ, long seed) {
        double blendNeighbor;
        double blendOwn;
        int j;
        double blendNeighbor2;
        double blendOwn2;
        int i;
        double[][][] neighborChunkData;
        double[][][] ownChunkData;
        int mapX = (int)Math.floor((double)chunkX / 128.0);
        int mapZ = (int)Math.floor((double)chunkZ / 128.0);
        if (chunkX % 128 != 0 && chunkX % 128 != 127 && chunkZ % 128 != 0 && chunkZ % 128 != 127) {
            return Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
        }
        double[][][] chunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
        if (chunkX % 128 == 0) {
            ownChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
            neighborChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX - 1, mapZ);
            for (i = 0; i < 16; ++i) {
                blendOwn2 = 0.5 + (double)(i / 32);
                blendNeighbor2 = 1.0 - blendOwn2;
                for (j = 0; j < 16; ++j) {
                    chunkData[i][j][0] = blendOwn2 * ownChunkData[i][j][0] + blendNeighbor2 * neighborChunkData[i][j][0];
                    chunkData[i][j][1] = blendOwn2 * ownChunkData[i][j][1] + blendNeighbor2 * neighborChunkData[i][j][1];
                    chunkData[i][j][2] = blendOwn2 * ownChunkData[i][j][2] + blendNeighbor2 * neighborChunkData[i][j][2];
                }
            }
        }
        if (chunkX % 128 == 127) {
            ownChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
            neighborChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX + 1, mapZ);
            for (i = 0; i < 16; ++i) {
                blendOwn2 = 1 - i / 32;
                blendNeighbor2 = 1.0 - blendOwn2;
                for (j = 0; j < 16; ++j) {
                    chunkData[i][j][0] = blendOwn2 * ownChunkData[i][j][0] + blendNeighbor2 * neighborChunkData[i][j][0];
                    chunkData[i][j][1] = blendOwn2 * ownChunkData[i][j][1] + blendNeighbor2 * neighborChunkData[i][j][1];
                    chunkData[i][j][2] = blendOwn2 * ownChunkData[i][j][2] + blendNeighbor2 * neighborChunkData[i][j][2];
                }
            }
        }
        if (chunkZ % 128 == 0) {
            ownChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
            neighborChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ - 1);
            for (i = 0; i < 16; ++i) {
                for (int j2 = 0; j2 < 16; ++j2) {
                    blendOwn = 0.5 + (double)(j2 / 32);
                    blendNeighbor = 1.0 - blendOwn;
                    chunkData[i][j2][0] = blendOwn * ownChunkData[i][j2][0] + blendNeighbor * neighborChunkData[i][j2][0];
                    chunkData[i][j2][1] = blendOwn * ownChunkData[i][j2][1] + blendNeighbor * neighborChunkData[i][j2][1];
                    chunkData[i][j2][2] = blendOwn * ownChunkData[i][j2][2] + blendNeighbor * neighborChunkData[i][j2][2];
                }
            }
        }
        if (chunkZ % 128 == 127) {
            ownChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ);
            neighborChunkData = Heightmap.loadRawChunkData(chunkX, chunkZ, seed, mapX, mapZ + 1);
            for (i = 0; i < 16; ++i) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    blendOwn = 1 - j3 / 32;
                    blendNeighbor = 1.0 - blendOwn;
                    chunkData[i][j3][0] = blendOwn * ownChunkData[i][j3][0] + blendNeighbor * neighborChunkData[i][j3][0];
                    chunkData[i][j3][1] = blendOwn * ownChunkData[i][j3][1] + blendNeighbor * neighborChunkData[i][j3][1];
                    chunkData[i][j3][2] = blendOwn * ownChunkData[i][j3][2] + blendNeighbor * neighborChunkData[i][j3][2];
                }
            }
        }
        return chunkData;
    }

    public static double[][][] loadRawChunkData(int chunkX, int chunkZ, long seed, int mapX, int mapZ) {
        double z;
        int j;
        double zstep;
        double xzmax;
        double xzmin;
        int i;
        int i2;
        MapData data = null;
        boolean couldLoad = false;
        for (int i3 = 0; i3 < mapData.size(); ++i3) {
            if (Heightmap.mapData.get((int)i3).posX != mapX || Heightmap.mapData.get((int)i3).posZ != mapZ || Heightmap.mapData.get((int)i3).seed != seed) continue;
            couldLoad = true;
            data = mapData.get(i3);
        }
        if (!couldLoad) {
            String nameTerrain = "terrain_X" + mapX + "Z" + mapZ + ".png";
            String namePopulation = "population_X" + mapX + "Z" + mapZ + ".png";
            String nameBiomeProperties = "biomeProperties_X" + mapX + "Z" + mapZ + ".png";
            String dir = System.getProperty("user.dir") + "\\icemountains\\" + seed;
            String filedirTerrain = dir + "\\" + nameTerrain;
            String filedirPopulation = dir + "\\" + namePopulation;
            String filedirBiomeProperties = dir + "\\" + nameBiomeProperties;
            File fileTerrain = new File(filedirTerrain);
            File filePopulation = new File(filedirPopulation);
            File fileBiomeProperties = new File(filedirBiomeProperties);
            File directory = new File(dir);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (fileTerrain.exists() && filePopulation.exists() && fileBiomeProperties.exists()) {
                BufferedImage imgTerrain = null;
                try {
                    imgTerrain = ImageIO.read(fileTerrain);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BufferedImage imgPopulation = null;
                try {
                    imgPopulation = ImageIO.read(filePopulation);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                BufferedImage imgBiomeProperties = null;
                try {
                    imgBiomeProperties = ImageIO.read(fileBiomeProperties);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (imgTerrain != null && imgPopulation != null && imgBiomeProperties != null) {
                    couldLoad = true;
                    data = new MapData(mapX, mapZ, seed, imgTerrain, imgPopulation, imgBiomeProperties);
                    mapData.add(data);
                }
            }
        }
        if (!couldLoad) {
            Heightmap.generateMapData(mapX, mapZ, seed);
            data = mapData.get(mapData.size() - 1);
        }
        double[][][] chunkData = new double[16][16][9];
        Random rand = new Random(seed * (long)chunkX + (long)chunkZ);
        double[][] uH = new double[18][18];
        for (i2 = -1; i2 < 17; ++i2) {
            for (int j2 = -1; j2 < 17; ++j2) {
                double h;
                int imgX = 32 + 8 * chunkX + i2 / 2 - 1024 * mapX;
                int imgZ = 32 + 8 * chunkZ + j2 / 2 - 1024 * mapZ;
                double xminzmin = new Color(data.terrain.getRGB(imgX, imgZ)).getRed();
                double xmaxzmin = new Color(data.terrain.getRGB(imgX + 1, imgZ)).getRed();
                double xminzmax = new Color(data.terrain.getRGB(imgX, imgZ + 1)).getRed();
                double xmaxzmax = new Color(data.terrain.getRGB(imgX + 1, imgZ + 1)).getRed();
                uH[i2 + 1][j2 + 1] = h = Heightmap.interpolate200(xminzmin, xmaxzmin, xminzmax, xmaxzmax, Math.floorMod(i2, 2), Math.floorMod(j2, 2), rand);
            }
        }
        for (i2 = 0; i2 < 16; ++i2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                double h;
                double height;
                int imgX = 32 + 8 * chunkX + i2 / 2 - 1024 * mapX;
                int imgZ = 32 + 8 * chunkZ + j3 / 2 - 1024 * mapZ;
                chunkData[i2][j3][0] = height = (uH[i2 + 1][j3 + 1] * 2.0 + uH[i2][j3 + 1] + uH[i2 + 2][j3 + 1] + uH[i2 + 1][j3] + uH[i2 + 1][j3 + 2]) / 6.0;
                double xminzmin = new Color(data.terrain.getRGB(imgX, imgZ)).getGreen();
                double xmaxzmin = new Color(data.terrain.getRGB(imgX + 1, imgZ)).getGreen();
                double xminzmax = new Color(data.terrain.getRGB(imgX, imgZ + 1)).getGreen();
                double xmaxzmax = new Color(data.terrain.getRGB(imgX + 1, imgZ + 1)).getGreen();
                chunkData[i2][j3][1] = h = Heightmap.interpolate200(xminzmin, xmaxzmin, xminzmax, xmaxzmax, Math.floorMod(i2, 2), Math.floorMod(j3, 2), rand);
                xminzmin = new Color(data.terrain.getRGB(imgX, imgZ)).getBlue();
                xmaxzmin = new Color(data.terrain.getRGB(imgX + 1, imgZ)).getBlue();
                xminzmax = new Color(data.terrain.getRGB(imgX, imgZ + 1)).getBlue();
                xmaxzmax = new Color(data.terrain.getRGB(imgX + 1, imgZ + 1)).getBlue();
                chunkData[i2][j3][2] = h = Heightmap.interpolate200(xminzmin, xmaxzmin, xminzmax, xmaxzmax, Math.floorMod(i2, 2), Math.floorMod(j3, 2), rand);
            }
        }
        int imgX = Math.floorMod(chunkX, 128);
        int imgZ = Math.floorMod(chunkZ, 128);
        double xminzmin = new Color(data.population.getRGB(imgX, imgZ)).getRed();
        double xmaxzmin = new Color(data.population.getRGB(imgX + 1, imgZ)).getRed();
        double xminzmax = new Color(data.population.getRGB(imgX, imgZ + 1)).getRed();
        double xmaxzmax = new Color(data.population.getRGB(imgX + 1, imgZ + 1)).getRed();
        double xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        double xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][3] = z = xzmin + zstep * (double)j;
            }
        }
        xminzmin = new Color(data.population.getRGB(imgX, imgZ)).getGreen();
        xmaxzmin = new Color(data.population.getRGB(imgX + 1, imgZ)).getGreen();
        xminzmax = new Color(data.population.getRGB(imgX, imgZ + 1)).getGreen();
        xmaxzmax = new Color(data.population.getRGB(imgX + 1, imgZ + 1)).getGreen();
        xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][4] = z = xzmin + zstep * (double)j;
            }
        }
        xminzmin = new Color(data.population.getRGB(imgX, imgZ)).getBlue();
        xmaxzmin = new Color(data.population.getRGB(imgX + 1, imgZ)).getBlue();
        xminzmax = new Color(data.population.getRGB(imgX, imgZ + 1)).getBlue();
        xmaxzmax = new Color(data.population.getRGB(imgX + 1, imgZ + 1)).getBlue();
        xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][5] = z = xzmin + zstep * (double)j;
            }
        }
        xminzmin = new Color(data.biome.getRGB(imgX, imgZ)).getRed();
        xmaxzmin = new Color(data.biome.getRGB(imgX + 1, imgZ)).getRed();
        xminzmax = new Color(data.biome.getRGB(imgX, imgZ + 1)).getRed();
        xmaxzmax = new Color(data.biome.getRGB(imgX + 1, imgZ + 1)).getRed();
        xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][6] = z = xzmin + zstep * (double)j;
            }
        }
        xminzmin = new Color(data.biome.getRGB(imgX, imgZ)).getGreen();
        xmaxzmin = new Color(data.biome.getRGB(imgX + 1, imgZ)).getGreen();
        xminzmax = new Color(data.biome.getRGB(imgX, imgZ + 1)).getGreen();
        xmaxzmax = new Color(data.biome.getRGB(imgX + 1, imgZ + 1)).getGreen();
        xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][7] = z = xzmin + zstep * (double)j;
            }
        }
        xminzmin = new Color(data.biome.getRGB(imgX, imgZ)).getBlue();
        xmaxzmin = new Color(data.biome.getRGB(imgX + 1, imgZ)).getBlue();
        xminzmax = new Color(data.biome.getRGB(imgX, imgZ + 1)).getBlue();
        xmaxzmax = new Color(data.biome.getRGB(imgX + 1, imgZ + 1)).getBlue();
        xstepzmin = (xmaxzmin - xminzmin) / 16.0;
        xstepzmax = (xmaxzmax - xminzmax) / 16.0;
        for (i = 0; i < 16; ++i) {
            xzmin = xminzmin + (double)i * xstepzmin;
            xzmax = xminzmax + (double)i * xstepzmax;
            zstep = (xzmax - xzmin) / 16.0;
            for (j = 0; j < 16; ++j) {
                chunkData[i][j][8] = z = xzmin + zstep * (double)j;
            }
        }
        return chunkData;
    }

    public static double interpolate1600(double xminzmin, double xmaxzmin, double xminzmax, double xmaxzmax, int x, int z) {
        double xweight = Math.floorMod(x, 16);
        double zweight = Math.floorMod(z, 16);
        double xdiffzmin = xmaxzmin - xminzmin;
        double xhpzmin = xdiffzmin * xweight;
        double xhzmin = xhpzmin + xminzmin;
        double xdiffzmax = xmaxzmax - xminzmax;
        double xhpzmax = xdiffzmax * xweight;
        double xhzmax = xhpzmax + xminzmax;
        double zdiff = xhzmax - xhzmin;
        double zhp = zdiff * zweight;
        double zh = zhp + xhzmin;
        return zh;
    }

    public static double interpolate200(double xminzmin, double xmaxzmin, double xminzmax, double xmaxzmax, int x, int z, Random rand) {
        if (x == 0 && z == 0) {
            return xminzmin;
        }
        if (x == 1 && z == 0) {
            return (xminzmin + xmaxzmin) / 2.0;
        }
        if (x == 0 && z == 1) {
            return (xminzmin + xminzmax) / 2.0;
        }
        if (Math.abs(xminzmin - xmaxzmax) == 1.0) {
            // empty if block
        }
        return (xminzmin + xmaxzmax) / 2.0;
    }

    public static void generateMapData(int regX, int regY, long seed) {
        int slopeSmoothness;
        String dir = System.getProperty("user.dir") + "\\icemountains\\" + seed;
        BufferedImage imageBiomeProperties = new BufferedImage(129, 129, 1);
        OpenSimplexNoise noise00 = new OpenSimplexNoise(seed * 5L);
        OpenSimplexNoise noise01 = new OpenSimplexNoise(seed * 6L);
        OpenSimplexNoise noise02 = new OpenSimplexNoise(seed * 7L);
        double[][][] biomeStuff = new double[161][161][3];
        for (int y = 0; y < 161; ++y) {
            for (int x = 0; x < 161; ++x) {
                double noiseSize = 256.0;
                double value0 = noise00.eval((double)(x + regX * 128 - 16) / noiseSize, (double)(y + regY * 128 - 16) / noiseSize);
                for (int i = 0; i < 1; ++i) {
                    value0 += noise00.eval((double)(x + regX * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1)), (double)(y + regY * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                double value1 = noise01.eval((double)(x + regX * 128 - 16) / noiseSize, (double)(y + regY * 128 - 16) / noiseSize);
                for (int i = 0; i < 3; ++i) {
                    value1 += noise01.eval((double)(x + regX * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1)), (double)(y + regY * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                double value2 = noise02.eval((double)(x + regX * 128 - 16) / noiseSize, (double)(y + regY * 128 - 16) / noiseSize);
                for (int i = 0; i < 3; ++i) {
                    value2 += noise02.eval((double)(x + regX * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1)), (double)(y + regY * 128 - 16) / (noiseSize / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                if ((value0 = value0 * 192.0 + 128.0) < 0.0) {
                    value0 = 0.0;
                }
                if (value0 > 255.0) {
                    value0 = 255.0;
                }
                if ((value1 = value1 * 256.0 + 128.0) < 0.0) {
                    value1 = 0.0;
                }
                if (value1 > 255.0) {
                    value1 = 255.0;
                }
                int r = 65536 * (int)value0;
                int g = 256 * (int)value1;
                int b = 1 * (int)((value2 + 2.0) * 64.0) * 0;
                biomeStuff[x][y][0] = value0;
                biomeStuff[x][y][1] = value1;
                biomeStuff[x][y][2] = (value2 + 2.0) * 64.0;
                if (x < 16 || x >= 145 || y < 16 || y >= 145) continue;
                imageBiomeProperties.setRGB(x - 16, y - 16, r + g + b);
            }
        }
        String nameBiomeProperties = "biomeProperties_X" + regX + "Z" + regY + ".png";
        String filedirBiomeProperties = dir + "\\" + nameBiomeProperties;
        File fileBiomeProperties = new File(filedirBiomeProperties);
        try {
            ImageIO.write((RenderedImage)imageBiomeProperties, "png", fileBiomeProperties);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(seed);
        Heightmap map = new Heightmap();
        for (int y = 0; y < 1280; ++y) {
            for (int x = 0; x < 1280; ++x) {
                double factor;
                double min;
                double factorDiff;
                double minDiff;
                double blend;
                double midFactor;
                double midMin;
                double value = noise.eval((double)(x + regX * 1024 - 128) / 128.0, (double)(y + regY * 1024 - 128) / 128.0);
                for (int i = 0; i < 6; ++i) {
                    value += noise.eval((double)(x + regX * 1024 - 128) / (128.0 / Math.pow(2.0, i + 1)), (double)(y + regY * 1024 - 128) / (128.0 / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                double val = (value + 0.68888888889) * Math.min(1.0, Math.max(0.5, noise.eval((x + regX * 1024 - 128) / 64, (y + regY * 1024 - 128) / 64) + 1.0)) * Math.min(1.0, Math.max(0.3, noise.eval((x + regX * 1024 - 128) / 2048, (y + regY * 1024 - 128) / 2048) + 1.0)) - 0.68888888889;
                double d00 = biomeStuff[x / 8][y / 8][0];
                double d01 = biomeStuff[x / 8][y / 8 + 1][0];
                double d10 = biomeStuff[x / 8 + 1][y / 8][0];
                double d11 = biomeStuff[x / 8 + 1][y / 8 + 1][0];
                double d0 = d00 + (d01 - d00) / 8.0 * (double)(y % 8);
                double d1 = d10 + (d11 - d10) / 8.0 * (double)(y % 8);
                double d = d0 + (d1 - d0) / 8.0 * (double)(x % 8);
                double mountainMin = 0.0;
                double mountainFactor = 1.0;
                double oceanMin = -0.8;
                double oceanFactor = 0.2;
                double forestMin = -0.55;
                double forestFactor = 0.35;
                double swampMin = -0.69;
                double swampFactor = 0.02;
                double e00 = biomeStuff[x / 8][y / 8][1];
                double e01 = biomeStuff[x / 8][y / 8 + 1][1];
                double e10 = biomeStuff[x / 8 + 1][y / 8][1];
                double e11 = biomeStuff[x / 8 + 1][y / 8 + 1][1];
                double e0 = e00 + (e01 - e00) / 8.0 * (double)(y % 8);
                double e1 = e10 + (e11 - e10) / 8.0 * (double)(y % 8);
                double e = e0 + (e1 - e0) / 8.0 * (double)(x % 8);
                double swampBlend = Math.min(1.0, Math.max(0.0, (e - 100.0) / 56.0));
                double midBlend = 0.0;
                if (e < 100.0) {
                    midMin = forestMin;
                    midFactor = forestFactor;
                } else if (e >= 100.0 && e < 156.0) {
                    blend = (e - 100.0) / 56.0;
                    minDiff = swampMin - forestMin;
                    midMin = forestMin + blend * minDiff;
                    factorDiff = swampFactor - forestFactor;
                    midFactor = forestFactor + blend * factorDiff;
                } else {
                    midMin = swampMin;
                    midFactor = swampFactor;
                }
                if (d < 80.0) {
                    min = oceanMin;
                    factor = oceanFactor;
                } else if (d >= 80.0 && d < 98.0) {
                    blend = (d - 80.0) / 18.0;
                    minDiff = midMin - oceanMin;
                    min = oceanMin + blend * minDiff;
                    factorDiff = midFactor - oceanFactor;
                    factor = oceanFactor + blend * factorDiff;
                    midBlend = blend;
                } else if (d >= 98.0 && d < 158.0) {
                    min = midMin;
                    factor = midFactor;
                    midBlend = 1.0;
                } else if (d >= 158.0 && d < 176.0) {
                    blend = (d - 158.0) / 18.0;
                    minDiff = mountainMin - midMin;
                    min = midMin + blend * minDiff;
                    factorDiff = mountainFactor - midFactor;
                    factor = midFactor + blend * factorDiff;
                    midBlend = 1.0 - blend;
                } else {
                    min = mountainMin;
                    factor = mountainFactor;
                }
                map.heightmap[x][y] = value = min + value * factor;
            }
        }
        map.simulateErosion();
        Random random = new Random();
        random.setSeed(seed + (long)(regX * regY) + (long)regY);
        for (int y = 0; y < 1280; ++y) {
            for (int x = 0; x < 1280; ++x) {
                double blend;
                double d00 = biomeStuff[x / 8][y / 8][0];
                double d01 = biomeStuff[x / 8][y / 8 + 1][0];
                double d10 = biomeStuff[x / 8 + 1][y / 8][0];
                double d11 = biomeStuff[x / 8 + 1][y / 8 + 1][0];
                double d0 = d00 + (d01 - d00) / 8.0 * (double)(y % 8);
                double d1 = d10 + (d11 - d10) / 8.0 * (double)(y % 8);
                double d = d0 + (d1 - d0) / 8.0 * (double)(x % 8);
                double e00 = biomeStuff[x / 8][y / 8][1];
                double e01 = biomeStuff[x / 8][y / 8 + 1][1];
                double e10 = biomeStuff[x / 8 + 1][y / 8][1];
                double e11 = biomeStuff[x / 8 + 1][y / 8 + 1][1];
                double e0 = e00 + (e01 - e00) / 8.0 * (double)(y % 8);
                double e1 = e10 + (e11 - e10) / 8.0 * (double)(y % 8);
                double e = e0 + (e1 - e0) / 8.0 * (double)(x % 8);
                double swampBlend = Math.min(1.0, Math.max(0.0, (e - 100.0) / 56.0));
                double midBlend = 0.0;
                if (d >= 80.0 && d < 98.0) {
                    midBlend = blend = (d - 80.0) / 18.0;
                } else if (d >= 98.0 && d < 158.0) {
                    midBlend = 1.0;
                } else if (d >= 158.0 && d < 176.0) {
                    blend = (d - 158.0) / 18.0;
                    midBlend = 1.0 - blend;
                }
                double value = noise.eval((x + regX * 1024 - 128) / 3, (y + regY * 1024 - 128) / 1) * 0.01 * swampBlend * midBlend;
                value += noise.eval((x + regX * 1024 - 128) / 1, (y + regY * 1024 - 128) * 3) * 0.005 * swampBlend * midBlend;
                value += noise.eval((x + regX * 1024 - 128) / 1, (y + regY * 1024 - 128) * 6) * 0.004 * swampBlend * midBlend;
                double[] dArray = map.heightmap[x];
                int n = y;
                dArray[n] = dArray[n] + (value -= random.nextDouble() * swampBlend * midBlend * 0.012);
            }
        }
        for (int y = slopeSmoothness = 4; y < 1280 - slopeSmoothness; ++y) {
            for (int x = slopeSmoothness; x < 1280 - slopeSmoothness; ++x) {
                double value = Math.abs(map.heightmap[x + slopeSmoothness][y] - map.heightmap[x - slopeSmoothness][y]) + Math.abs(map.heightmap[x][y + slopeSmoothness] - map.heightmap[x][y - slopeSmoothness]);
                map.slope[x][y] = value / (double)slopeSmoothness;
            }
        }
        BufferedImage imageAfter = new BufferedImage(1088, 1088, 1);
        for (int y = 96; y < 1184; ++y) {
            for (int x = 96; x < 1184; ++x) {
                int r = 65536 * (int)((map.heightmap[x][y] + 1.4) * 90.0);
                int g = 256 * (int)(map.slope[x][y] * 256.0);
                int b = 1 * (int)(map.eroded[x][y] * 128.0);
                imageAfter.setRGB(x - 96, y - 96, r + g + b);
            }
        }
        String nameTerrain = "terrain_X" + regX + "Z" + regY + ".png";
        String filedirTerrain = dir + "\\" + nameTerrain;
        File fileTerrain = new File(filedirTerrain);
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try {
            ImageIO.write((RenderedImage)imageAfter, "png", fileTerrain);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedImage imagePopulation = new BufferedImage(129, 129, 1);
        OpenSimplexNoise noise0 = new OpenSimplexNoise(seed * 2L);
        OpenSimplexNoise noise1 = new OpenSimplexNoise(seed * 3L);
        OpenSimplexNoise noise2 = new OpenSimplexNoise(seed * 4L);
        for (int y = 0; y < 129; ++y) {
            for (int x = 0; x < 129; ++x) {
                double value0 = noise0.eval((double)(x + regX * 128) / 128.0, (double)(y + regY * 128) / 128.0);
                for (int i = 0; i < 3; ++i) {
                    value0 += noise0.eval((double)(x + regX * 128) / (128.0 / Math.pow(2.0, i + 1)), (double)(y + regY * 128) / (128.0 / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                double value1 = noise1.eval((double)(x + regX * 128) / 128.0, (double)(y + regY * 128) / 128.0);
                for (int i = 0; i < 3; ++i) {
                    value1 += noise1.eval((double)(x + regX * 128) / (128.0 / Math.pow(2.0, i + 1)), (double)(y + regY * 128) / (128.0 / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                double value2 = noise2.eval((double)(x + regX * 128) / 128.0, (double)(y + regY * 128) / 128.0);
                for (int i = 0; i < 3; ++i) {
                    value2 += noise2.eval((double)(x + regX * 128) / (128.0 / Math.pow(2.0, i + 1)), (double)(y + regY * 128) / (128.0 / Math.pow(2.0, i + 1))) / Math.pow(2.0, i + 1);
                }
                if ((value0 += noise0.eval((x + regX * 128) / 512, (y + regY * 128) / 512) * 0.5) < 0.0) {
                    value0 = 0.0;
                }
                if (value0 > 3.95) {
                    value0 = 3.95;
                }
                int r = 65536 * (int)((value0 + 2.0) * 64.0);
                int g = 256 * (int)((value1 + 2.0) * 64.0);
                int b = 1 * (int)((value2 + 2.0) * 64.0);
                imagePopulation.setRGB(x, y, r + g + b);
            }
        }
        String namePopulation = "population_X" + regX + "Z" + regY + ".png";
        String filedirPopulation = dir + "\\" + namePopulation;
        File filePopulation = new File(filedirPopulation);
        try {
            ImageIO.write((RenderedImage)imagePopulation, "png", filePopulation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mapData.add(new MapData(regX, regY, seed, imageAfter, imagePopulation, imageBiomeProperties));
    }

    public void simulateErosion() {
        int i;
        for (i = 1; i <= 500000; ++i) {
            this.simulateDrop(Math.random() * 1280.0, Math.random() * 1280.0);
            if (i % 1750 != 0) continue;
            this.thermalErosion();
        }
        this.smoothErosionmap();
        for (i = 1; i <= 16; ++i) {
            this.smooth();
        }
    }

    public double acceleration(double x, double y) {
        double g = 9.81;
        double xslope = this.interpolate((int)(x + 1.0), y) - this.interpolate((int)x, y);
        double yslope = this.interpolate(x, (int)(y + 1.0)) - this.interpolate(x, (int)y);
        double slope = xslope + yslope;
        double Agh = Math.sin(Math.atan(slope)) * g;
        return Agh;
    }

    public void thermalErosion() {
        int j;
        int i;
        double[][] copy = new double[1280][1280];
        for (i = 0; i < 1280; ++i) {
            for (j = 0; j < 1280; ++j) {
                copy[i][j] = this.heightmap[i][j];
            }
        }
        for (i = 2; i < 1278; ++i) {
            for (j = 2; j < 1278; ++j) {
                this.collapse(i, j, copy);
            }
        }
    }

    public void smooth() {
        int j;
        int i;
        double[][] copy = new double[1280][1280];
        for (i = 0; i < 1280; ++i) {
            for (j = 0; j < 1280; ++j) {
                copy[i][j] = this.heightmap[i][j];
            }
        }
        for (i = 2; i < 1278; ++i) {
            for (j = 2; j < 1278; ++j) {
                this.smoothpoint(i, j, copy);
            }
        }
    }

    public void smoothErosionmap() {
        for (int k = 0; k < 24; ++k) {
            int j;
            int i;
            double[][] copy = new double[1280][1280];
            for (i = 0; i < 1280; ++i) {
                for (j = 0; j < 1280; ++j) {
                    copy[i][j] = this.eroded[i][j];
                }
            }
            for (i = 2; i < 1278; ++i) {
                for (j = 2; j < 1278; ++j) {
                    this.smoothpointErosion(i, j, copy);
                }
            }
        }
    }

    public void smoothpointErosion(int posX, int posY, double[][] copy) {
        double smoothfactor = 1.0;
        double v = 0.0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i != 0 || j != 0) {
                    if (i != 0 && j != 0) {
                        v += copy[posX + i][posY + j] * 0.5 * smoothfactor;
                        continue;
                    }
                    v += copy[posX + i][posY + j] * smoothfactor;
                    continue;
                }
                v += copy[posX + i][posY + j] * 2.0;
            }
        }
        double d = 2.0 + 6.0 * smoothfactor;
        this.eroded[posX][posY] = v / d;
    }

    public void smoothpoint(int posX, int posY, double[][] copy) {
        double smoothfactor = Math.max(Math.max(this.eroded[posX][posY] - 0.12, 0.0) * 2.5 - (this.heightmap[posX][posY] + 0.7) * 0.5, 0.0) / 4.0;
        double v = 0.0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i != 0 || j != 0) {
                    if (i != 0 && j != 0) {
                        v += copy[posX + i][posY + j] * 0.5 * smoothfactor;
                        continue;
                    }
                    v += copy[posX + i][posY + j] * smoothfactor;
                    continue;
                }
                v += copy[posX + i][posY + j] * 2.0;
            }
        }
        double d = 2.0 + 6.0 * smoothfactor;
        this.heightmap[posX][posY] = v / d;
    }

    public void collapse(int posX, int posY, double[][] copy) {
        double maxSlopeDown = (copy[posX][posY] + 2.0) * 0.04;
        int maxSlopeX = 0;
        int maxSlopeY = 0;
        double maxSlope = 0.0;
        boolean doSomething = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                double hcenter = copy[posX][posY];
                double h = copy[posX + i][posY + j];
                double slope = hcenter - h;
                if (!(slope > 0.0)) continue;
                if (i != 0 && j != 0) {
                    slope /= Math.sqrt(2.0);
                }
                if (!(slope > maxSlopeDown)) continue;
                doSomething = true;
                if (!(slope > maxSlope)) continue;
                maxSlopeX = i;
                maxSlopeY = j;
                maxSlope = slope;
            }
        }
        if (doSomething) {
            double[] dArray = this.heightmap[posX + maxSlopeX];
            int n = posY + maxSlopeY;
            dArray[n] = dArray[n] + (maxSlope - maxSlopeDown) / 2.0;
            double[] dArray2 = this.heightmap[posX];
            int n2 = posY;
            dArray2[n2] = dArray2[n2] - (maxSlope - maxSlopeDown) / 2.0;
        }
    }

    public void simulateDrop(double startX, double startY) {
        double posX = startX;
        double posY = startY;
        double velX = 0.0;
        double velY = 0.0;
        double accX = 0.0;
        double accY = 0.0;
        double sediments = 0.0;
        int max = (int)(Math.random() * 500.0) + 500;
        max = 500;
        for (int i = 0; i < max; ++i) {
            double g = -9.81;
            if ((int)posX < 0 || (int)posX > 1277 || (int)posY < 0 || (int)posY > 1277) {
                return;
            }
            double xslope = this.interpolate((int)(posX + 1.0), posY) - this.interpolate((int)posX, posY);
            double yslope = this.interpolate(posX, (int)(posY + 1.0)) - this.interpolate(posX, (int)posY);
            accX = Math.asin(Math.atan(xslope)) * g;
            accY = Math.asin(Math.atan(yslope)) * g;
            velX += accX;
            velY += accY;
            double sedimentCapacity = (Math.abs(xslope) + Math.abs(yslope)) * Math.sqrt(velX * velX + velY * velY);
            if (sediments < sedimentCapacity) {
                double suspension = (4.0 - (this.heightmap[(int)posX][(int)posY] + 2.0)) * 0.1;
                double tooLittle = sedimentCapacity - sediments;
                if ((int)(posX + velX) < 0 || (int)(posX + velX) > 1277 || (int)(posY + velY) < 0 || (int)(posY + velY) > 1277) {
                    return;
                }
                double suspend = Math.max(Math.min(tooLittle * suspension, this.heightmap[(int)posX][(int)posY] - this.heightmap[(int)(posX + velX)][(int)(posY + velY)]), 0.0);
                if (suspend > 0.0) {
                    double[] dArray = this.heightmap[(int)posX];
                    int n = (int)posY;
                    dArray[n] = dArray[n] - suspend;
                    double[] dArray2 = this.eroded[(int)posX];
                    int n2 = (int)posY;
                    dArray2[n2] = dArray2[n2] + suspend;
                }
                sediments += suspend;
            } else {
                double disposition = (4.0 - (this.heightmap[(int)posX][(int)posY] + 2.0)) * 0.1;
                double tooMuch = sediments - sedimentCapacity;
                if ((int)(posX - velX) < 0 || (int)(posX - velX) > 1277 || (int)(posY - velY) < 0 || (int)(posY - velY) > 1277) {
                    return;
                }
                double dispose = Math.max(Math.min(tooMuch * disposition, -this.heightmap[(int)posX][(int)posY] + this.heightmap[(int)(posX - velX)][(int)(posY - velY)]), 0.0);
                if (dispose > 0.0) {
                    double[] dArray = this.heightmap[(int)posX];
                    int n = (int)posY;
                    dArray[n] = dArray[n] + dispose;
                    double[] dArray3 = this.eroded[(int)posX];
                    int n3 = (int)posY;
                    dArray3[n3] = dArray3[n3] + dispose;
                }
                sediments -= dispose;
            }
            posX += velX * 0.5;
            posY += velY * 0.5;
            velX *= 0.97;
            velY *= 0.97;
        }
    }

    public double interpolate(double x, double y) {
        if ((int)x < 0 || (int)x >= 1280 || (int)y < 0 || (int)y >= 1280) {
            return 0.0;
        }
        double xminzminh = this.heightmap[(int)x][(int)y];
        double xmaxzminh = this.heightmap[(int)(x + 1.0)][(int)y];
        double xminzmaxh = this.heightmap[(int)x][(int)(y + 1.0)];
        double xmaxzmaxh = this.heightmap[(int)(x + 1.0)][(int)(y + 1.0)];
        double xweight = this.floorMod(x);
        double zweight = this.floorMod(y);
        double xdiffzmin = xmaxzminh - xminzminh;
        double xhpzmin = xdiffzmin * xweight;
        double xhzmin = xhpzmin + xminzminh;
        double xdiffzmax = xmaxzmaxh - xminzmaxh;
        double xhpzmax = xdiffzmax * xweight;
        double xhzmax = xhpzmax + xminzmaxh;
        double zdiff = xhzmax - xhzmin;
        double zhp = zdiff * zweight;
        double zh = zhp + xhzmin;
        return zh;
    }

    public double floorMod(double d) {
        if (d < 0.0) {
            return d - (double)((int)d) + 1.0;
        }
        return d - (double)((int)d);
    }
}

