/*
 * Decompiled with CFR 0.152.
 */
package iizvullokIcemountains.mod.world;

import iizvullokIcemountains.mod.init.BiomeInit;
import iizvullokIcemountains.mod.util.Heightmap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeProviderIceMountains2
extends BiomeProvider {
    private final Biome biome = Biomes.field_76775_o;
    private World world;
    private boolean print = true;
    public static double[][] heightmap;
    public static double[][] fertilitymap;
    public static double[][] temperaturemap;
    public static int chunkX;
    public static int chunkZ;

    public BiomeProviderIceMountains2(World world) {
        this.world = world;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.biome;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        Arrays.fill(biomes, 0, width * height, this.biome);
        return biomes;
    }

    public Biome[] func_76933_b(@Nullable Biome[] oldBiomeList, int x, int z, int width, int depth) {
        if (oldBiomeList == null || oldBiomeList.length < width * depth) {
            oldBiomeList = new Biome[width * depth];
        }
        if (x < 0) {
            --x;
        }
        if (z < 0) {
            --z;
        }
        double[][][] chunkData = Heightmap.loadChunkData(Math.floorDiv(x, 16), Math.floorDiv(z, 16), this.world.func_72905_C());
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = chunkData[i][j][4] > 192.0 ? (chunkData[i][j][3] < 64.0 ? Biomes.field_185431_ac : Biomes.field_150590_f) : (chunkData[i][j][4] > 96.0 ? (chunkData[i][j][3] < 64.0 ? Biomes.field_150584_S : Biomes.field_76768_g) : (chunkData[i][j][4] > 48.0 ? (chunkData[i][j][3] < -64.0 ? Biomes.field_76774_n : Biomes.field_76772_c) : (chunkData[i][j][3] < -64.0 ? Biomes.field_150577_O : Biomes.field_150576_N)));
                if (chunkData[i][j][0] > 128.0) {
                    biome = Biomes.field_76775_o;
                }
                if (chunkData[i][j][0] < 64.0) {
                    biome = chunkData[i][j][3] < 64.0 ? Biomes.field_76776_l : Biomes.field_76771_b;
                }
                oldBiomeList[BiomeProviderIceMountains2.getPosition((int)i, (int)j)] = biome = BiomeInit.ICE_MOUNTAINS;
            }
        }
        return oldBiomeList;
    }

    public static int getPosition(int x, int z) {
        return z * 16 + x;
    }

    public double[][] generateFertilityMap(int x, int z) {
        double[][] fertilitymap = new double[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int ax = x * 16 + i;
                int az = z * 16 + j;
                fertilitymap[i][j] = this.generateOctave(256, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray = fertilitymap[i];
                int n = j;
                dArray[n] = dArray[n] + this.generateOctave(128, 0.5, ax, az, this.world.func_72905_C());
                double[] dArray2 = fertilitymap[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * 1.25;
                double[] dArray3 = fertilitymap[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] - 0.25;
                if (!(fertilitymap[i][j] > 1.0)) continue;
                fertilitymap[i][j] = 1.0;
            }
        }
        return fertilitymap;
    }

    public double[][] generateTemperatureMap(int x, int z) {
        double[][] fertilitymap = new double[16][16];
        for (int i = 0; i < 16; ++i) {
            int j = 0;
            while (j < 16) {
                int ax = x * 16 + i;
                int az = z * 16 + j;
                fertilitymap[i][j] = this.generateOctave(256, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray = fertilitymap[i];
                int n = j;
                dArray[n] = dArray[n] + this.generateOctave(128, 0.5, ax, az, this.world.func_72905_C());
                double[] dArray2 = fertilitymap[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] - 1.0;
            }
        }
        return fertilitymap;
    }

    public double generateOctave(int frequency, double amplitude, int x, int z, long seed) {
        x = Math.abs(x + 34630988);
        z = Math.abs(z + 84534737);
        int xmin = x / frequency;
        int xmax = xmin + 1;
        int zmin = z / frequency;
        int zmax = zmin + 1;
        double xminzminh = Math.sin((long)(xmin * xmin) * seed * (long)zmin * (long)zmin) * 0.5 + 0.5;
        double xmaxzminh = Math.sin((long)(xmax * xmax) * seed * (long)zmin * (long)zmin) * 0.5 + 0.5;
        double xminzmaxh = Math.sin((long)(xmin * xmin) * seed * (long)zmax * (long)zmax) * 0.5 + 0.5;
        double xmaxzmaxh = Math.sin((long)(xmax * xmax) * seed * (long)zmax * (long)zmax) * 0.5 + 0.5;
        double xweight = (double)Math.floorMod(x, frequency) / (double)frequency;
        double zweight = (double)Math.floorMod(z, frequency) / (double)frequency;
        double xdiffzmin = xmaxzminh - xminzminh;
        double xhpzmin = xdiffzmin * xweight;
        double xhzmin = xhpzmin + xminzminh;
        double xdiffzmax = xmaxzmaxh - xminzmaxh;
        double xhpzmax = xdiffzmax * xweight;
        double xhzmax = xhpzmax + xminzmaxh;
        double zdiff = xhzmax - xhzmin;
        double zhp = zdiff * zweight;
        double zh = zhp * amplitude + xhzmin * amplitude;
        return zh;
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        return this.func_76933_b(listToReuse, x, z, width, length);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        return biomes.contains(this.biome) ? new BlockPos(x - range + random.nextInt(range * 2 + 1), 0, z - range + random.nextInt(range * 2 + 1)) : null;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        return allowed.contains(this.biome);
    }

    public boolean func_190944_c() {
        return true;
    }

    public Biome func_190943_d() {
        return this.biome;
    }
}

