/*
 * Decompiled with CFR 0.152.
 */
package iizvullokIcemountains.mod.world;

import iizvullokIcemountains.mod.world.BiomeProviderIceMountains;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkGeneratorIceMountains
implements IChunkGenerator {
    private final World world;
    private final Random random;
    private final IBlockState[] cachedBlockIDs = new IBlockState[256];
    private final Map<String, MapGenStructure> structureGenerators = new HashMap<String, MapGenStructure>();
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private boolean print = true;
    public static int maxY = 0;

    public ChunkGeneratorIceMountains(World worldIn, long seed, boolean generateStructures, String flatGeneratorSettings) {
        this.world = worldIn;
        this.random = new Random(seed);
        this.structureGenerators.put("Mineshaft", (MapGenStructure)new MapGenMineshaft());
        this.structureGenerators.put("Stronghold", (MapGenStructure)new MapGenStronghold());
        this.waterLakeGenerator = new WorldGenLakes((Block)Blocks.field_150355_j);
        this.lavaLakeGenerator = new WorldGenLakes((Block)Blocks.field_150353_l);
        this.hasDungeons = true;
        int j = 0;
        boolean k = false;
        worldIn.func_181544_b(j);
        this.hasDecoration = true;
    }

    public double[][] generateHeightMap(int x, int z) {
        double d;
        int az;
        int ax;
        int j;
        int i;
        double[][] heightmap = new double[16][16];
        for (i = 0; i < 16; ++i) {
            j = 0;
            while (j < 16) {
                ax = x * 16 + i;
                az = z * 16 + j;
                heightmap[i][j] = this.generateOctave(128, 128.0, ax, az, this.world.func_72905_C());
                double[] dArray = heightmap[i];
                int n = j;
                dArray[n] = dArray[n] + this.generateOctave(64, 64.0, ax, az, this.world.func_72905_C());
                double[] dArray2 = heightmap[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + this.generateOctave(32, 32.0, ax, az, this.world.func_72905_C());
                double[] dArray3 = heightmap[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] + this.generateOctave(16, 16.0, ax, az, this.world.func_72905_C());
                double[] dArray4 = heightmap[i];
                int n4 = j;
                dArray4[n4] = dArray4[n4] + this.generateOctave(8, 8.0, ax, az, this.world.func_72905_C());
                double[] dArray5 = heightmap[i];
                int n5 = j;
                dArray5[n5] = dArray5[n5] + this.generateOctave(4, 4.0, ax, az, this.world.func_72905_C());
                double[] dArray6 = heightmap[i];
                int n6 = j;
                dArray6[n6] = dArray6[n6] + this.generateOctave(2, 2.0, ax, az, this.world.func_72905_C());
                d = this.generateOctave(256, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray7 = heightmap[i];
                int n7 = j;
                dArray7[n7] = dArray7[n7] + d * d * d * 192.0;
                d = this.generateOctave(512, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray8 = heightmap[i];
                int n8 = j++;
                dArray8[n8] = dArray8[n8] + d * d * d * d * 384.0;
            }
        }
        for (i = 0; i < 16; ++i) {
            j = 0;
            while (j < 16) {
                ax = x * 16 + i;
                az = z * 16 + j;
                double f = this.generateOctave(512, 1.0, ax, az, this.world.func_72905_C());
                f += this.generateOctave(256, 0.5, ax, az, this.world.func_72905_C());
                f += this.generateOctave(128, 0.25, ax, az, this.world.func_72905_C());
                double f2 = (f /= 2.0) * f;
                f2 *= 4.0;
                double[] dArray = heightmap[i];
                int n = j++;
                dArray[n] = dArray[n] * f;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                ax = x * 16 + i;
                az = z * 16 + j;
                if (!(heightmap[i][j] < 75.0)) continue;
                d = 75.0 - heightmap[i][j];
                heightmap[i][j] = 75.0 - d / 2.0;
                if (!(heightmap[i][j] < 70.0)) continue;
                d = 70.0 - heightmap[i][j];
                heightmap[i][j] = 70.0 - d / 3.0;
                if (!(heightmap[i][j] < 64.0)) continue;
                d = 64.0 - heightmap[i][j];
                heightmap[i][j] = 64.0 - d * 10.0;
                d = 64.0 - heightmap[i][j];
                heightmap[i][j] = 64.0 - Math.sqrt(d) * 4.0;
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                ax = x * 16 + i;
                az = z * 16 + j;
                double h = 192.0;
                for (int f = 0; f < 8; ++f) {
                    if (!(heightmap[i][j] > h)) continue;
                    double d2 = (heightmap[i][j] - h) * 0.9;
                    heightmap[i][j] = h + d2;
                    h += 8.0;
                }
            }
        }
        return heightmap;
    }

    public double[][] generateFertilityMap(int x, int z) {
        double[][] fertilitymap = new double[16][16];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int ax = x * 16 + i;
                int az = z * 16 + j;
                fertilitymap[i][j] = this.generateOctave(256, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray = fertilitymap[i];
                int n = j;
                dArray[n] = dArray[n] + this.generateOctave(128, 0.5, ax, az, this.world.func_72905_C());
                double[] dArray2 = fertilitymap[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] * 1.25;
                double[] dArray3 = fertilitymap[i];
                int n3 = j;
                dArray3[n3] = dArray3[n3] - 0.25;
                if (!(fertilitymap[i][j] > 1.0)) continue;
                fertilitymap[i][j] = 1.0;
            }
        }
        return fertilitymap;
    }

    public double[][] generateTemperatureMap(int x, int z) {
        double[][] fertilitymap = new double[16][16];
        for (int i = 0; i < 16; ++i) {
            int j = 0;
            while (j < 16) {
                int ax = x * 16 + i;
                int az = z * 16 + j;
                fertilitymap[i][j] = this.generateOctave(256, 1.0, ax, az, this.world.func_72905_C());
                double[] dArray = fertilitymap[i];
                int n = j;
                dArray[n] = dArray[n] + this.generateOctave(128, 0.5, ax, az, this.world.func_72905_C());
                double[] dArray2 = fertilitymap[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] - 1.0;
            }
        }
        return fertilitymap;
    }

    public static double getLocalFertility(double height, double fertility, double temperature) {
        if (height < 64.0) {
            return 0.0;
        }
        double h = height - 64.0;
        return fertility - h / 96.0 + temperature / 4.0;
    }

    public static double getLocalTemperature(double height, double temperature) {
        if (height < 64.0) {
            return temperature;
        }
        double h = height - 64.0;
        return temperature - h / 96.0;
    }

    public double generateOctave(int frequency, double amplitude, int x, int z, long seed) {
        x = Math.abs(x + 34630988);
        z = Math.abs(z + 84534737);
        int xmin = x / frequency;
        int xmax = xmin + 1;
        int zmin = z / frequency;
        int zmax = zmin + 1;
        double xminzminh = Math.sin((long)(xmin * xmin) * seed * (long)zmin * (long)zmin) * 0.5 + 0.5;
        double xmaxzminh = Math.sin((long)(xmax * xmax) * seed * (long)zmin * (long)zmin) * 0.5 + 0.5;
        double xminzmaxh = Math.sin((long)(xmin * xmin) * seed * (long)zmax * (long)zmax) * 0.5 + 0.5;
        double xmaxzmaxh = Math.sin((long)(xmax * xmax) * seed * (long)zmax * (long)zmax) * 0.5 + 0.5;
        double xweight = (double)Math.floorMod(x, frequency) / (double)frequency;
        double zweight = (double)Math.floorMod(z, frequency) / (double)frequency;
        double xdiffzmin = xmaxzminh - xminzminh;
        double xhpzmin = xdiffzmin * xweight;
        double xhzmin = xhpzmin + xminzminh;
        double xdiffzmax = xmaxzmaxh - xminzmaxh;
        double xhpzmax = xdiffzmax * xweight;
        double xhzmax = xhpzmax + xminzmaxh;
        double zdiff = xhzmax - xhzmin;
        double zhp = zdiff * zweight;
        double zh = zhp * amplitude + xhzmin * amplitude;
        return zh;
    }

    public Chunk func_185932_a(int x, int z) {
        double[][] temperaturemap;
        double[][] fertilitymap;
        double[][] heightmap;
        ChunkPrimer chunkprimer = new ChunkPrimer();
        if (x == BiomeProviderIceMountains.chunkX && z == BiomeProviderIceMountains.chunkZ) {
            heightmap = BiomeProviderIceMountains.heightmap;
            fertilitymap = BiomeProviderIceMountains.fertilitymap;
            temperaturemap = BiomeProviderIceMountains.temperaturemap;
        } else {
            heightmap = this.generateHeightMap(x, z);
            fertilitymap = this.generateFertilityMap(x, z);
            temperaturemap = this.generateTemperatureMap(x, z);
        }
        Random random = new Random();
        random.setSeed(((long)x + 3985735358L) * ((long)z + 407340697436L) * this.world.func_72905_C());
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                int i2;
                if ((int)heightmap[j][i] > maxY) {
                    maxY = (int)heightmap[j][i];
                    System.out.println("MAX: " + maxY);
                }
                for (i2 = 0; i2 < 64; ++i2) {
                    if ((double)i2 < heightmap[j][i]) {
                        chunkprimer.func_177855_a(j, i2, i, Blocks.field_150348_b.func_176223_P());
                        continue;
                    }
                    if (i2 == 63) {
                        if (temperaturemap[j][i] < -0.5) {
                            chunkprimer.func_177855_a(j, i2, i, Blocks.field_150432_aD.func_176223_P());
                            continue;
                        }
                        if (temperaturemap[j][i] >= -0.5 && temperaturemap[j][i] < 0.0) {
                            double v = (temperaturemap[j][i] + 0.5) * 2.0;
                            if (random.nextDouble() > v) {
                                chunkprimer.func_177855_a(j, i2, i, Blocks.field_150432_aD.func_176223_P());
                                continue;
                            }
                            chunkprimer.func_177855_a(j, i2, i, Blocks.field_150355_j.func_176223_P());
                            continue;
                        }
                        chunkprimer.func_177855_a(j, i2, i, Blocks.field_150355_j.func_176223_P());
                        continue;
                    }
                    chunkprimer.func_177855_a(j, i2, i, Blocks.field_150355_j.func_176223_P());
                }
                i2 = 64;
                while ((double)i2 < heightmap[j][i]) {
                    chunkprimer.func_177855_a(j, i2, i, Blocks.field_150348_b.func_176223_P());
                    ++i2;
                }
                if (heightmap[j][i] < 64.0) {
                    chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150351_n.func_176223_P());
                    chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150351_n.func_176223_P());
                    chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150351_n.func_176223_P());
                    chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 3, i, Blocks.field_150351_n.func_176223_P());
                } else {
                    int h;
                    double temperature;
                    double v;
                    int height = (int)heightmap[j][i];
                    double fertility = ChunkGeneratorIceMountains.getLocalFertility(height, fertilitymap[j][i], temperaturemap[j][i]);
                    if (fertility < -0.5) {
                        if (random.nextDouble() > 0.5) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150347_e.func_176223_P());
                        }
                        if (random.nextDouble() > 0.5) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150347_e.func_176223_P());
                        }
                    } else if (fertility >= -0.5 && fertility < 0.0) {
                        v = (fertility + 0.5) * 2.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150347_e.func_176223_P());
                        }
                    } else if (fertility >= 0.0 && fertility < 0.1) {
                        v = fertility * 10.0;
                        if (random.nextDouble() < v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                        }
                    } else if (fertility >= 0.1 && fertility < 0.2) {
                        v = (fertility - 0.1) * 10.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P());
                        }
                    } else if (fertility >= 0.2 && fertility < 0.4) {
                        v = (fertility - 0.2) * 5.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P());
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150349_c.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                        }
                    } else if (fertility >= 0.4 && fertility < 0.6) {
                        v = (fertility - 0.4) * 5.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150349_c.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150349_c.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                        }
                    } else if (fertility >= 0.6 && fertility < 0.8) {
                        v = (fertility - 0.6) * 5.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150349_c.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 3, i, Blocks.field_150346_d.func_176223_P());
                        }
                    } else if (fertility >= 0.8 && fertility < 1.0) {
                        v = (fertility - 0.8) * 5.0;
                        if (random.nextDouble() > v) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 3, i, Blocks.field_150346_d.func_176223_P());
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 3, i, Blocks.field_150346_d.func_176223_P());
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 4, i, Blocks.field_150346_d.func_176223_P());
                        }
                    } else {
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 1, i, Blocks.field_150346_d.func_176223_P());
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 2, i, Blocks.field_150346_d.func_176223_P());
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 3, i, Blocks.field_150346_d.func_176223_P());
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] - 4, i, Blocks.field_150346_d.func_176223_P());
                    }
                    if ((temperature = ChunkGeneratorIceMountains.getLocalTemperature(heightmap[j][i], temperaturemap[j][i])) < -1.5) {
                        if (random.nextBoolean()) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150433_aE.func_176223_P());
                        } else {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150403_cj.func_176223_P());
                        }
                        int h2 = random.nextInt(4) + 5;
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] + 1, i, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(h2)));
                    } else if (temperature >= -1.5 && temperature < -1.0) {
                        double v2 = (temperature + 1.5) * 2.0;
                        if (random.nextDouble() > v2) {
                            if (random.nextBoolean()) {
                                chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150433_aE.func_176223_P());
                            } else {
                                chunkprimer.func_177855_a(j, (int)heightmap[j][i], i, Blocks.field_150403_cj.func_176223_P());
                            }
                        }
                        h = random.nextInt(4) + 5;
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] + 1, i, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(h)));
                    } else if (temperature >= -1.0 && temperature < -0.5) {
                        double v3 = 8.0 - (temperature + 1.0) * 16.0;
                        if (v3 < 0.0) {
                            v3 = 0.0;
                        }
                        if ((h = v3 > 4.0 ? random.nextInt(4) + 1 + (int)(v3 - 4.0) : random.nextInt((int)(v3 + 1.0)) + 1) > 8) {
                            h = 8;
                        }
                        chunkprimer.func_177855_a(j, (int)heightmap[j][i] + 1, i, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(h)));
                    } else if (temperature >= -0.5 && temperature < 0.0) {
                        double v4 = (temperature + 0.5) * 2.0;
                        if (random.nextDouble() > v4) {
                            chunkprimer.func_177855_a(j, (int)heightmap[j][i] + 1, i, Blocks.field_150431_aC.func_176223_P());
                        }
                    }
                }
                if (random.nextInt(5) > 3) {
                    chunkprimer.func_177855_a(j, 4, i, Blocks.field_150357_h.func_176223_P());
                }
                if (random.nextInt(5) > 2) {
                    chunkprimer.func_177855_a(j, 3, i, Blocks.field_150357_h.func_176223_P());
                }
                if (random.nextInt(5) > 1) {
                    chunkprimer.func_177855_a(j, 2, i, Blocks.field_150357_h.func_176223_P());
                }
                if (random.nextInt(5) > 0) {
                    chunkprimer.func_177855_a(j, 1, i, Blocks.field_150357_h.func_176223_P());
                }
                chunkprimer.func_177855_a(j, 0, i, Blocks.field_150357_h.func_176223_P());
            }
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.villageGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        for (MapGenBase mapGenBase : this.structureGenerators.values()) {
            mapGenBase.func_186125_a(this.world, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] biomeArray = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.func_185362_a((Biome)biomeArray[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockPos blockpos1;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(new BlockPos(i + 16, 0, j + 16));
        boolean flag = false;
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)flag);
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            boolean flag1 = mapgenstructure.func_175794_a(this.world, this.random, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            this.waterLakeGenerator.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
        }
        if (!(this.lavaLakeGenerator == null || flag || this.random.nextInt(8) != 0 || (blockpos1 = blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(this.random.nextInt(248) + 8), this.random.nextInt(16) + 8)).func_177956_o() >= this.world.func_181545_F() && this.random.nextInt(10) != 0)) {
            this.lavaLakeGenerator.func_180709_b(this.world, this.random, blockpos1);
        }
        if (this.hasDungeons) {
            for (int i1 = 0; i1 < 8; ++i1) {
                new WorldGenDungeons().func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
            }
        }
        if (this.hasDecoration) {
            biome.func_180624_a(this.world, this.random, blockpos);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        MapGenStructure mapgenstructure = this.structureGenerators.get(structureName);
        return mapgenstructure != null ? mapgenstructure.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        MapGenStructure mapgenstructure = this.structureGenerators.get(structureName);
        return mapgenstructure != null ? mapgenstructure.func_175795_b(pos) : false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            mapgenstructure.func_186125_a(this.world, x, z, (ChunkPrimer)null);
        }
    }
}

