/*
 * Decompiled with CFR 0.152.
 */
package iizvullokIcemountains.mod.world;

import iizvullokIcemountains.mod.util.Heightmap;
import iizvullokIcemountains.mod.util.OpenSimplexNoise;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkGeneratorIceMountains2
implements IChunkGenerator {
    public static final int SIZE = 1024;
    private final World world;
    private final Random random;
    private final IBlockState[] cachedBlockIDs = new IBlockState[256];
    private final Map<String, MapGenStructure> structureGenerators = new HashMap<String, MapGenStructure>();
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private boolean print = true;
    public static int maxY = 0;

    public ChunkGeneratorIceMountains2(World worldIn, long seed, boolean generateStructures, String flatGeneratorSettings) {
        this.world = worldIn;
        this.random = new Random(seed);
        this.structureGenerators.put("Mineshaft", (MapGenStructure)new MapGenMineshaft());
        this.structureGenerators.put("Stronghold", (MapGenStructure)new MapGenStronghold());
        this.waterLakeGenerator = new WorldGenLakes((Block)Blocks.field_150355_j);
        this.lavaLakeGenerator = new WorldGenLakes((Block)Blocks.field_150353_l);
        this.hasDungeons = true;
        int j = 0;
        boolean k = false;
        worldIn.func_181544_b(j);
        this.hasDecoration = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_185932_a(int x, int z) {
        int j;
        boolean forbidden = false;
        String name = System.getProperty("user.dir") + DimensionManager.getCurrentSaveRootDirectory().getPath().substring(1) + "/forbidden.txt";
        File forbidden_ = new File(name);
        boolean exists = forbidden_.exists();
        if (exists) {
            try {
                String content = new String(Files.readAllBytes(forbidden_.toPath()));
                if (content.equals("true")) {
                    forbidden = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(forbidden_));
                if (this.world.func_72905_C() == 525429805L) {
                    writer.write("true");
                    forbidden = true;
                } else {
                    writer.write("false");
                    forbidden = false;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.world.func_72905_C() == 525429805L) {
            forbidden = true;
        }
        ChunkPrimer chunkprimer = new ChunkPrimer();
        double[][][] chunkData = Heightmap.loadChunkData(x, z, this.world.func_72905_C());
        OpenSimplexNoise noise = new OpenSimplexNoise(this.world.func_72905_C());
        double[][][] noiseMap = null;
        if (forbidden) {
            noiseMap = new double[16][64][16];
            for (int i = 0; i < 16; ++i) {
                for (j = 0; j < 64; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        double FEATURE_SIZE_XZ = 64.0;
                        double FEATURE_SIZE_Y = 16.0;
                        double value = noise.eval((double)(x * 16 + i) / FEATURE_SIZE_XZ, (double)j / FEATURE_SIZE_Y, (double)(z * 16 + k) / FEATURE_SIZE_XZ);
                        FEATURE_SIZE_XZ = 32.0;
                        FEATURE_SIZE_Y = 32.0;
                        for (int l = 0; l < 1; ++l) {
                            value += noise.eval((double)(x * 16 + i) / (FEATURE_SIZE_XZ / Math.pow(2.0, l + 1)), (double)j / (FEATURE_SIZE_Y / Math.pow(2.0, l + 1)), (double)(z * 16 + k) / (FEATURE_SIZE_XZ / Math.pow(2.0, l + 1))) / Math.pow(2.0, l + 1);
                        }
                        noiseMap[i][j][k] = value;
                    }
                }
            }
        }
        Random random = new Random();
        random.setSeed(((long)x + 3985735358L) * ((long)z + 407340697436L) * this.world.func_72905_C());
        for (j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                double absolute_max_roughness = Math.max(0.0, Math.min(1.0, (chunkData[j][i][5] - 200.0) / 40.0));
                absolute_max_roughness = 0.0;
                double max_roughness = Math.min(absolute_max_roughness * 12.0, (chunkData[j][i][1] + 1.0) * (chunkData[j][i][2] + 1.0) / 8.0);
                double roughness = Math.min(max_roughness, Math.max(max_roughness - Math.max(0.0, chunkData[j][i][0] - 100.0) / 10.0, 0.0));
                if (forbidden) {
                    roughness = 16.0;
                }
                for (int i2 = 0; i2 < 256; ++i2) {
                    double d = chunkData[j][i][0];
                    if (forbidden) {
                        d = chunkData[j][i][0] + noiseMap[j][(int)Math.max(0.0, Math.min(63.0, (double)i2 - chunkData[j][i][0] + 32.0))][i] * roughness;
                    }
                    if (!((double)i2 < d)) continue;
                    double rockyness = Math.max(0.0, (double)(i2 - 170) + chunkData[j][i][3] / 16.0) / 100.0;
                    if (random.nextDouble() < rockyness) {
                        chunkprimer.func_177855_a(j, i2, i, Blocks.field_150347_e.func_176223_P());
                        continue;
                    }
                    chunkprimer.func_177855_a(j, i2, i, Blocks.field_150348_b.func_176223_P());
                }
                boolean inStone = false;
                int level = 0;
                for (int i3 = 255; i3 >= 0; --i3) {
                    if (!chunkprimer.func_177856_a(j, i3, i).equals(Blocks.field_150350_a.func_176223_P()) && !inStone) {
                        inStone = true;
                        int dirtLayer = (int)Math.max(0.0, 7.0 - chunkData[j][i][1] / 4.0 + chunkData[j][i][2] / 32.0 - chunkData[j][i][0] / 32.0) - 2 * level;
                        double temperature = chunkData[j][i][3];
                        double localTemperature = (temperature - 64.0 - chunkData[j][i][0]) / 64.0;
                        int snowLayer = (int)Math.min(8.0, Math.max(0.0, localTemperature * -4.0 - chunkData[j][i][1] / 8.0)) - 2 * level;
                        if (snowLayer <= 0 || i3 >= 63) {
                            // empty if block
                        }
                        if (snowLayer > 0 && i3 < 63) {
                            chunkprimer.func_177855_a(j, 63, i, Blocks.field_150432_aD.func_176223_P());
                        }
                        ++level;
                        double localFertility = chunkData[j][i][4] / 64.0 + localTemperature;
                        if (dirtLayer > 0 && i3 > dirtLayer) {
                            double p = 80.0 - (chunkData[j][i][4] + chunkData[j][i][0] / 32.0);
                            if (chunkData[j][i][4] + chunkData[j][i][0] / 32.0 < 80.0 && random.nextDouble() < p) {
                                double p0 = (chunkData[j][i][3] - 2.0) * 0.1;
                                double p1 = localTemperature * 1.0;
                                if (random.nextDouble() < p0 * p1) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150354_m.func_176223_P());
                                } else {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150351_n.func_176223_P());
                                }
                            } else if (localFertility < 1.15) {
                                chunkprimer.func_177855_a(j, i3, i, Blocks.field_150351_n.func_176223_P());
                            } else if (localFertility < 1.2) {
                                chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                            } else if (localFertility < 3.5) {
                                chunkprimer.func_177855_a(j, i3, i, Blocks.field_150349_c.func_176223_P());
                            } else {
                                chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                            }
                            if (i3 < 65) {
                                p = 720.0 - chunkData[j][i][6] + chunkData[j][i][0] * 10.0;
                                if ((p *= 10.0) < random.nextDouble()) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150354_m.func_176223_P());
                                } else {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150351_n.func_176223_P());
                                }
                            }
                            double glacierValue = 0.0;
                            if (snowLayer > 0) {
                                glacierValue = ((double)snowLayer + chunkData[j][i][1] / 32.0) * chunkData[j][i][2] / 64.0 - Math.max(0.0, localFertility);
                            }
                            if (glacierValue > 4.0) {
                                chunkprimer.func_177855_a(j, i3, i, Blocks.field_150433_aE.func_176223_P());
                            }
                            boolean set = true;
                            for (int l = 1; l < dirtLayer; ++l) {
                                if (set && !chunkprimer.func_177856_a(j, i3 - l, i).equals(Blocks.field_150350_a.func_176223_P())) {
                                    if (chunkData[j][i][4] + chunkData[j][i][0] / 32.0 < 80.0) {
                                        if (chunkData[j][i][3] > 2.0 && localTemperature > 0.0) {
                                            chunkprimer.func_177855_a(j, i3 - l, i, Blocks.field_150354_m.func_176223_P());
                                            continue;
                                        }
                                        chunkprimer.func_177855_a(j, i3 - l, i, Blocks.field_150351_n.func_176223_P());
                                        continue;
                                    }
                                    if (localFertility < 1.15) {
                                        chunkprimer.func_177855_a(j, i3 - l, i, Blocks.field_150351_n.func_176223_P());
                                        continue;
                                    }
                                    chunkprimer.func_177855_a(j, i3 - l, i, Blocks.field_150346_d.func_176223_P());
                                    continue;
                                }
                                set = false;
                            }
                            if (i3 < 63 && chunkData[j][i][6] + chunkData[j][i][0] * 10.0 > 720.0) {
                                chunkprimer.func_177855_a(j, i3 - 1, i, Blocks.field_150435_aG.func_176223_P());
                            }
                        }
                        double swampBlend = Math.min(1.0, Math.max(0.0, (chunkData[j][i][7] - 100.0) / 56.0));
                        double heightBlend = 1.0 - Math.min(1.0, Math.max(0.0, (chunkData[j][i][0] - 63.0) / 4.0));
                        double midBlend = 0.0;
                        if (chunkData[j][i][6] >= 80.0 && chunkData[j][i][6] < 98.0) {
                            double blend;
                            midBlend = blend = (chunkData[j][i][6] - 80.0) / 18.0;
                        } else if (chunkData[j][i][6] >= 98.0 && chunkData[j][i][6] < 158.0) {
                            midBlend = 1.0;
                        } else if (chunkData[j][i][6] >= 158.0 && chunkData[j][i][6] < 176.0) {
                            double blend = (chunkData[j][i][6] - 158.0) / 18.0;
                            midBlend = 1.0 - blend;
                        }
                        if (random.nextDouble() < swampBlend * heightBlend * midBlend) {
                            if (i3 > 63) {
                                int p = random.nextInt(4);
                                if (p == 0) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                                } else if (p == 1) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                                } else if (p == 2) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_192444_dS.func_176223_P().func_177226_a((IProperty)BlockConcretePowder.field_192426_a, (Comparable)EnumDyeColor.BROWN));
                                } else {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_185774_da.func_176223_P());
                                }
                            } else {
                                int p = random.nextInt(3);
                                if (p == 0) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL));
                                } else if (p == 1) {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
                                } else {
                                    chunkprimer.func_177855_a(j, i3, i, Blocks.field_192444_dS.func_176223_P().func_177226_a((IProperty)BlockConcretePowder.field_192426_a, (Comparable)EnumDyeColor.BROWN));
                                }
                            }
                        }
                    }
                    if (chunkprimer.func_177856_a(j, i3, i).equals(Blocks.field_150350_a.func_176223_P()) && inStone) {
                        inStone = false;
                    }
                    if (i3 < 64 && chunkprimer.func_177856_a(j, i3, i).equals(Blocks.field_150350_a.func_176223_P())) {
                        chunkprimer.func_177855_a(j, i3, i, Blocks.field_150355_j.func_176223_P());
                    }
                    if (chunkData[j][i][0] == 63.0) {
                        double d410 = (chunkData[j][i][7] - 156.0) / 100.0;
                        if (random.nextDouble() < d410 && chunkData[j][i][6] + chunkData[j][i][0] * 10.0 > 720.0) {
                            chunkprimer.func_177855_a(j, 64, i, Blocks.field_150392_bi.func_176223_P());
                        }
                    }
                    if (random.nextInt(5) > i3 - 1) {
                        chunkprimer.func_177855_a(j, i3, i, Blocks.field_150357_h.func_176223_P());
                    }
                    chunkprimer.func_177855_a(0, 0, 0, Blocks.field_180401_cv.func_176223_P());
                }
            }
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.villageGenerator.func_186125_a(this.world, x, z, chunkprimer);
        }
        for (MapGenBase mapGenBase : this.structureGenerators.values()) {
            mapGenBase.func_186125_a(this.world, x, z, chunkprimer);
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] biomeArray = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.func_185362_a((Biome)biomeArray[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void placeTree(int x, int z, ChunkPrimer chunkprimer, int size, long treeSeed) {
    }

    public void placeBlock(int x, int y, int z, IBlockState state, ChunkPrimer chunkprimer) {
        if (x >= 0 && x < 16 && y >= 0 && y < 256 && z >= 0 && z < 16) {
            chunkprimer.func_177855_a(x, y, z, state);
        }
    }

    public void decorate(int x, int z, ChunkPrimer chunkprimer) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.decorateChunk(x + i, z + j, chunkprimer);
            }
        }
    }

    public void decorateChunk(int x, int z, ChunkPrimer chunkprimer) {
        for (int i = 0; i < 4; ++i) {
            int posX = (int)(Math.random() * 16.0);
            int posZ = (int)(Math.random() * 16.0);
            this.generateTree(posX, posZ, chunkprimer);
        }
    }

    public void generateTree(int x, int z, ChunkPrimer chunkprimer) {
        int y = chunkprimer.func_186138_a(x, z);
        this.setBlockState(x, y, z, chunkprimer, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE));
    }

    public void setBlockState(int x, int y, int z, ChunkPrimer chunkprimer, IBlockState block) {
        if (x >= 0 && x < 16 && y >= 0 && y < 256 && z >= 0 && z < 16) {
            chunkprimer.func_177855_a(x, y, z, block);
        }
    }

    public void func_185931_b(int x, int z) {
        BlockPos blockpos1;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.func_180494_b(new BlockPos(i + 16, 0, j + 16));
        boolean flag = false;
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)flag);
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            boolean flag1 = mapgenstructure.func_175794_a(this.world, this.random, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            this.waterLakeGenerator.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
        }
        if (!(this.lavaLakeGenerator == null || flag || this.random.nextInt(8) != 0 || (blockpos1 = blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(this.random.nextInt(248) + 8), this.random.nextInt(16) + 8)).func_177956_o() >= this.world.func_181545_F() && this.random.nextInt(10) != 0)) {
            this.lavaLakeGenerator.func_180709_b(this.world, this.random, blockpos1);
        }
        if (this.hasDungeons) {
            for (int i1 = 0; i1 < 8; ++i1) {
                new WorldGenDungeons().func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
            }
        }
        if (this.hasDecoration) {
            biome.func_180624_a(this.world, this.random, blockpos);
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        MapGenStructure mapgenstructure = this.structureGenerators.get(structureName);
        return mapgenstructure != null ? mapgenstructure.func_180706_b(worldIn, position, findUnexplored) : null;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        MapGenStructure mapgenstructure = this.structureGenerators.get(structureName);
        return mapgenstructure != null ? mapgenstructure.func_175795_b(pos) : false;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            mapgenstructure.func_186125_a(this.world, x, z, (ChunkPrimer)null);
        }
    }
}

