/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.generators;

import com.google.common.primitives.Ints;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache_.commons.lang3.Validate;

public final class Seed {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Set<String> siblings = new HashSet<String>();
    private final int innerSeed;
    private boolean usedInnerSeed = false;
    public static final Seed ROOT = new Seed(0);

    private Seed(int innerSeed) {
        this.innerSeed = innerSeed;
    }

    public Seed newSeed(String newSeedName) {
        Validate.isTrue(!this.siblings.contains(newSeedName), "branch %s already in used\n", newSeedName);
        byte[] preHashed = (this.innerSeed + newSeedName).getBytes(CHARSET);
        byte[] hashed = DigestUtils.getSha1Digest().digest(preHashed);
        int newSeed = Ints.fromByteArray((byte[])hashed);
        return new Seed(newSeed);
    }

    public int getAsInt() {
        Validate.isTrue(!this.usedInnerSeed, "already used as int before", new Object[0]);
        this.usedInnerSeed = true;
        return this.innerSeed;
    }

    public Seed copyWithoutWarnings() {
        return new Seed(this.innerSeed);
    }
}

