/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.generators;

import java.util.Arrays;
import org.apache_.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public final class Timing
implements Comparable<Timing> {
    private static final Timing ZERO = new Timing();
    private final int[] timings;

    private Timing(Timing superTimer, int subTiming) {
        this.timings = subTiming == 0 ? superTimer.timings : ArrayUtils.add(superTimer.timings, subTiming);
    }

    private Timing() {
        this.timings = new int[0];
    }

    public static Timing getDefault() {
        return ZERO;
    }

    public static Builder initBuilder() {
        return new Builder(ZERO);
    }

    public static Builder initBuilder(Timing timing) {
        return new Builder(timing);
    }

    @Override
    public int compareTo(@NotNull Timing other) {
        int length = Math.max(this.timings.length, other.timings.length);
        for (int i = 0; i < length; ++i) {
            int comparison = Integer.compare(this.getSubTiming(i), other.getSubTiming(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private int getSubTiming(int index) {
        if (index < this.timings.length) {
            return this.timings[index];
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timing timing = (Timing)o;
        return Arrays.equals(this.timings, timing.timings);
    }

    public int hashCode() {
        return Arrays.hashCode(this.timings);
    }

    public static final class Builder {
        private final Timing superTimer;
        private int timing = 0;

        private Builder(Timing superTimer) {
            this.superTimer = superTimer;
        }

        public Timing getNextTiming() {
            Timing result = new Timing(this.superTimer, this.timing);
            ++this.timing;
            return result;
        }
    }
}

