/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.generators.nonworldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import weightedgpa.infinibiome.api.dependency.MultiDep;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.internal.misc.Helper;
import weightedgpa.infinibiome.internal.misc.MCHelper;

public interface PlantGrowthController
extends MultiDep {
    public boolean controlsPlant(BlockState var1, boolean var2);

    default public boolean controlsPlant(BlockPos pos, IWorld world) {
        return this.controlsPlant(world.func_180495_p(pos), PlantGrowthController.is2x2(pos, world));
    }

    public boolean isValidGrowth(BlockPos var1, IWorld var2);

    public boolean canGrowWithBonemeal(BlockPos var1, IWorld var2, Random var3);

    default public boolean canGrowWithTick(BlockPos pos, IWorld world, Random random) {
        return this.canGrowWithBonemeal(pos, world, random);
    }

    default public double getPlantControllerWeight(BlockPos2D pos) {
        return 1.0;
    }

    public static boolean is2x2(BlockPos pos, IWorld world) {
        Block saplingBlock = world.func_180495_p(pos).func_177230_c();
        for (Direction d : MCHelper.NSWE) {
            if (!world.func_180495_p(pos.func_177972_a(d)).func_177230_c().equals(saplingBlock) || !world.func_180495_p(pos.func_177972_a(d.func_176746_e())).func_177230_c().equals(saplingBlock) || !world.func_180495_p(pos.func_177972_a(d).func_177972_a(d.func_176746_e())).func_177230_c().equals(saplingBlock)) continue;
            return true;
        }
        return false;
    }

    public static <T extends PlantGrowthController> Result<T> getPlant(BlockPos pos, IWorld world, Random random, List<T> plantGrowthControllers) {
        plantGrowthControllers = new ArrayList<T>(plantGrowthControllers);
        plantGrowthControllers.removeIf(p -> !p.controlsPlant(pos, world));
        if (plantGrowthControllers.isEmpty()) {
            return new Result.NOT_CONTROLLED();
        }
        plantGrowthControllers.removeIf(p -> !p.isValidGrowth(pos, world));
        if (plantGrowthControllers.isEmpty()) {
            return new Result.INVALID_GROWTH();
        }
        return new Result.OK<PlantGrowthController>(Helper.pickWeighted(pl -> pl.getPlantControllerWeight(MCHelper.to2D(pos)), random, plantGrowthControllers));
    }

    public static abstract class Result<T> {

        public static class INVALID_GROWTH<T>
        extends Result<T> {
        }

        public static class NOT_CONTROLLED<T>
        extends Result<T> {
        }

        public static class OK<T>
        extends Result<T> {
            public final T controller;

            OK(T controller) {
                this.controller = controller;
            }

            public String toString() {
                return "OK{controller=" + this.controller + '}';
            }
        }
    }
}

