/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.pointsprovider;

import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache_.commons.lang3.mutable.MutableInt;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public interface PointsProvider<T> {
    public Iterable<T> getClosestPoints(T var1, int var2);

    public Iterable<T> getBoundedPoints(T var1, double var2);

    public PosInfo<T> getPosInfo();

    default public boolean hasPoint(T pos) {
        Iterator<T> iterator = this.getBoundedPoints(pos, 0.0).iterator();
        if (iterator.hasNext()) {
            T point = iterator.next();
            if (!3.$assertionsDisabled && !point.equals(pos)) {
                throw new AssertionError((Object)(pos + " " + point));
            }
            return true;
        }
        return false;
    }

    default public T getClosestPoint(T center) {
        Iterable<T> result = this.getClosestPoints(center, 1);
        if (Iterables.isEmpty(result)) {
            return null;
        }
        return (T)Iterables.get(result, (int)0);
    }

    default public PointsProvider<T> filterOutput(final Predicate<T> condition) {
        return new PointsProvider<T>(){

            @Override
            public Iterable<T> getClosestPoints(T center, final int maxCount) {
                final MutableInt counter = new MutableInt(0);
                final Iterator points = PointsProvider.this.getClosestPoints(center, Integer.MAX_VALUE).iterator();
                return () -> new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return points.hasNext() && counter.getValue() < maxCount;
                    }

                    @Override
                    public T next() {
                        Object point;
                        while (!condition.test(point = points.next())) {
                        }
                        counter.increment();
                        return point;
                    }
                };
            }

            @Override
            public Iterable<T> getBoundedPoints(T center, double maxRadius) {
                return Iterables.filter(PointsProvider.this.getBoundedPoints(center, maxRadius), condition::test);
            }

            @Override
            public PosInfo<T> getPosInfo() {
                return PointsProvider.this.getPosInfo();
            }
        };
    }

    default public <NT> PointsProvider<NT> mapPoints(final IntPosInfo<NT> newPosInfo) {
        return new PointsProvider<NT>(){

            @Override
            public Iterable<NT> getClosestPoints(NT center, int maxCount) {
                Object centerMapped = newPosInfo.convert(center, PointsProvider.this.getPosInfo().floor());
                return Iterables.transform(PointsProvider.this.getClosestPoints(centerMapped, maxCount), p -> PointsProvider.this.getPosInfo().convert(p, newPosInfo));
            }

            @Override
            public Iterable<NT> getBoundedPoints(NT center, double maxRadius) {
                Object centerMapped = newPosInfo.convert(center, PointsProvider.this.getPosInfo().floor());
                return Iterables.transform(PointsProvider.this.getBoundedPoints(centerMapped, maxRadius), p -> PointsProvider.this.getPosInfo().convert(p, newPosInfo));
            }

            @Override
            public IntPosInfo<NT> getPosInfo() {
                return newPosInfo;
            }
        };
    }

    default public double getDistanceToVoronoiBorder(T center) {
        return MathHelper.getDistanceToVoronoiBorder(center, this, 5);
    }

    static {
        if (3.$assertionsDisabled) {
            // empty if block
        }
    }
}

