/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.pos;

import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;

public class BlockPos2D {
    public static IntPosInfo<BlockPos2D> INFO = new IntPosInfo<BlockPos2D>(){

        @Override
        public int getIntX(BlockPos2D pos) {
            return pos.getBlockX();
        }

        @Override
        public int getIntZ(BlockPos2D pos) {
            return pos.getBlockZ();
        }

        @Override
        public int getLog2Scale() {
            return 0;
        }

        @Override
        public BlockPos2D build(int x, int z) {
            return new BlockPos2D(x, z);
        }
    };
    int blockX;
    int blockZ;

    public BlockPos2D(int blockX, int blockZ) {
        this.blockX = blockX;
        this.blockZ = blockZ;
    }

    public int getBlockX() {
        return this.blockX;
    }

    public int getBlockZ() {
        return this.blockZ;
    }

    public BlockPos2D offset(int x, int z) {
        return new BlockPos2D(this.getBlockX() + x, this.getBlockZ() + z);
    }

    public BlockPos2D offset(Direction direction, int amount) {
        switch (direction) {
            case NORTH: {
                return this.offset(0, -amount);
            }
            case SOUTH: {
                return this.offset(0, amount);
            }
            case WEST: {
                return this.offset(-amount, 0);
            }
            case EAST: {
                return this.offset(amount, 0);
            }
        }
        return this;
    }

    public BlockPos2D offset(Direction direction) {
        return this.offset(direction, 1);
    }

    public BlockPos to3D(int y) {
        return new BlockPos(this.getBlockX(), y, this.getBlockZ());
    }

    public BlockPos to3D(ToIntFunction<BlockPos2D> func) {
        return new BlockPos(this.getBlockX(), func.applyAsInt(this), this.getBlockZ());
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(Log2helper.floorDiv(this.getBlockX(), 4), Log2helper.floorDiv(this.getBlockZ(), 4));
    }

    public BlockPos2D toImmutable() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos2D that = (BlockPos2D)o;
        return this.getBlockX() == that.getBlockX() && this.getBlockZ() == that.getBlockZ();
    }

    public int hashCode() {
        return Objects.hash(this.blockX, this.blockZ);
    }

    public String toString() {
        return String.format("BlockPos2D(x=%s, z=%s)", this.getBlockX(), this.getBlockZ());
    }

    public static class Mutable
    extends BlockPos2D {
        public Mutable() {
            super(0, 0);
        }

        public void setPos(int blockX, int blockZ) {
            this.blockX = blockX;
            this.blockZ = blockZ;
        }

        @Override
        public BlockPos2D toImmutable() {
            return new BlockPos2D(this.getBlockX(), this.getBlockZ());
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException("should not be stored");
        }

        @Override
        public String toString() {
            return "BlockPos2D.Mutable{blockX=" + this.getBlockX() + ", blockZ=" + this.getBlockZ() + '}';
        }
    }
}

