/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.pos;

import weightedgpa.infinibiome.api.pos.PosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;

public interface IntPosInfo<T>
extends PosInfo<T> {
    public int getIntX(T var1);

    public int getIntZ(T var1);

    public int getLog2Scale();

    default public int getOffset() {
        return 0;
    }

    @Override
    default public <O> O convert(T pos, IntPosInfo<O> otherPosInfo) {
        int resultX = this.getIntX(pos);
        resultX = Log2helper.mult(resultX, this.getLog2Scale());
        resultX += this.getOffset();
        resultX -= otherPosInfo.getOffset();
        resultX = Log2helper.floorDiv(resultX, otherPosInfo.getLog2Scale());
        int resultZ = this.getIntZ(pos);
        resultZ = Log2helper.mult(resultZ, this.getLog2Scale());
        resultZ += this.getOffset();
        resultZ -= otherPosInfo.getOffset();
        resultZ = Log2helper.floorDiv(resultZ, otherPosInfo.getLog2Scale());
        return otherPosInfo.build(resultX, resultZ);
    }

    @Override
    default public IntPosInfo<T> floor() {
        return this;
    }

    @Override
    public T build(int var1, int var2);

    @Override
    default public double getX(T pos) {
        return this.getIntX(pos);
    }

    @Override
    default public double getZ(T pos) {
        return this.getIntZ(pos);
    }

    default public T offset(T center, int xOffset, int zOffset) {
        return this.build(this.getIntX(center) + xOffset, this.getIntZ(center) + zOffset);
    }
}

