/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.pos;

import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.misc.MathHelper;
import weightedgpa.infinibiome.internal.pos.PosHelper;

public final class InterChunkPos {
    public static final int CENTER_LENGTH = 16;
    public static final int OVERALL_LENGTH = 32;
    private final ChunkPos lowestChunkPos;
    private final int lowestX;
    private final int lowestZ;
    public static final IntPosInfo<InterChunkPos> INFO = new IntPosInfo<InterChunkPos>(){

        @Override
        public int getIntX(InterChunkPos pos) {
            return pos.getX();
        }

        @Override
        public int getIntZ(InterChunkPos pos) {
            return pos.getZ();
        }

        @Override
        public int getLog2Scale() {
            return 4;
        }

        @Override
        public int getOffset() {
            return 8;
        }

        @Override
        public InterChunkPos build(int x, int z) {
            return new InterChunkPos(x, z);
        }
    };

    public InterChunkPos(int x, int z) {
        this(new ChunkPos(x, z));
    }

    public InterChunkPos(ChunkPos lowestChunkPos) {
        this.lowestChunkPos = lowestChunkPos;
        this.lowestX = lowestChunkPos.field_77276_a * 16 + 8;
        this.lowestZ = lowestChunkPos.field_77275_b * 16 + 8;
    }

    public InterChunkPos(BlockPos2D pos) {
        this(pos.offset(-8, -8).toChunkPos());
    }

    public InterChunkPos(BlockPos pos) {
        this(new ChunkPos(pos.func_177982_a(-8, 0, -8)));
    }

    public InterChunkPos offset(int x, int z) {
        return new InterChunkPos(new ChunkPos(this.lowestChunkPos.field_77276_a + x, this.lowestChunkPos.field_77275_b + z));
    }

    public int getX() {
        return this.lowestChunkPos.field_77276_a;
    }

    public int getZ() {
        return this.lowestChunkPos.field_77275_b;
    }

    public ChunkPos getLowestChunkPos() {
        return this.lowestChunkPos;
    }

    public BlockPos2D getLowestCenterBlockPos() {
        return new BlockPos2D(this.lowestX, this.lowestZ);
    }

    public void forEachCenterPos(Consumer<BlockPos2D> consumer) {
        BlockPos2D.Mutable lowestPos = new BlockPos2D.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                lowestPos.setPos(this.lowestX + x, this.lowestZ + z);
                consumer.accept(lowestPos);
            }
        }
    }

    public void forEachAllPos(Consumer<BlockPos2D> consumer) {
        BlockPos2D.Mutable lowestPos = new BlockPos2D.Mutable();
        for (int x = 0; x < 32; ++x) {
            for (int z = 0; z < 32; ++z) {
                lowestPos.setPos(this.lowestX - 8 + x, this.lowestZ - 8 + z);
                consumer.accept(lowestPos);
            }
        }
    }

    public BlockPos2D getRandomCenterPos(Random random) {
        return new BlockPos2D(MathHelper.randomInt(this.lowestX, this.lowestX + 16, random), MathHelper.randomInt(this.lowestZ, this.lowestZ + 16, random));
    }

    public boolean containsPos(BlockPos2D pos) {
        return PosHelper.contains(this.lowestX - 8, this.lowestZ - 8, 32, pos.getBlockX(), pos.getBlockZ());
    }

    public boolean containsCenterPos(BlockPos2D pos) {
        return PosHelper.contains(this.lowestX, this.lowestZ, 16, pos.getBlockX(), pos.getBlockZ());
    }

    public String toString() {
        return String.format("InterChunkPos(x=%s z=%s)", this.getX(), this.getZ());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterChunkPos that = (InterChunkPos)o;
        return Objects.equals(this.lowestChunkPos, that.lowestChunkPos);
    }

    public int hashCode() {
        return this.lowestChunkPos.hashCode();
    }
}

