/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.pos;

import weightedgpa.infinibiome.api.pos.IntPosInfo;
import weightedgpa.infinibiome.internal.misc.Log2helper;
import weightedgpa.infinibiome.internal.misc.MathHelper;

public interface PosInfo<T> {
    public double getX(T var1);

    public double getZ(T var1);

    default public <O> O convert(T pos, IntPosInfo<O> otherPosInfo) {
        int resultX = MathHelper.floor(this.getX(pos));
        resultX -= otherPosInfo.getOffset();
        resultX = Log2helper.floorDiv(resultX, otherPosInfo.getLog2Scale());
        int resultZ = MathHelper.floor(this.getZ(pos));
        resultZ -= otherPosInfo.getOffset();
        resultZ = Log2helper.floorDiv(resultZ, otherPosInfo.getLog2Scale());
        return otherPosInfo.build(resultX, resultZ);
    }

    public T build(int var1, int var2);

    default public IntPosInfo<T> floor() {
        return new IntPosInfo<T>(){

            @Override
            public int getIntX(T pos) {
                return MathHelper.floor(PosInfo.this.getX(pos));
            }

            @Override
            public int getIntZ(T pos) {
                return MathHelper.floor((int)PosInfo.this.getZ(pos));
            }

            @Override
            public int getLog2Scale() {
                return 0;
            }

            @Override
            public T build(int x, int z) {
                return PosInfo.this.build(x, z);
            }
        };
    }
}

