/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.posdata;

import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class ClimateValue {
    private final double baseValue;
    private final int baseHeight;
    private final double changePerY;

    public ClimateValue(double baseValue, double changePerY) {
        this(63, baseValue, changePerY);
    }

    private ClimateValue(int baseHeight, double baseValue, double changePerY) {
        this.baseHeight = baseHeight;
        this.baseValue = baseValue;
        this.changePerY = changePerY;
    }

    public double fromHeight(double y) {
        double heightFromBase = y - (double)this.baseHeight;
        double result = heightFromBase < 0.0 ? this.baseValue : this.baseValue + heightFromBase * this.changePerY;
        return Interval.PERCENT.clamp(result);
    }

    public ClimateValue increase(double offset) {
        return new ClimateValue(this.baseHeight, this.baseValue + offset, this.changePerY);
    }
}

