/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.api.posdata;

public abstract class LandmassInfo {
    private LandmassInfo() {
    }

    public abstract double getTransitionToBeach();

    public boolean isLand() {
        return this instanceof Land;
    }

    public boolean isBeach() {
        return this instanceof Beach;
    }

    public boolean isOcean() {
        return this instanceof Ocean;
    }

    public static final class Ocean
    extends LandmassInfo {
        private final double transitionToBeach;

        public Ocean(double transitionToBeach) {
            this.transitionToBeach = transitionToBeach;
        }

        @Override
        public double getTransitionToBeach() {
            return this.transitionToBeach;
        }

        public String toString() {
            return "Ocean{transitionToBeach=" + this.transitionToBeach + '}';
        }
    }

    public static final class Beach
    extends LandmassInfo {
        private final double transitionToLand;

        public Beach(double transitionToLand) {
            this.transitionToLand = transitionToLand;
        }

        public double getTransitionToLand() {
            return this.transitionToLand;
        }

        public double getTransitionToOcean() {
            return 1.0 - this.transitionToLand;
        }

        @Override
        public double getTransitionToBeach() {
            return 1.0;
        }

        public String toString() {
            return "Beach{transitionToLand=" + this.transitionToLand + '}';
        }
    }

    public static final class Land
    extends LandmassInfo {
        private final double transitionToBeach;

        public Land(double transitionToBeach) {
            this.transitionToBeach = transitionToBeach;
        }

        @Override
        public double getTransitionToBeach() {
            return this.transitionToBeach;
        }

        public String toString() {
            return "Land{transitionToBeach=" + this.transitionToBeach + '}';
        }
    }
}

