/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.dependency;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import weightedgpa.infinibiome.api.dependency.DepKey;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;
import weightedgpa.infinibiome.api.dependency.DependencyModule;
import weightedgpa.infinibiome.api.dependency.MultiDep;
import weightedgpa.infinibiome.internal.dependency.ItemWrapper;

public final class DependencyInjectorImpl
implements DependencyInjector.Pre {
    final Map<DepKey<?>, ItemWrapper<?>> depKeyToItem = new HashMap();
    final List<ItemWrapper<?>> items = new ArrayList();
    final List<Consumer<DependencyInjector>> staticItems = new ArrayList<Consumer<DependencyInjector>>();
    final List<Predicate<MultiDep>> blackList = new ArrayList<Predicate<MultiDep>>();

    public DependencyInjectorImpl(List<DependencyModule> modules) {
        modules.forEach(m -> m.addToPre(this));
    }

    public <T> DependencyInjectorImpl addItem(DepKey<T> key, Function<DependencyInjector, T> toItem) {
        this.depKeyToItem.put(key, new ItemWrapper(key.innerClass, toItem));
        return this;
    }

    @Override
    public <T> DependencyInjectorImpl addItem(Class<T> clazz, Function<DependencyInjector, T> toItem) {
        ItemWrapper<T> item = new ItemWrapper<T>(clazz, toItem);
        this.items.add(item);
        return this;
    }

    @Override
    public <T, E> DependencyInjectorImpl addItems(Class<T> clazz, E[] enums, BiFunction<E, DependencyInjector, T> toItems) {
        for (Object e : enums) {
            this.items.add(new ItemWrapper<Object>(clazz, di -> toItems.apply(e, (DependencyInjector)di)));
        }
        return this;
    }

    @Override
    public DependencyInjectorImpl refresh(Consumer<DependencyInjector> func) {
        this.staticItems.add(func);
        return this;
    }

    @Override
    public DependencyInjectorImpl blacklist(Predicate<MultiDep> predicate) {
        this.blackList.add(predicate);
        return this;
    }

    public DependencyInjector initInjector() {
        return new Injector(false);
    }

    public DependencyInjector initInjectorIgnoreErrors() {
        return new Injector(true);
    }

    private class Injector
    implements DependencyInjector {
        final Deque<Class<?>> debugStack = new ArrayDeque();
        private final boolean ignoreErroredItem;

        Injector(boolean ignoreErroredItem) {
            this.ignoreErroredItem = ignoreErroredItem;
        }

        @Override
        public synchronized <T> T get(Class<T> clazz) {
            T result = null;
            for (ItemWrapper<Object> itemWrapper : DependencyInjectorImpl.this.items) {
                Object innerItem;
                if (!itemWrapper.isRequested(clazz) || (innerItem = itemWrapper.getInner(this, this.ignoreErroredItem, this.debugStack)) == null) continue;
                if (result != null) {
                    throw new RuntimeException("there must only be one instance of " + clazz);
                }
                result = (T)innerItem;
            }
            if (result == null) {
                throw new RuntimeException("there is not instance of " + clazz);
            }
            return result;
        }

        @Override
        public synchronized <T extends MultiDep> List<T> getAll(Class<T> clazz) {
            ArrayList<MultiDep> result = new ArrayList<MultiDep>();
            for (ItemWrapper<Object> itemWrapper : DependencyInjectorImpl.this.items) {
                MultiDep innerItem;
                if (!itemWrapper.isRequested(clazz) || (innerItem = (MultiDep)itemWrapper.getInner(this, this.ignoreErroredItem, this.debugStack)) == null || this.isBlackListed(innerItem)) continue;
                result.add(innerItem);
            }
            return result;
        }

        @Override
        public synchronized void refreshStaticItems() {
            DependencyInjectorImpl.this.staticItems.forEach(p -> p.accept(this));
        }

        private boolean isBlackListed(MultiDep item) {
            for (Predicate<MultiDep> blackList : DependencyInjectorImpl.this.blackList) {
                if (!blackList.test(item)) continue;
                return true;
            }
            return false;
        }
    }
}

