/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.dependency;

import java.util.Deque;
import java.util.function.Function;
import javax.annotation.Nullable;
import weightedgpa.infinibiome.api.dependency.DependencyInjector;

final class ItemWrapper<T> {
    private final Class<? extends T> clazz;
    private final Function<DependencyInjector, T> toItemFunc;
    @Nullable
    private T finished = null;
    private boolean errored = false;

    ItemWrapper(Class<T> clazz, Function<DependencyInjector, T> toItemFunc) {
        this.clazz = clazz;
        this.toItemFunc = toItemFunc;
    }

    boolean isRequested(Class<?> requestedClass) {
        return requestedClass.isAssignableFrom(this.clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    synchronized T getInner(DependencyInjector di, boolean ignoreError, Deque<Class<?>> debugStack) {
        block8: {
            if (debugStack.contains(this.clazz)) {
                throw new RuntimeException("circular dependency detected: " + debugStack);
            }
            if (this.finished == null && !this.errored) {
                debugStack.push(this.clazz);
                try {
                    this.finished = this.toItemFunc.apply(di);
                }
                catch (Throwable e) {
                    if (ignoreError) {
                        this.finished = null;
                        this.errored = true;
                        break block8;
                    }
                    throw e;
                }
                finally {
                    debugStack.pop();
                }
            }
        }
        return this.finished;
    }

    public String toString() {
        return "Item{clazz=" + this.clazz.getSimpleName() + ", id=" + Integer.toHexString(System.identityHashCode(this)) + '}';
    }
}

