/*
 * Decompiled with CFR 0.152.
 */
package weightedgpa.infinibiome.internal.display;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import weightedgpa.infinibiome.api.pos.BlockPos2D;
import weightedgpa.infinibiome.api.posdata.LandmassInfo;
import weightedgpa.infinibiome.api.posdata.PosDataHelper;
import weightedgpa.infinibiome.api.posdata.PosDataKeys;
import weightedgpa.infinibiome.internal.display.DataMapBase;
import weightedgpa.infinibiome.internal.floatfunc.util.Interval;

public final class BiomeMap
extends DataMapBase {
    private static final Map<Interval, Color> tempToColor = new HashMap<Interval, Color>();
    private static final Map<Interval, Color> humdToColor = new HashMap<Interval, Color>();
    private static final Map<Biome, Color> biomeToColor = new HashMap<Biome, Color>();
    Map<Class<LandmassInfo>, Integer> counter = new ConcurrentHashMap<Class<LandmassInfo>, Integer>();

    public BiomeMap() {
        this(10, "2");
    }

    @Override
    protected void onFinished() {
        int total = 0;
        for (Class<LandmassInfo> c : this.counter.keySet()) {
            total += this.counter.get(c).intValue();
        }
        for (Class<LandmassInfo> c : this.counter.keySet()) {
            System.out.println(c + " " + (double)this.counter.get(c).intValue() / (double)total);
        }
    }

    private BiomeMap(int scale, String seedBranch) {
        super(scale, seedBranch);
        this.setSize(800, 800);
    }

    private static void initTempMap() {
        tempToColor.put(PosDataHelper.FREEZE_INTERVAL, new Color(255, 255, 255));
        tempToColor.put(PosDataHelper.COLD_INTERVAL, new Color(70, 100, 100));
        tempToColor.put(PosDataHelper.WARM_INTERVAL, new Color(0, 150, 0));
        tempToColor.put(PosDataHelper.HOT_INTERVAL, new Color(0, 70, 0));
    }

    private static void initHumdMap() {
        humdToColor.put(PosDataHelper.DRY_INTERVAL, new Color(250, 200, 0));
        humdToColor.put(PosDataHelper.SEMI_DRY_INTERVAL, new Color(150, 200, 0));
        humdToColor.put(PosDataHelper.SEMI_WET_INTERVAL, new Color(100, 255, 0));
        humdToColor.put(PosDataHelper.WET_INTERVAL, new Color(0, 70, 0));
    }

    private static void initBiomeMap() {
        biomeToColor.put(Biomes.field_76789_p, new Color(120, 0, 120));
        biomeToColor.put(Biomes.field_76788_q, new Color(50, 0, 100));
        biomeToColor.put(Biomes.field_76781_i, new Color(0, 0, 255));
        biomeToColor.put(Biomes.field_76777_m, new Color(0, 255, 255));
        biomeToColor.put(Biomes.field_76787_r, new Color(255, 255, 0));
        biomeToColor.put(Biomes.field_150577_O, new Color(255, 255, 0));
        biomeToColor.put(Biomes.field_76771_b, new Color(0, 0, 255));
        biomeToColor.put(Biomes.field_150575_M, new Color(0, 0, 100));
    }

    @Override
    protected Color getColor(int posX, int posZ, int screenPixelX, int screenPixelZ) {
        if (posX == 0 && posZ == 0) {
            return Color.RED;
        }
        if (posX % 1000 == 0 || posZ % 1000 == 0) {
            return Color.BLACK;
        }
        LandmassInfo landmassInfo = this.posData.get(PosDataKeys.LANDMASS_TYPE, new BlockPos2D(posX, posZ));
        this.counter.put(landmassInfo.getClass(), this.counter.getOrDefault(landmassInfo.getClass(), 0) + 1);
        if (landmassInfo.isBeach()) {
            return Color.YELLOW;
        }
        if (landmassInfo.isLand()) {
            return new Color(0.0f, (float)(1.0 - landmassInfo.getTransitionToBeach()), 0.0f);
        }
        return new Color(0.0f, 0.0f, (float)(1.0 - landmassInfo.getTransitionToBeach()));
    }

    Color getFromClimateValue(double climateValue, Map<Interval, Color> map) {
        for (Map.Entry<Interval, Color> e : map.entrySet()) {
            if (!e.getKey().contains(climateValue)) continue;
            return e.getValue();
        }
        return Color.BLACK;
    }

    static {
        BiomeMap.initTempMap();
        BiomeMap.initHumdMap();
        BiomeMap.initBiomeMap();
    }
}

